# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetComputeImageCapabilitySchemasResult',
    'AwaitableGetComputeImageCapabilitySchemasResult',
    'get_compute_image_capability_schemas',
    'get_compute_image_capability_schemas_output',
]

@pulumi.output_type
class GetComputeImageCapabilitySchemasResult:
    """
    A collection of values returned by getComputeImageCapabilitySchemas.
    """
    def __init__(__self__, compartment_id=None, compute_image_capability_schemas=None, display_name=None, filters=None, id=None, image_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_image_capability_schemas and not isinstance(compute_image_capability_schemas, list):
            raise TypeError("Expected argument 'compute_image_capability_schemas' to be a list")
        pulumi.set(__self__, "compute_image_capability_schemas", compute_image_capability_schemas)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment containing the compute global image capability schema
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeImageCapabilitySchemas")
    def compute_image_capability_schemas(self) -> Sequence['outputs.GetComputeImageCapabilitySchemasComputeImageCapabilitySchemaResult']:
        """
        The list of compute_image_capability_schemas.
        """
        return pulumi.get(self, "compute_image_capability_schemas")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetComputeImageCapabilitySchemasFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        The OCID of the image associated with this compute image capability schema
        """
        return pulumi.get(self, "image_id")


class AwaitableGetComputeImageCapabilitySchemasResult(GetComputeImageCapabilitySchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeImageCapabilitySchemasResult(
            compartment_id=self.compartment_id,
            compute_image_capability_schemas=self.compute_image_capability_schemas,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            image_id=self.image_id)


def get_compute_image_capability_schemas(compartment_id: Optional[str] = None,
                                         display_name: Optional[str] = None,
                                         filters: Optional[Sequence[pulumi.InputType['GetComputeImageCapabilitySchemasFilterArgs']]] = None,
                                         image_id: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeImageCapabilitySchemasResult:
    """
    This data source provides the list of Compute Image Capability Schemas in Oracle Cloud Infrastructure Core service.

    Lists Compute Image Capability Schema in the specified compartment. You can also query by a specific imageId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_image_capability_schemas = oci.Core.get_compute_image_capability_schemas(compartment_id=compartment_id,
        display_name=compute_image_capability_schema_display_name,
        image_id=test_image["id"])
    ```


    :param str compartment_id: A filter to return only resources that match the given compartment OCID exactly.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an image.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeImageCapabilitySchemas:getComputeImageCapabilitySchemas', __args__, opts=opts, typ=GetComputeImageCapabilitySchemasResult).value

    return AwaitableGetComputeImageCapabilitySchemasResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_image_capability_schemas=pulumi.get(__ret__, 'compute_image_capability_schemas'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'))


@_utilities.lift_output_func(get_compute_image_capability_schemas)
def get_compute_image_capability_schemas_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetComputeImageCapabilitySchemasFilterArgs']]]]] = None,
                                                image_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetComputeImageCapabilitySchemasResult]:
    """
    This data source provides the list of Compute Image Capability Schemas in Oracle Cloud Infrastructure Core service.

    Lists Compute Image Capability Schema in the specified compartment. You can also query by a specific imageId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_image_capability_schemas = oci.Core.get_compute_image_capability_schemas(compartment_id=compartment_id,
        display_name=compute_image_capability_schema_display_name,
        image_id=test_image["id"])
    ```


    :param str compartment_id: A filter to return only resources that match the given compartment OCID exactly.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an image.
    """
    ...
