# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 database: pulumi.Input['DatabaseDatabaseArgs'],
                 db_home_id: pulumi.Input[str],
                 source: pulumi.Input[str],
                 db_version: Optional[pulumi.Input[str]] = None,
                 key_store_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_migration: Optional[pulumi.Input[bool]] = None,
                 kms_key_rotation: Optional[pulumi.Input[int]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input['DatabaseDatabaseArgs'] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[bool] kms_key_migration: The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        :param pulumi.Input[int] kms_key_rotation: The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "db_home_id", db_home_id)
        pulumi.set(__self__, "source", source)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_migration is not None:
            pulumi.set(__self__, "kms_key_migration", kms_key_migration)
        if kms_key_rotation is not None:
            pulumi.set(__self__, "kms_key_rotation", kms_key_rotation)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input['DatabaseDatabaseArgs']:
        """
        (Updatable) Details for creating a database.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input['DatabaseDatabaseArgs']):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @db_home_id.setter
    def db_home_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_home_id", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyMigration")
    def kms_key_migration(self) -> Optional[pulumi.Input[bool]]:
        """
        The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        """
        return pulumi.get(self, "kms_key_migration")

    @kms_key_migration.setter
    def kms_key_migration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kms_key_migration", value)

    @property
    @pulumi.getter(name="kmsKeyRotation")
    def kms_key_rotation(self) -> Optional[pulumi.Input[int]]:
        """
        The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        """
        return pulumi.get(self, "kms_key_rotation")

    @kms_key_rotation.setter
    def kms_key_rotation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "kms_key_rotation", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseConnectionStringArgs']]]] = None,
                 database: Optional[pulumi.Input['DatabaseDatabaseArgs']] = None,
                 database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseDatabaseManagementConfigArgs']]]] = None,
                 database_software_image_id: Optional[pulumi.Input[str]] = None,
                 db_backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseDbBackupConfigArgs']]]] = None,
                 db_home_id: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 db_workload: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_cdb: Optional[pulumi.Input[bool]] = None,
                 key_store_id: Optional[pulumi.Input[str]] = None,
                 key_store_wallet_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_migration: Optional[pulumi.Input[bool]] = None,
                 kms_key_rotation: Optional[pulumi.Input[int]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 last_backup_duration_in_seconds: Optional[pulumi.Input[int]] = None,
                 last_backup_timestamp: Optional[pulumi.Input[str]] = None,
                 last_failed_backup_timestamp: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 pdb_name: Optional[pulumi.Input[str]] = None,
                 sid_prefix: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_database_point_in_time_recovery_timestamp: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[str] character_set: The character set for the database.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseConnectionStringArgs']]] connection_strings: The Connection strings used to connect to the Oracle Database.
        :param pulumi.Input['DatabaseDatabaseArgs'] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseDatabaseManagementConfigArgs']]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseDbBackupConfigArgs']]] db_backup_configs: Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        :param pulumi.Input[str] db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        :param pulumi.Input[str] db_name: The database name.
        :param pulumi.Input[str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[str] db_unique_name: A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        :param pulumi.Input[str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] db_workload: **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_cdb: True if the database is a container database.
        :param pulumi.Input[str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        :param pulumi.Input[str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[bool] kms_key_migration: The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        :param pulumi.Input[int] kms_key_rotation: The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[int] last_backup_duration_in_seconds: The duration when the latest database backup created.
        :param pulumi.Input[str] last_backup_timestamp: The date and time when the latest database backup was created.
        :param pulumi.Input[str] last_failed_backup_timestamp: The date and time when the latest database backup failed.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] ncharacter_set: The national character set for the database.
        :param pulumi.Input[str] pdb_name: The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        :param pulumi.Input[str] sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] source_database_point_in_time_recovery_timestamp: Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] state: The current state of the database.
        :param pulumi.Input[str] time_created: The date and time the database was created.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if database_management_configs is not None:
            pulumi.set(__self__, "database_management_configs", database_management_configs)
        if database_software_image_id is not None:
            pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_backup_configs is not None:
            pulumi.set(__self__, "db_backup_configs", db_backup_configs)
        if db_home_id is not None:
            pulumi.set(__self__, "db_home_id", db_home_id)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_unique_name is not None:
            pulumi.set(__self__, "db_unique_name", db_unique_name)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if db_workload is not None:
            pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_cdb is not None:
            pulumi.set(__self__, "is_cdb", is_cdb)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name is not None:
            pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_migration is not None:
            pulumi.set(__self__, "kms_key_migration", kms_key_migration)
        if kms_key_rotation is not None:
            pulumi.set(__self__, "kms_key_rotation", kms_key_rotation)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if last_backup_duration_in_seconds is not None:
            pulumi.set(__self__, "last_backup_duration_in_seconds", last_backup_duration_in_seconds)
        if last_backup_timestamp is not None:
            pulumi.set(__self__, "last_backup_timestamp", last_backup_timestamp)
        if last_failed_backup_timestamp is not None:
            pulumi.set(__self__, "last_failed_backup_timestamp", last_failed_backup_timestamp)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ncharacter_set is not None:
            pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if pdb_name is not None:
            pulumi.set(__self__, "pdb_name", pdb_name)
        if sid_prefix is not None:
            pulumi.set(__self__, "sid_prefix", sid_prefix)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_database_point_in_time_recovery_timestamp is not None:
            pulumi.set(__self__, "source_database_point_in_time_recovery_timestamp", source_database_point_in_time_recovery_timestamp)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if vm_cluster_id is not None:
            pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[str]]:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseConnectionStringArgs']]]]:
        """
        The Connection strings used to connect to the Oracle Database.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['DatabaseDatabaseArgs']]:
        """
        (Updatable) Details for creating a database.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['DatabaseDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseDatabaseManagementConfigArgs']]]]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @database_management_configs.setter
    def database_management_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseDatabaseManagementConfigArgs']]]]):
        pulumi.set(self, "database_management_configs", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @database_software_image_id.setter
    def database_software_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_software_image_id", value)

    @property
    @pulumi.getter(name="dbBackupConfigs")
    def db_backup_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseDbBackupConfigArgs']]]]:
        """
        Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        """
        return pulumi.get(self, "db_backup_configs")

    @db_backup_configs.setter
    def db_backup_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseDbBackupConfigArgs']]]]):
        pulumi.set(self, "db_backup_configs", value)

    @property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @db_home_id.setter
    def db_home_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_home_id", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[pulumi.Input[str]]:
        """
        **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_workload", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isCdb")
    def is_cdb(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the database is a container database.
        """
        return pulumi.get(self, "is_cdb")

    @is_cdb.setter
    def is_cdb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cdb", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @key_store_wallet_name.setter
    def key_store_wallet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_wallet_name", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyMigration")
    def kms_key_migration(self) -> Optional[pulumi.Input[bool]]:
        """
        The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        """
        return pulumi.get(self, "kms_key_migration")

    @kms_key_migration.setter
    def kms_key_migration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kms_key_migration", value)

    @property
    @pulumi.getter(name="kmsKeyRotation")
    def kms_key_rotation(self) -> Optional[pulumi.Input[int]]:
        """
        The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        """
        return pulumi.get(self, "kms_key_rotation")

    @kms_key_rotation.setter
    def kms_key_rotation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "kms_key_rotation", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="lastBackupDurationInSeconds")
    def last_backup_duration_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The duration when the latest database backup created.
        """
        return pulumi.get(self, "last_backup_duration_in_seconds")

    @last_backup_duration_in_seconds.setter
    def last_backup_duration_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "last_backup_duration_in_seconds", value)

    @property
    @pulumi.getter(name="lastBackupTimestamp")
    def last_backup_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the latest database backup was created.
        """
        return pulumi.get(self, "last_backup_timestamp")

    @last_backup_timestamp.setter
    def last_backup_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_timestamp", value)

    @property
    @pulumi.getter(name="lastFailedBackupTimestamp")
    def last_failed_backup_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the latest database backup failed.
        """
        return pulumi.get(self, "last_failed_backup_timestamp")

    @last_failed_backup_timestamp.setter
    def last_failed_backup_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_failed_backup_timestamp", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[str]]:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        """
        return pulumi.get(self, "pdb_name")

    @pdb_name.setter
    def pdb_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pdb_name", value)

    @property
    @pulumi.getter(name="sidPrefix")
    def sid_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "sid_prefix")

    @sid_prefix.setter
    def sid_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sid_prefix", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceDatabasePointInTimeRecoveryTimestamp")
    def source_database_point_in_time_recovery_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "source_database_point_in_time_recovery_timestamp")

    @source_database_point_in_time_recovery_timestamp.setter
    def source_database_point_in_time_recovery_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_database_point_in_time_recovery_timestamp", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_cluster_id", value)


class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[pulumi.InputType['DatabaseDatabaseArgs']]] = None,
                 db_home_id: Optional[pulumi.Input[str]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 key_store_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_migration: Optional[pulumi.Input[bool]] = None,
                 kms_key_rotation: Optional[pulumi.Input[int]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Database resource in Oracle Cloud Infrastructure Database service.

        Creates a new database in the specified Database Home. If the database version is provided, it must match the version of the Database Home. Applies only to Exadata systems.

        **Important:** When `auto_backup_enabled` is not present in the configuration or set to true, the `auto_backup_window` and `auto_full_backup_window` will be ignored

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database = oci.database.Database("test_database",
            database=oci.database.DatabaseDatabaseArgs(
                admin_password=database_database_admin_password,
                db_name=database_database_db_name,
                backup_id=test_backup["id"],
                backup_tde_password=database_database_backup_tde_password,
                character_set=database_database_character_set,
                database_software_image_id=test_database_software_image["id"],
                db_backup_config=oci.database.DatabaseDatabaseDbBackupConfigArgs(
                    auto_backup_enabled=database_database_db_backup_config_auto_backup_enabled,
                    auto_backup_window=database_database_db_backup_config_auto_backup_window,
                    auto_full_backup_day=database_database_db_backup_config_auto_full_backup_day,
                    auto_full_backup_window=database_database_db_backup_config_auto_full_backup_window,
                    backup_deletion_policy=database_database_db_backup_config_backup_deletion_policy,
                    backup_destination_details=[oci.database.DatabaseDatabaseDbBackupConfigBackupDestinationDetailArgs(
                        dbrs_policy_id=test_policy["id"],
                        id=database_database_db_backup_config_backup_destination_details_id,
                        type=database_database_db_backup_config_backup_destination_details_type,
                    )],
                    recovery_window_in_days=database_database_db_backup_config_recovery_window_in_days,
                    run_immediate_full_backup=database_database_db_backup_config_run_immediate_full_backup,
                ),
                db_unique_name=database_database_db_unique_name,
                db_workload=database_database_db_workload,
                defined_tags=database_database_defined_tags,
                freeform_tags=database_database_freeform_tags,
                kms_key_id=test_key["id"],
                kms_key_version_id=test_key_version["id"],
                ncharacter_set=database_database_ncharacter_set,
                pdb_name=database_database_pdb_name,
                pluggable_databases=database_database_pluggable_databases,
                sid_prefix=database_database_sid_prefix,
                tde_wallet_password=database_database_tde_wallet_password,
                vault_id=test_vault["id"],
            ),
            db_home_id=test_db_home["id"],
            source=database_source,
            db_version=database_db_version,
            kms_key_id=test_key["id"],
            kms_key_version_id=test_key_version["id"])
        ```

        ## Import

        Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/database:Database test_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseDatabaseArgs']] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        :param pulumi.Input[str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[bool] kms_key_migration: The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        :param pulumi.Input[int] kms_key_rotation: The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Database resource in Oracle Cloud Infrastructure Database service.

        Creates a new database in the specified Database Home. If the database version is provided, it must match the version of the Database Home. Applies only to Exadata systems.

        **Important:** When `auto_backup_enabled` is not present in the configuration or set to true, the `auto_backup_window` and `auto_full_backup_window` will be ignored

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_database = oci.database.Database("test_database",
            database=oci.database.DatabaseDatabaseArgs(
                admin_password=database_database_admin_password,
                db_name=database_database_db_name,
                backup_id=test_backup["id"],
                backup_tde_password=database_database_backup_tde_password,
                character_set=database_database_character_set,
                database_software_image_id=test_database_software_image["id"],
                db_backup_config=oci.database.DatabaseDatabaseDbBackupConfigArgs(
                    auto_backup_enabled=database_database_db_backup_config_auto_backup_enabled,
                    auto_backup_window=database_database_db_backup_config_auto_backup_window,
                    auto_full_backup_day=database_database_db_backup_config_auto_full_backup_day,
                    auto_full_backup_window=database_database_db_backup_config_auto_full_backup_window,
                    backup_deletion_policy=database_database_db_backup_config_backup_deletion_policy,
                    backup_destination_details=[oci.database.DatabaseDatabaseDbBackupConfigBackupDestinationDetailArgs(
                        dbrs_policy_id=test_policy["id"],
                        id=database_database_db_backup_config_backup_destination_details_id,
                        type=database_database_db_backup_config_backup_destination_details_type,
                    )],
                    recovery_window_in_days=database_database_db_backup_config_recovery_window_in_days,
                    run_immediate_full_backup=database_database_db_backup_config_run_immediate_full_backup,
                ),
                db_unique_name=database_database_db_unique_name,
                db_workload=database_database_db_workload,
                defined_tags=database_database_defined_tags,
                freeform_tags=database_database_freeform_tags,
                kms_key_id=test_key["id"],
                kms_key_version_id=test_key_version["id"],
                ncharacter_set=database_database_ncharacter_set,
                pdb_name=database_database_pdb_name,
                pluggable_databases=database_database_pluggable_databases,
                sid_prefix=database_database_sid_prefix,
                tde_wallet_password=database_database_tde_wallet_password,
                vault_id=test_vault["id"],
            ),
            db_home_id=test_db_home["id"],
            source=database_source,
            db_version=database_db_version,
            kms_key_id=test_key["id"],
            kms_key_version_id=test_key_version["id"])
        ```

        ## Import

        Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/database:Database test_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[pulumi.InputType['DatabaseDatabaseArgs']]] = None,
                 db_home_id: Optional[pulumi.Input[str]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 key_store_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_migration: Optional[pulumi.Input[bool]] = None,
                 kms_key_rotation: Optional[pulumi.Input[int]] = None,
                 kms_key_version_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            if db_home_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_home_id'")
            __props__.__dict__["db_home_id"] = db_home_id
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["key_store_id"] = key_store_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["kms_key_migration"] = kms_key_migration
            __props__.__dict__["kms_key_rotation"] = kms_key_rotation
            __props__.__dict__["kms_key_version_id"] = kms_key_version_id
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["character_set"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["database_management_configs"] = None
            __props__.__dict__["database_software_image_id"] = None
            __props__.__dict__["db_backup_configs"] = None
            __props__.__dict__["db_name"] = None
            __props__.__dict__["db_system_id"] = None
            __props__.__dict__["db_unique_name"] = None
            __props__.__dict__["db_workload"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_cdb"] = None
            __props__.__dict__["key_store_wallet_name"] = None
            __props__.__dict__["last_backup_duration_in_seconds"] = None
            __props__.__dict__["last_backup_timestamp"] = None
            __props__.__dict__["last_failed_backup_timestamp"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ncharacter_set"] = None
            __props__.__dict__["pdb_name"] = None
            __props__.__dict__["sid_prefix"] = None
            __props__.__dict__["source_database_point_in_time_recovery_timestamp"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vm_cluster_id"] = None
        super(Database, __self__).__init__(
            'oci:Database/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseConnectionStringArgs']]]]] = None,
            database: Optional[pulumi.Input[pulumi.InputType['DatabaseDatabaseArgs']]] = None,
            database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseDatabaseManagementConfigArgs']]]]] = None,
            database_software_image_id: Optional[pulumi.Input[str]] = None,
            db_backup_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseDbBackupConfigArgs']]]]] = None,
            db_home_id: Optional[pulumi.Input[str]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            db_system_id: Optional[pulumi.Input[str]] = None,
            db_unique_name: Optional[pulumi.Input[str]] = None,
            db_version: Optional[pulumi.Input[str]] = None,
            db_workload: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_cdb: Optional[pulumi.Input[bool]] = None,
            key_store_id: Optional[pulumi.Input[str]] = None,
            key_store_wallet_name: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            kms_key_migration: Optional[pulumi.Input[bool]] = None,
            kms_key_rotation: Optional[pulumi.Input[int]] = None,
            kms_key_version_id: Optional[pulumi.Input[str]] = None,
            last_backup_duration_in_seconds: Optional[pulumi.Input[int]] = None,
            last_backup_timestamp: Optional[pulumi.Input[str]] = None,
            last_failed_backup_timestamp: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            ncharacter_set: Optional[pulumi.Input[str]] = None,
            pdb_name: Optional[pulumi.Input[str]] = None,
            sid_prefix: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            source_database_point_in_time_recovery_timestamp: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            vault_id: Optional[pulumi.Input[str]] = None,
            vm_cluster_id: Optional[pulumi.Input[str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] character_set: The character set for the database.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseConnectionStringArgs']]]] connection_strings: The Connection strings used to connect to the Oracle Database.
        :param pulumi.Input[pulumi.InputType['DatabaseDatabaseArgs']] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseDatabaseManagementConfigArgs']]]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseDbBackupConfigArgs']]]] db_backup_configs: Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        :param pulumi.Input[str] db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        :param pulumi.Input[str] db_name: The database name.
        :param pulumi.Input[str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[str] db_unique_name: A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        :param pulumi.Input[str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[str] db_workload: **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_cdb: True if the database is a container database.
        :param pulumi.Input[str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        :param pulumi.Input[str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[bool] kms_key_migration: The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        :param pulumi.Input[int] kms_key_rotation: The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        :param pulumi.Input[str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[int] last_backup_duration_in_seconds: The duration when the latest database backup created.
        :param pulumi.Input[str] last_backup_timestamp: The date and time when the latest database backup was created.
        :param pulumi.Input[str] last_failed_backup_timestamp: The date and time when the latest database backup failed.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] ncharacter_set: The national character set for the database.
        :param pulumi.Input[str] pdb_name: The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        :param pulumi.Input[str] sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[str] source: The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] source_database_point_in_time_recovery_timestamp: Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] state: The current state of the database.
        :param pulumi.Input[str] time_created: The date and time the database was created.
        :param pulumi.Input[str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        :param pulumi.Input[str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["database"] = database
        __props__.__dict__["database_management_configs"] = database_management_configs
        __props__.__dict__["database_software_image_id"] = database_software_image_id
        __props__.__dict__["db_backup_configs"] = db_backup_configs
        __props__.__dict__["db_home_id"] = db_home_id
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["db_unique_name"] = db_unique_name
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["db_workload"] = db_workload
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_cdb"] = is_cdb
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_wallet_name"] = key_store_wallet_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_migration"] = kms_key_migration
        __props__.__dict__["kms_key_rotation"] = kms_key_rotation
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["last_backup_duration_in_seconds"] = last_backup_duration_in_seconds
        __props__.__dict__["last_backup_timestamp"] = last_backup_timestamp
        __props__.__dict__["last_failed_backup_timestamp"] = last_failed_backup_timestamp
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["ncharacter_set"] = ncharacter_set
        __props__.__dict__["pdb_name"] = pdb_name
        __props__.__dict__["sid_prefix"] = sid_prefix
        __props__.__dict__["source"] = source
        __props__.__dict__["source_database_point_in_time_recovery_timestamp"] = source_database_point_in_time_recovery_timestamp
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["vm_cluster_id"] = vm_cluster_id
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[str]:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.DatabaseConnectionString']]:
        """
        The Connection strings used to connect to the Oracle Database.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output['outputs.DatabaseDatabase']:
        """
        (Updatable) Details for creating a database.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> pulumi.Output[Sequence['outputs.DatabaseDatabaseManagementConfig']]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> pulumi.Output[str]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter(name="dbBackupConfigs")
    def db_backup_configs(self) -> pulumi.Output[Sequence['outputs.DatabaseDbBackupConfig']]:
        """
        Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        """
        return pulumi.get(self, "db_backup_configs")

    @property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Output[str]:
        """
        A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[str]:
        """
        A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Output[str]:
        """
        **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isCdb")
    def is_cdb(self) -> pulumi.Output[bool]:
        """
        True if the database is a container database.
        """
        return pulumi.get(self, "is_cdb")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> pulumi.Output[str]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyMigration")
    def kms_key_migration(self) -> pulumi.Output[Optional[bool]]:
        """
        The value to migrate to the kms version from none. Can only use once by setting value to true. You can not switch back to non-kms once you created or migrated.(https://www.oracle.com/security/cloud-security/key-management/faq/)
        """
        return pulumi.get(self, "kms_key_migration")

    @property
    @pulumi.getter(name="kmsKeyRotation")
    def kms_key_rotation(self) -> pulumi.Output[Optional[int]]:
        """
        The value to rotate the key version of current kms_key. Just change this value will trigger the rotation.
        """
        return pulumi.get(self, "kms_key_rotation")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lastBackupDurationInSeconds")
    def last_backup_duration_in_seconds(self) -> pulumi.Output[int]:
        """
        The duration when the latest database backup created.
        """
        return pulumi.get(self, "last_backup_duration_in_seconds")

    @property
    @pulumi.getter(name="lastBackupTimestamp")
    def last_backup_timestamp(self) -> pulumi.Output[str]:
        """
        The date and time when the latest database backup was created.
        """
        return pulumi.get(self, "last_backup_timestamp")

    @property
    @pulumi.getter(name="lastFailedBackupTimestamp")
    def last_failed_backup_timestamp(self) -> pulumi.Output[str]:
        """
        The date and time when the latest database backup failed.
        """
        return pulumi.get(self, "last_failed_backup_timestamp")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Output[str]:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> pulumi.Output[str]:
        """
        The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        """
        return pulumi.get(self, "pdb_name")

    @property
    @pulumi.getter(name="sidPrefix")
    def sid_prefix(self) -> pulumi.Output[str]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "sid_prefix")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source of the database: Use `NONE` for creating a new database. Use `DB_BACKUP` for creating a new database by restoring from a backup. The default is `NONE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceDatabasePointInTimeRecoveryTimestamp")
    def source_database_point_in_time_recovery_timestamp(self) -> pulumi.Output[str]:
        """
        Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "source_database_point_in_time_recovery_timestamp")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

