# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEnrollmentStatusesResult',
    'AwaitableGetEnrollmentStatusesResult',
    'get_enrollment_statuses',
    'get_enrollment_statuses_output',
]

@pulumi.output_type
class GetEnrollmentStatusesResult:
    """
    A collection of values returned by getEnrollmentStatuses.
    """
    def __init__(__self__, compartment_id=None, enrollment_status_collections=None, filters=None, id=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if enrollment_status_collections and not isinstance(enrollment_status_collections, list):
            raise TypeError("Expected argument 'enrollment_status_collections' to be a list")
        pulumi.set(__self__, "enrollment_status_collections", enrollment_status_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="enrollmentStatusCollections")
    def enrollment_status_collections(self) -> Sequence['outputs.GetEnrollmentStatusesEnrollmentStatusCollectionResult']:
        """
        The list of enrollment_status_collection.
        """
        return pulumi.get(self, "enrollment_status_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEnrollmentStatusesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The enrollment status' current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current Cloud Advisor enrollment status.
        """
        return pulumi.get(self, "status")


class AwaitableGetEnrollmentStatusesResult(GetEnrollmentStatusesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnrollmentStatusesResult(
            compartment_id=self.compartment_id,
            enrollment_status_collections=self.enrollment_status_collections,
            filters=self.filters,
            id=self.id,
            state=self.state,
            status=self.status)


def get_enrollment_statuses(compartment_id: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetEnrollmentStatusesFilterArgs']]] = None,
                            state: Optional[str] = None,
                            status: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnrollmentStatusesResult:
    """
    This data source provides the list of Enrollment Statuses in Oracle Cloud Infrastructure Optimizer service.

    Lists the Cloud Advisor enrollment statuses.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enrollment_statuses = oci.Optimizer.get_enrollment_statuses(compartment_id=compartment_id,
        state=enrollment_status_state,
        status=enrollment_status_status)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str state: A filter that returns results that match the lifecycle state specified.
    :param str status: A filter that returns results that match the Cloud Advisor enrollment status specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getEnrollmentStatuses:getEnrollmentStatuses', __args__, opts=opts, typ=GetEnrollmentStatusesResult).value

    return AwaitableGetEnrollmentStatusesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        enrollment_status_collections=pulumi.get(__ret__, 'enrollment_status_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_enrollment_statuses)
def get_enrollment_statuses_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEnrollmentStatusesFilterArgs']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   status: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnrollmentStatusesResult]:
    """
    This data source provides the list of Enrollment Statuses in Oracle Cloud Infrastructure Optimizer service.

    Lists the Cloud Advisor enrollment statuses.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_enrollment_statuses = oci.Optimizer.get_enrollment_statuses(compartment_id=compartment_id,
        state=enrollment_status_state,
        status=enrollment_status_status)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str state: A filter that returns results that match the lifecycle state specified.
    :param str status: A filter that returns results that match the Cloud Advisor enrollment status specified.
    """
    ...
