# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEntitlementsResult',
    'AwaitableGetEntitlementsResult',
    'get_entitlements',
    'get_entitlements_output',
]

@pulumi.output_type
class GetEntitlementsResult:
    """
    A collection of values returned by getEntitlements.
    """
    def __init__(__self__, compartment_id=None, csi=None, entitlement_collections=None, filters=None, id=None, vendor_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if csi and not isinstance(csi, str):
            raise TypeError("Expected argument 'csi' to be a str")
        pulumi.set(__self__, "csi", csi)
        if entitlement_collections and not isinstance(entitlement_collections, list):
            raise TypeError("Expected argument 'entitlement_collections' to be a list")
        pulumi.set(__self__, "entitlement_collections", entitlement_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if vendor_name and not isinstance(vendor_name, str):
            raise TypeError("Expected argument 'vendor_name' to be a str")
        pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy containing the entitlement.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def csi(self) -> Optional[str]:
        """
        The Customer Support Identifier (CSI) which unlocks the software sources. The CSI is is a unique key given to a customer and it uniquely identifies the entitlement.
        """
        return pulumi.get(self, "csi")

    @property
    @pulumi.getter(name="entitlementCollections")
    def entitlement_collections(self) -> Sequence['outputs.GetEntitlementsEntitlementCollectionResult']:
        """
        The list of entitlement_collection.
        """
        return pulumi.get(self, "entitlement_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEntitlementsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[str]:
        """
        The vendor for the entitlement.
        """
        return pulumi.get(self, "vendor_name")


class AwaitableGetEntitlementsResult(GetEntitlementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntitlementsResult(
            compartment_id=self.compartment_id,
            csi=self.csi,
            entitlement_collections=self.entitlement_collections,
            filters=self.filters,
            id=self.id,
            vendor_name=self.vendor_name)


def get_entitlements(compartment_id: Optional[str] = None,
                     csi: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetEntitlementsFilterArgs']]] = None,
                     vendor_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntitlementsResult:
    """
    This data source provides the list of Entitlements in Oracle Cloud Infrastructure Os Management Hub service.

    Lists entitlements in the specified tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against a variety of criteria including but
    not limited to its Customer Support Identifier (CSI), and vendor name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_entitlements = oci.OsManagementHub.get_entitlements(compartment_id=compartment_id,
        csi=entitlement_csi,
        vendor_name=entitlement_vendor_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param str csi: A filter to return entitlements that match the given CSI.
    :param str vendor_name: A filter to return only resources that match the given vendor name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['csi'] = csi
    __args__['filters'] = filters
    __args__['vendorName'] = vendor_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getEntitlements:getEntitlements', __args__, opts=opts, typ=GetEntitlementsResult).value

    return AwaitableGetEntitlementsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        csi=pulumi.get(__ret__, 'csi'),
        entitlement_collections=pulumi.get(__ret__, 'entitlement_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        vendor_name=pulumi.get(__ret__, 'vendor_name'))


@_utilities.lift_output_func(get_entitlements)
def get_entitlements_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            csi: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEntitlementsFilterArgs']]]]] = None,
                            vendor_name: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEntitlementsResult]:
    """
    This data source provides the list of Entitlements in Oracle Cloud Infrastructure Os Management Hub service.

    Lists entitlements in the specified tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against a variety of criteria including but
    not limited to its Customer Support Identifier (CSI), and vendor name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_entitlements = oci.OsManagementHub.get_entitlements(compartment_id=compartment_id,
        csi=entitlement_csi,
        vendor_name=entitlement_vendor_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param str csi: A filter to return entitlements that match the given CSI.
    :param str vendor_name: A filter to return only resources that match the given vendor name.
    """
    ...
