# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLifecycleStagesResult',
    'AwaitableGetLifecycleStagesResult',
    'get_lifecycle_stages',
    'get_lifecycle_stages_output',
]

@pulumi.output_type
class GetLifecycleStagesResult:
    """
    A collection of values returned by getLifecycleStages.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, lifecycle_stage_collections=None, lifecycle_stage_id=None, location_not_equal_tos=None, locations=None, os_family=None, software_source_id=None, state=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_stage_collections and not isinstance(lifecycle_stage_collections, list):
            raise TypeError("Expected argument 'lifecycle_stage_collections' to be a list")
        pulumi.set(__self__, "lifecycle_stage_collections", lifecycle_stage_collections)
        if lifecycle_stage_id and not isinstance(lifecycle_stage_id, str):
            raise TypeError("Expected argument 'lifecycle_stage_id' to be a str")
        pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if location_not_equal_tos and not isinstance(location_not_equal_tos, list):
            raise TypeError("Expected argument 'location_not_equal_tos' to be a list")
        pulumi.set(__self__, "location_not_equal_tos", location_not_equal_tos)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[str]:
        """
        The CPU architecture of the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the lifecycle stage.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLifecycleStagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStageCollections")
    def lifecycle_stage_collections(self) -> Sequence['outputs.GetLifecycleStagesLifecycleStageCollectionResult']:
        """
        The list of lifecycle_stage_collection.
        """
        return pulumi.get(self, "lifecycle_stage_collections")

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> Optional[str]:
        return pulumi.get(self, "lifecycle_stage_id")

    @property
    @pulumi.getter(name="locationNotEqualTos")
    def location_not_equal_tos(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "location_not_equal_tos")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        The location of managed instances associated with the lifecycle stage.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        """
        The operating system of the managed instances in the lifecycle stage.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[str]:
        """
        Provides identifying information for the specified software source.
        """
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the lifecycle stage.
        """
        return pulumi.get(self, "state")


class AwaitableGetLifecycleStagesResult(GetLifecycleStagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLifecycleStagesResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            lifecycle_stage_collections=self.lifecycle_stage_collections,
            lifecycle_stage_id=self.lifecycle_stage_id,
            location_not_equal_tos=self.location_not_equal_tos,
            locations=self.locations,
            os_family=self.os_family,
            software_source_id=self.software_source_id,
            state=self.state)


def get_lifecycle_stages(arch_type: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         display_name_contains: Optional[str] = None,
                         display_names: Optional[Sequence[str]] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetLifecycleStagesFilterArgs']]] = None,
                         lifecycle_stage_id: Optional[str] = None,
                         location_not_equal_tos: Optional[Sequence[str]] = None,
                         locations: Optional[Sequence[str]] = None,
                         os_family: Optional[str] = None,
                         software_source_id: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLifecycleStagesResult:
    """
    This data source provides the list of Lifecycle Stages in Oracle Cloud Infrastructure Os Management Hub service.

    Lists lifecycle stages that match the specified compartment or lifecycle stage [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lifecycle_stages = oci.OsManagementHub.get_lifecycle_stages(arch_type=lifecycle_stage_arch_type,
        compartment_id=compartment_id,
        display_names=lifecycle_stage_display_name,
        display_name_contains=lifecycle_stage_display_name_contains,
        lifecycle_stage_id=test_lifecycle_stage["id"],
        locations=lifecycle_stage_location,
        location_not_equal_tos=lifecycle_stage_location_not_equal_to,
        os_family=lifecycle_stage_os_family,
        software_source_id=lifecycle_stage_software_source_id,
        state=lifecycle_stage_state)
    ```


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
    :param str state: A filter to return only lifecycle stages whose lifecycle state matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['lifecycleStageId'] = lifecycle_stage_id
    __args__['locationNotEqualTos'] = location_not_equal_tos
    __args__['locations'] = locations
    __args__['osFamily'] = os_family
    __args__['softwareSourceId'] = software_source_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getLifecycleStages:getLifecycleStages', __args__, opts=opts, typ=GetLifecycleStagesResult).value

    return AwaitableGetLifecycleStagesResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_stage_collections=pulumi.get(__ret__, 'lifecycle_stage_collections'),
        lifecycle_stage_id=pulumi.get(__ret__, 'lifecycle_stage_id'),
        location_not_equal_tos=pulumi.get(__ret__, 'location_not_equal_tos'),
        locations=pulumi.get(__ret__, 'locations'),
        os_family=pulumi.get(__ret__, 'os_family'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_lifecycle_stages)
def get_lifecycle_stages_output(arch_type: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetLifecycleStagesFilterArgs']]]]] = None,
                                lifecycle_stage_id: Optional[pulumi.Input[Optional[str]]] = None,
                                location_not_equal_tos: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                locations: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                os_family: Optional[pulumi.Input[Optional[str]]] = None,
                                software_source_id: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLifecycleStagesResult]:
    """
    This data source provides the list of Lifecycle Stages in Oracle Cloud Infrastructure Os Management Hub service.

    Lists lifecycle stages that match the specified compartment or lifecycle stage [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Filter the list against

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_lifecycle_stages = oci.OsManagementHub.get_lifecycle_stages(arch_type=lifecycle_stage_arch_type,
        compartment_id=compartment_id,
        display_names=lifecycle_stage_display_name,
        display_name_contains=lifecycle_stage_display_name_contains,
        lifecycle_stage_id=test_lifecycle_stage["id"],
        locations=lifecycle_stage_location,
        location_not_equal_tos=lifecycle_stage_location_not_equal_to,
        os_family=lifecycle_stage_os_family,
        software_source_id=lifecycle_stage_software_source_id,
        state=lifecycle_stage_state)
    ```


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
    :param Sequence[str] location_not_equal_tos: A filter to return only resources whose location does not match the given value.
    :param Sequence[str] locations: A filter to return only resources whose location matches the given value.
    :param str os_family: A filter to return only resources that match the given operating system family.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
    :param str state: A filter to return only lifecycle stages whose lifecycle state matches the given lifecycle state.
    """
    ...
