# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LifecycleStagePromoteSoftwareSourceManagementArgs', 'LifecycleStagePromoteSoftwareSourceManagement']

@pulumi.input_type
class LifecycleStagePromoteSoftwareSourceManagementArgs:
    def __init__(__self__, *,
                 lifecycle_stage_id: pulumi.Input[str],
                 software_source_id: Optional[pulumi.Input[str]] = None,
                 work_request_details: Optional[pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a LifecycleStagePromoteSoftwareSourceManagement resource.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        :param pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if software_source_id is not None:
            pulumi.set(__self__, "software_source_id", software_source_id)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "lifecycle_stage_id", value)

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        """
        return pulumi.get(self, "software_source_id")

    @software_source_id.setter
    def software_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_id", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _LifecycleStagePromoteSoftwareSourceManagementState:
    def __init__(__self__, *,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 software_source_id: Optional[pulumi.Input[str]] = None,
                 work_request_details: Optional[pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering LifecycleStagePromoteSoftwareSourceManagement resources.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        :param pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if lifecycle_stage_id is not None:
            pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if software_source_id is not None:
            pulumi.set(__self__, "software_source_id", software_source_id)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_stage_id", value)

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        """
        return pulumi.get(self, "software_source_id")

    @software_source_id.setter
    def software_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "software_source_id", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


class LifecycleStagePromoteSoftwareSourceManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 software_source_id: Optional[pulumi.Input[str]] = None,
                 work_request_details: Optional[pulumi.Input[pulumi.InputType['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Lifecycle Stage Promote Software Source Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Updates the versioned custom software source content to the specified lifecycle stage.
        A versioned custom software source OCID (softwareSourceId) is required when promoting content to the first lifecycle stage. You must promote content to the first stage before promoting to subsequent stages, otherwise the service returns an error.
        The softwareSourceId is optional when promoting content to the second, third, forth, or fifth stages. If you provide a softwareSourceId, the service validates that it matches the softwareSourceId of the previous stage. If it does not match, the service returns an error. If you don't provide a softwareSourceId, the service promotes the versioned software source from the previous lifecycle stage. If the previous lifecycle stage has no software source, the service returns an error.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_lifecycle_stage_promote_software_source_management = oci.os_management_hub.LifecycleStagePromoteSoftwareSourceManagement("test_lifecycle_stage_promote_software_source_management",
            lifecycle_stage_id=test_lifecycle_stage["id"],
            software_source_id=test_software_source["id"],
            work_request_details=oci.os_management_hub.LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs(
                description=lifecycle_stage_promote_software_source_management_work_request_details_description,
                display_name=lifecycle_stage_promote_software_source_management_work_request_details_display_name,
            ))
        ```

        ## Import

        LifecycleStagePromoteSoftwareSourceManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/lifecycleStagePromoteSoftwareSourceManagement:LifecycleStagePromoteSoftwareSourceManagement test_lifecycle_stage_promote_software_source_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        :param pulumi.Input[pulumi.InputType['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LifecycleStagePromoteSoftwareSourceManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Lifecycle Stage Promote Software Source Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Updates the versioned custom software source content to the specified lifecycle stage.
        A versioned custom software source OCID (softwareSourceId) is required when promoting content to the first lifecycle stage. You must promote content to the first stage before promoting to subsequent stages, otherwise the service returns an error.
        The softwareSourceId is optional when promoting content to the second, third, forth, or fifth stages. If you provide a softwareSourceId, the service validates that it matches the softwareSourceId of the previous stage. If it does not match, the service returns an error. If you don't provide a softwareSourceId, the service promotes the versioned software source from the previous lifecycle stage. If the previous lifecycle stage has no software source, the service returns an error.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_lifecycle_stage_promote_software_source_management = oci.os_management_hub.LifecycleStagePromoteSoftwareSourceManagement("test_lifecycle_stage_promote_software_source_management",
            lifecycle_stage_id=test_lifecycle_stage["id"],
            software_source_id=test_software_source["id"],
            work_request_details=oci.os_management_hub.LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs(
                description=lifecycle_stage_promote_software_source_management_work_request_details_description,
                display_name=lifecycle_stage_promote_software_source_management_work_request_details_display_name,
            ))
        ```

        ## Import

        LifecycleStagePromoteSoftwareSourceManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/lifecycleStagePromoteSoftwareSourceManagement:LifecycleStagePromoteSoftwareSourceManagement test_lifecycle_stage_promote_software_source_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param LifecycleStagePromoteSoftwareSourceManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LifecycleStagePromoteSoftwareSourceManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 software_source_id: Optional[pulumi.Input[str]] = None,
                 work_request_details: Optional[pulumi.Input[pulumi.InputType['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LifecycleStagePromoteSoftwareSourceManagementArgs.__new__(LifecycleStagePromoteSoftwareSourceManagementArgs)

            if lifecycle_stage_id is None and not opts.urn:
                raise TypeError("Missing required property 'lifecycle_stage_id'")
            __props__.__dict__["lifecycle_stage_id"] = lifecycle_stage_id
            __props__.__dict__["software_source_id"] = software_source_id
            __props__.__dict__["work_request_details"] = work_request_details
        super(LifecycleStagePromoteSoftwareSourceManagement, __self__).__init__(
            'oci:OsManagementHub/lifecycleStagePromoteSoftwareSourceManagement:LifecycleStagePromoteSoftwareSourceManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
            software_source_id: Optional[pulumi.Input[str]] = None,
            work_request_details: Optional[pulumi.Input[pulumi.InputType['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']]] = None) -> 'LifecycleStagePromoteSoftwareSourceManagement':
        """
        Get an existing LifecycleStagePromoteSoftwareSourceManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        :param pulumi.Input[str] software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        :param pulumi.Input[pulumi.InputType['LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetailsArgs']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LifecycleStagePromoteSoftwareSourceManagementState.__new__(_LifecycleStagePromoteSoftwareSourceManagementState)

        __props__.__dict__["lifecycle_stage_id"] = lifecycle_stage_id
        __props__.__dict__["software_source_id"] = software_source_id
        __props__.__dict__["work_request_details"] = work_request_details
        return LifecycleStagePromoteSoftwareSourceManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source. This filter returns resources associated with this software source.
        """
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.LifecycleStagePromoteSoftwareSourceManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

