# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProfileArgs', 'Profile']

@pulumi.input_type
class ProfileArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 profile_type: pulumi.Input[str],
                 arch_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_default_profile: Optional[pulumi.Input[bool]] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 registration_type: Optional[pulumi.Input[str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Profile resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] profile_type: The type of profile.
        :param pulumi.Input[str] arch_type: The architecture type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User-specified description of the registration profile.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_default_profile: (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        :param pulumi.Input[str] os_family: The operating system family.
        :param pulumi.Input[str] registration_type: The type of instance to register.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        :param pulumi.Input[str] vendor_name: The vendor of the operating system for the instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "profile_type", profile_type)
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default_profile is not None:
            pulumi.set(__self__, "is_default_profile", is_default_profile)
        if lifecycle_stage_id is not None:
            pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if management_station_id is not None:
            pulumi.set(__self__, "management_station_id", management_station_id)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if registration_type is not None:
            pulumi.set(__self__, "registration_type", registration_type)
        if software_source_ids is not None:
            pulumi.set(__self__, "software_source_ids", software_source_ids)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> pulumi.Input[str]:
        """
        The type of profile.
        """
        return pulumi.get(self, "profile_type")

    @profile_type.setter
    def profile_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile_type", value)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The architecture type.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-specified description of the registration profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDefaultProfile")
    def is_default_profile(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        """
        return pulumi.get(self, "is_default_profile")

    @is_default_profile.setter
    def is_default_profile(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_profile", value)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_stage_id", value)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        """
        return pulumi.get(self, "management_station_id")

    @management_station_id.setter
    def management_station_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_station_id", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system family.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="registrationType")
    def registration_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance to register.
        """
        return pulumi.get(self, "registration_type")

    @registration_type.setter
    def registration_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_type", value)

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        """
        return pulumi.get(self, "software_source_ids")

    @software_source_ids.setter
    def software_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "software_source_ids", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The vendor of the operating system for the instance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_name", value)


@pulumi.input_type
class _ProfileState:
    def __init__(__self__, *,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_default_profile: Optional[pulumi.Input[bool]] = None,
                 is_service_provided_profile: Optional[pulumi.Input[bool]] = None,
                 lifecycle_environments: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleEnvironmentArgs']]]] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_stages: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleStageArgs']]]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileManagedInstanceGroupArgs']]]] = None,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 profile_type: Optional[pulumi.Input[str]] = None,
                 registration_type: Optional[pulumi.Input[str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileSoftwareSourceArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Profile resources.
        :param pulumi.Input[str] arch_type: The architecture type.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User-specified description of the registration profile.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_default_profile: (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        :param pulumi.Input[bool] is_service_provided_profile: Indicates if the profile was created by the service. OS Management Hub provides a limited set of standardized profiles that can be used to register Autonomous Linux or Windows instances.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleEnvironmentArgs']]] lifecycle_environments: Provides identifying information for the specified lifecycle environment.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleStageArgs']]] lifecycle_stages: Provides identifying information for the specified lifecycle stage.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileManagedInstanceGroupArgs']]] managed_instance_groups: Provides identifying information for the specified managed instance group.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        :param pulumi.Input[str] os_family: The operating system family.
        :param pulumi.Input[str] profile_type: The type of profile.
        :param pulumi.Input[str] registration_type: The type of instance to register.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        :param pulumi.Input[Sequence[pulumi.Input['ProfileSoftwareSourceArgs']]] software_sources: The list of software sources that the registration profile will use.
        :param pulumi.Input[str] state: The current state of the registration profile.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the registration profile was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[str] vendor_name: The vendor of the operating system for the instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default_profile is not None:
            pulumi.set(__self__, "is_default_profile", is_default_profile)
        if is_service_provided_profile is not None:
            pulumi.set(__self__, "is_service_provided_profile", is_service_provided_profile)
        if lifecycle_environments is not None:
            pulumi.set(__self__, "lifecycle_environments", lifecycle_environments)
        if lifecycle_stage_id is not None:
            pulumi.set(__self__, "lifecycle_stage_id", lifecycle_stage_id)
        if lifecycle_stages is not None:
            pulumi.set(__self__, "lifecycle_stages", lifecycle_stages)
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if managed_instance_groups is not None:
            pulumi.set(__self__, "managed_instance_groups", managed_instance_groups)
        if management_station_id is not None:
            pulumi.set(__self__, "management_station_id", management_station_id)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if profile_type is not None:
            pulumi.set(__self__, "profile_type", profile_type)
        if registration_type is not None:
            pulumi.set(__self__, "registration_type", registration_type)
        if software_source_ids is not None:
            pulumi.set(__self__, "software_source_ids", software_source_ids)
        if software_sources is not None:
            pulumi.set(__self__, "software_sources", software_sources)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The architecture type.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User-specified description of the registration profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDefaultProfile")
    def is_default_profile(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        """
        return pulumi.get(self, "is_default_profile")

    @is_default_profile.setter
    def is_default_profile(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_profile", value)

    @property
    @pulumi.getter(name="isServiceProvidedProfile")
    def is_service_provided_profile(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the profile was created by the service. OS Management Hub provides a limited set of standardized profiles that can be used to register Autonomous Linux or Windows instances.
        """
        return pulumi.get(self, "is_service_provided_profile")

    @is_service_provided_profile.setter
    def is_service_provided_profile(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_service_provided_profile", value)

    @property
    @pulumi.getter(name="lifecycleEnvironments")
    def lifecycle_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleEnvironmentArgs']]]]:
        """
        Provides identifying information for the specified lifecycle environment.
        """
        return pulumi.get(self, "lifecycle_environments")

    @lifecycle_environments.setter
    def lifecycle_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleEnvironmentArgs']]]]):
        pulumi.set(self, "lifecycle_environments", value)

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @lifecycle_stage_id.setter
    def lifecycle_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_stage_id", value)

    @property
    @pulumi.getter(name="lifecycleStages")
    def lifecycle_stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleStageArgs']]]]:
        """
        Provides identifying information for the specified lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stages")

    @lifecycle_stages.setter
    def lifecycle_stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileLifecycleStageArgs']]]]):
        pulumi.set(self, "lifecycle_stages", value)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileManagedInstanceGroupArgs']]]]:
        """
        Provides identifying information for the specified managed instance group.
        """
        return pulumi.get(self, "managed_instance_groups")

    @managed_instance_groups.setter
    def managed_instance_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileManagedInstanceGroupArgs']]]]):
        pulumi.set(self, "managed_instance_groups", value)

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        """
        return pulumi.get(self, "management_station_id")

    @management_station_id.setter
    def management_station_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_station_id", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system family.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of profile.
        """
        return pulumi.get(self, "profile_type")

    @profile_type.setter
    def profile_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_type", value)

    @property
    @pulumi.getter(name="registrationType")
    def registration_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance to register.
        """
        return pulumi.get(self, "registration_type")

    @registration_type.setter
    def registration_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_type", value)

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        """
        return pulumi.get(self, "software_source_ids")

    @software_source_ids.setter
    def software_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "software_source_ids", value)

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProfileSoftwareSourceArgs']]]]:
        """
        The list of software sources that the registration profile will use.
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProfileSoftwareSourceArgs']]]]):
        pulumi.set(self, "software_sources", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the registration profile.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the registration profile was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The vendor of the operating system for the instance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_name", value)


class Profile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_default_profile: Optional[pulumi.Input[bool]] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 profile_type: Optional[pulumi.Input[str]] = None,
                 registration_type: Optional[pulumi.Input[str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Profile resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a registration profile. A profile defines the content applied to the instance when registering it with the service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_profile = oci.os_management_hub.Profile("test_profile",
            compartment_id=compartment_id,
            display_name=profile_display_name,
            profile_type=profile_profile_type,
            arch_type=profile_arch_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=profile_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_default_profile=profile_is_default_profile,
            lifecycle_stage_id=test_lifecycle_stage["id"],
            managed_instance_group_id=test_managed_instance_group["id"],
            management_station_id=test_management_station["id"],
            os_family=profile_os_family,
            registration_type=profile_registration_type,
            software_source_ids=profile_software_source_ids,
            vendor_name=profile_vendor_name)
        ```

        ## Import

        Profiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/profile:Profile test_profile "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arch_type: The architecture type.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User-specified description of the registration profile.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_default_profile: (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        :param pulumi.Input[str] os_family: The operating system family.
        :param pulumi.Input[str] profile_type: The type of profile.
        :param pulumi.Input[str] registration_type: The type of instance to register.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        :param pulumi.Input[str] vendor_name: The vendor of the operating system for the instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Profile resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a registration profile. A profile defines the content applied to the instance when registering it with the service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_profile = oci.os_management_hub.Profile("test_profile",
            compartment_id=compartment_id,
            display_name=profile_display_name,
            profile_type=profile_profile_type,
            arch_type=profile_arch_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=profile_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_default_profile=profile_is_default_profile,
            lifecycle_stage_id=test_lifecycle_stage["id"],
            managed_instance_group_id=test_managed_instance_group["id"],
            management_station_id=test_management_station["id"],
            os_family=profile_os_family,
            registration_type=profile_registration_type,
            software_source_ids=profile_software_source_ids,
            vendor_name=profile_vendor_name)
        ```

        ## Import

        Profiles can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/profile:Profile test_profile "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_default_profile: Optional[pulumi.Input[bool]] = None,
                 lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 management_station_id: Optional[pulumi.Input[str]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 profile_type: Optional[pulumi.Input[str]] = None,
                 registration_type: Optional[pulumi.Input[str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProfileArgs.__new__(ProfileArgs)

            __props__.__dict__["arch_type"] = arch_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_default_profile"] = is_default_profile
            __props__.__dict__["lifecycle_stage_id"] = lifecycle_stage_id
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            __props__.__dict__["management_station_id"] = management_station_id
            __props__.__dict__["os_family"] = os_family
            if profile_type is None and not opts.urn:
                raise TypeError("Missing required property 'profile_type'")
            __props__.__dict__["profile_type"] = profile_type
            __props__.__dict__["registration_type"] = registration_type
            __props__.__dict__["software_source_ids"] = software_source_ids
            __props__.__dict__["vendor_name"] = vendor_name
            __props__.__dict__["is_service_provided_profile"] = None
            __props__.__dict__["lifecycle_environments"] = None
            __props__.__dict__["lifecycle_stages"] = None
            __props__.__dict__["managed_instance_groups"] = None
            __props__.__dict__["software_sources"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(Profile, __self__).__init__(
            'oci:OsManagementHub/profile:Profile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arch_type: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_default_profile: Optional[pulumi.Input[bool]] = None,
            is_service_provided_profile: Optional[pulumi.Input[bool]] = None,
            lifecycle_environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileLifecycleEnvironmentArgs']]]]] = None,
            lifecycle_stage_id: Optional[pulumi.Input[str]] = None,
            lifecycle_stages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileLifecycleStageArgs']]]]] = None,
            managed_instance_group_id: Optional[pulumi.Input[str]] = None,
            managed_instance_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileManagedInstanceGroupArgs']]]]] = None,
            management_station_id: Optional[pulumi.Input[str]] = None,
            os_family: Optional[pulumi.Input[str]] = None,
            profile_type: Optional[pulumi.Input[str]] = None,
            registration_type: Optional[pulumi.Input[str]] = None,
            software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileSoftwareSourceArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            vendor_name: Optional[pulumi.Input[str]] = None) -> 'Profile':
        """
        Get an existing Profile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arch_type: The architecture type.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User-specified description of the registration profile.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_default_profile: (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        :param pulumi.Input[bool] is_service_provided_profile: Indicates if the profile was created by the service. OS Management Hub provides a limited set of standardized profiles that can be used to register Autonomous Linux or Windows instances.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileLifecycleEnvironmentArgs']]]] lifecycle_environments: Provides identifying information for the specified lifecycle environment.
        :param pulumi.Input[str] lifecycle_stage_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileLifecycleStageArgs']]]] lifecycle_stages: Provides identifying information for the specified lifecycle stage.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileManagedInstanceGroupArgs']]]] managed_instance_groups: Provides identifying information for the specified managed instance group.
        :param pulumi.Input[str] management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        :param pulumi.Input[str] os_family: The operating system family.
        :param pulumi.Input[str] profile_type: The type of profile.
        :param pulumi.Input[str] registration_type: The type of instance to register.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProfileSoftwareSourceArgs']]]] software_sources: The list of software sources that the registration profile will use.
        :param pulumi.Input[str] state: The current state of the registration profile.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the registration profile was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[str] vendor_name: The vendor of the operating system for the instance.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProfileState.__new__(_ProfileState)

        __props__.__dict__["arch_type"] = arch_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_default_profile"] = is_default_profile
        __props__.__dict__["is_service_provided_profile"] = is_service_provided_profile
        __props__.__dict__["lifecycle_environments"] = lifecycle_environments
        __props__.__dict__["lifecycle_stage_id"] = lifecycle_stage_id
        __props__.__dict__["lifecycle_stages"] = lifecycle_stages
        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["managed_instance_groups"] = managed_instance_groups
        __props__.__dict__["management_station_id"] = management_station_id
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["profile_type"] = profile_type
        __props__.__dict__["registration_type"] = registration_type
        __props__.__dict__["software_source_ids"] = software_source_ids
        __props__.__dict__["software_sources"] = software_sources
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vendor_name"] = vendor_name
        return Profile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Output[str]:
        """
        The architecture type.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the registration profile.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) User-specified description of the registration profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isDefaultProfile")
    def is_default_profile(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if the profile is set as the default. There is exactly one default profile for a specified architecture, OS family, registration type, and vendor. When registering an instance with the corresonding characteristics, the default profile is used, unless another profile is specified.
        """
        return pulumi.get(self, "is_default_profile")

    @property
    @pulumi.getter(name="isServiceProvidedProfile")
    def is_service_provided_profile(self) -> pulumi.Output[bool]:
        """
        Indicates if the profile was created by the service. OS Management Hub provides a limited set of standardized profiles that can be used to register Autonomous Linux or Windows instances.
        """
        return pulumi.get(self, "is_service_provided_profile")

    @property
    @pulumi.getter(name="lifecycleEnvironments")
    def lifecycle_environments(self) -> pulumi.Output[Sequence['outputs.ProfileLifecycleEnvironment']]:
        """
        Provides identifying information for the specified lifecycle environment.
        """
        return pulumi.get(self, "lifecycle_environments")

    @property
    @pulumi.getter(name="lifecycleStageId")
    def lifecycle_stage_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the lifecycle stage that the instance will be associated with.
        """
        return pulumi.get(self, "lifecycle_stage_id")

    @property
    @pulumi.getter(name="lifecycleStages")
    def lifecycle_stages(self) -> pulumi.Output[Sequence['outputs.ProfileLifecycleStage']]:
        """
        Provides identifying information for the specified lifecycle stage.
        """
        return pulumi.get(self, "lifecycle_stages")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group that the instance will join after registration.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="managedInstanceGroups")
    def managed_instance_groups(self) -> pulumi.Output[Sequence['outputs.ProfileManagedInstanceGroup']]:
        """
        Provides identifying information for the specified managed instance group.
        """
        return pulumi.get(self, "managed_instance_groups")

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station to associate with an instance once registered. Associating with a management station applies only to non-OCI instances.
        """
        return pulumi.get(self, "management_station_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[str]:
        """
        The operating system family.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> pulumi.Output[str]:
        """
        The type of profile.
        """
        return pulumi.get(self, "profile_type")

    @property
    @pulumi.getter(name="registrationType")
    def registration_type(self) -> pulumi.Output[str]:
        """
        The type of instance to register.
        """
        return pulumi.get(self, "registration_type")

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) that the registration profile will use.
        """
        return pulumi.get(self, "software_source_ids")

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Output[Sequence['outputs.ProfileSoftwareSource']]:
        """
        The list of software sources that the registration profile will use.
        """
        return pulumi.get(self, "software_sources")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the registration profile.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the registration profile was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Output[str]:
        """
        The vendor of the operating system for the instance.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

