from enum import IntEnum

class SmtpStatusCode(IntEnum):
    NOT_DEFINED = 0
    GENERAL_FAILURE = -1
    SYSTEM_STATUS = 211
    HELP_MESSAGE = 214
    SERVICE_READY = 220
    SERVICE_CLOSING_TRANSMISSION_CHANNEL = 221
    AUTHENTICATION_SUCCEEDED = 235
    OK = 250
    USER_NOT_LOCAL_WILL_FORWARD = 251
    CANNOT_VERIFY_USER_WILL_ATTEMPT_DELIVERY = 252
    BASE_64_RESPONSE = 334
    START_MAIL_INPUT = 354
    SERVICE_NOT_AVAILABLE = 421
    PASSWORD_TRANSITION_NEEDED = 432
    MAILBOX_BUSY = 450
    LOCAL_ERROR_IN_PROCESSING = 451
    INSUFFICIENT_STORAGE = 452
    CLIENT_NOT_PERMITTED = 454
    COMMAND_UNRECOGNIZED = 500
    SYNTAX_ERROR = 501
    COMMAND_NOT_IMPLEMENTED = 502
    COMMAND_NOT_PERMITTED = 503
    UNRECOGNIZED_AUTHENTICATION_TYPE = 504
    AUTHENTICATION_REQUIRED = 530
    AUTHENTICATION_MECHANISM_IS_TO_WEAK = 534
    CREDENTIALS_INVALID = 535
    ENCRYPTION_REQUIRED_REQUESTED_MECHANISM = 538
    MAILBOX_UNAVAILABLE = 550
    USER_NOT_LOCAL_TRY_ALTERNATE_PATH = 551
    EXCEEDED_STORAGE_ALLOCATION = 552
    MAILBOX_NAME_NOT_ALLOWED = 553
    TRANSACTION_FAILED = 554
