"""EndpointManagementService Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class EndpointPlatform(str, Enum):
    """EndpointPlatform."""

    WINDOWS = "WINDOWS"
    MAC = "MAC"
    LINUX = "LINUX"


class PolicyType(str, Enum):
    """PolicyType."""

    LOW = "LOW"
    STANDARD = "STANDARD"
    HIGH = "HIGH"
    LOW_COMPAT = "LOW_COMPAT"
    STANDARD_COMPAT = "STANDARD_COMPAT"


class BulkAssignRequestStatus(str, Enum):
    """BulkAssignRequestStatus."""

    PENDING = "PENDING"
    IN_PROGRESS = "IN_PROGRESS"
    FAILED = "FAILED"
    COMPLETE = "COMPLETE"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointGroup:
    """EndpointGroup."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    group_id: Optional[str] = field(default=None, metadata=config(field_name="groupId"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    registration_key: Optional[str] = field(
        default=None, metadata=config(field_name="registrationKey")
    )
    registration_key_expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="registrationKeyExpiresAt")
    )
    policy_name: Optional[str] = field(
        default=None, metadata=config(field_name="policyName")
    )
    is_system_generated: Optional[bool] = field(
        default=None, metadata=config(field_name="isSystemGenerated")
    )
    is_default: Optional[bool] = field(
        default=None, metadata=config(field_name="isDefault")
    )
    desired_agent_version: Optional[str] = field(
        default=None, metadata=config(field_name="desiredAgentVersion")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    skip_upgrade: Optional[bool] = field(
        default=None, metadata=config(field_name="skipUpgrade")
    )
    archive_endpoint_after_days: Optional[int] = field(
        default=None, metadata=config(field_name="ArchiveEndpointAfterDays")
    )
    is_archive_endpoint_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="IsArchiveEndpointEnabled")
    )
    file_analysis_flag: Optional[bool] = field(
        default=None, metadata=config(field_name="fileAnalysisFlag")
    )
    maintenance_window: Optional[str] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )
    advanced_kernel_telemetry_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetryEnabled")
    )
    setting_id: Optional[str] = field(
        default=None, metadata=config(field_name="settingId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteEndpointGrpInput:
    """DeleteEndpointGrpInput."""

    group_id: Optional[str] = field(default=None, metadata=config(field_name="groupId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Policy:
    """Policy."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    platform: Optional[str] = field(
        default=None, metadata=config(field_name="platform")
    )
    format: Optional[str] = field(default=None, metadata=config(field_name="format"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointGroupArguments:
    """EndpointGroupArguments."""

    group_id: Optional[str] = field(default=None, metadata=config(field_name="groupId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkAssignRequestInput:
    """BulkAssignRequestInput."""

    group_id: Optional[str] = field(default=None, metadata=config(field_name="groupId"))
    endpoint_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="endpointIds")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PartialPageInfo:
    """PartialPageInfo."""

    last_evaluated_key: Optional[str] = field(
        default=None, metadata=config(field_name="lastEvaluatedKey")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DailyWindowEntry:
    """DailyWindowEntry."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    start_time_hour: Optional[int] = field(
        default=None, metadata=config(field_name="startTimeHour")
    )
    end_time_hour: Optional[int] = field(
        default=None, metadata=config(field_name="endTimeHour")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BooleanSettingInput:
    """BooleanSettingInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AutoArchiveInput:
    """AutoArchiveInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    period_days: Optional[int] = field(
        default=None, metadata=config(field_name="periodDays")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DailyWindowEntryInput:
    """DailyWindowEntryInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    start_time_hour: Optional[int] = field(
        default=None, metadata=config(field_name="startTimeHour")
    )
    end_time_hour: Optional[int] = field(
        default=None, metadata=config(field_name="endTimeHour")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateEndpointGroupInput:
    """CreateEndpointGroupInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    desired_agent_version: Optional[str] = field(
        default=None, metadata=config(field_name="desiredAgentVersion")
    )
    is_default: Optional[bool] = field(
        default=None, metadata=config(field_name="isDefault")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    archive_endpoint_after_days: Optional[int] = field(
        default=None, metadata=config(field_name="ArchiveEndpointAfterDays")
    )
    file_analysis_flag: Optional[bool] = field(
        default=None, metadata=config(field_name="fileAnalysisFlag")
    )
    maintenance_window: Optional[str] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )
    advanced_kernel_telemetry_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetryEnabled")
    )
    setting_id: Optional[str] = field(
        default=None, metadata=config(field_name="settingId")
    )
    policy_name: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyName")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateEndpointGroupInput:
    """UpdateEndpointGroupInput."""

    group_id: Optional[str] = field(default=None, metadata=config(field_name="groupId"))
    setting_id: Optional[str] = field(
        default=None, metadata=config(field_name="settingId")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    desired_version: Optional[str] = field(
        default=None, metadata=config(field_name="desiredVersion")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    archive_endpoint_after_days: Optional[int] = field(
        default=None, metadata=config(field_name="ArchiveEndpointAfterDays")
    )
    file_analysis_flag: Optional[bool] = field(
        default=None, metadata=config(field_name="fileAnalysisFlag")
    )
    maintenance_window: Optional[str] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )
    advanced_kernel_telemetry_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetryEnabled")
    )
    policy_name: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyName")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class BulkAssignRequestOutput:
    """BulkAssignRequestOutput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    status: Optional[BulkAssignRequestStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AdvancedKernelTelemetry:
    """AdvancedKernelTelemetry."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    platforms: Optional[List[EndpointPlatform]] = field(
        default=None, metadata=config(field_name="platforms")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AutoArchive:
    """AutoArchive."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    period_days: Optional[int] = field(
        default=None, metadata=config(field_name="periodDays")
    )
    platforms: Optional[List[EndpointPlatform]] = field(
        default=None, metadata=config(field_name="platforms")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FileAnalysis:
    """FileAnalysis."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    platforms: Optional[List[EndpointPlatform]] = field(
        default=None, metadata=config(field_name="platforms")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TamperProtection:
    """TamperProtection."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    platforms: Optional[List[EndpointPlatform]] = field(
        default=None, metadata=config(field_name="platforms")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PolicyArguments:
    """PolicyArguments."""

    policy_name: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyName")
    )
    platform: Optional[EndpointPlatform] = field(
        default=None, metadata=config(field_name="platform")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreatePolicyInput:
    """CreatePolicyInput."""

    format: Optional[str] = field(default=None, metadata=config(field_name="format"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    policy_name: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyName")
    )
    platform: Optional[EndpointPlatform] = field(
        default=None, metadata=config(field_name="platform")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointGroupsPagedOutput:
    """EndpointGroupsPagedOutput."""

    groups: Optional[List[EndpointGroup]] = field(
        default=None, metadata=config(field_name="groups")
    )
    partial_page_info: Optional[PartialPageInfo] = field(
        default=None, metadata=config(field_name="partialPageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DailyWindows:
    """DailyWindows."""

    monday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="monday")
    )
    tuesday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="tuesday")
    )
    wednesday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="wednesday")
    )
    thursday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="thursday")
    )
    friday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="friday")
    )
    saturday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="saturday")
    )
    sunday: Optional[DailyWindowEntry] = field(
        default=None, metadata=config(field_name="sunday")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DailyWindowsInput:
    """DailyWindowsInput."""

    monday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="monday")
    )
    tuesday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="tuesday")
    )
    wednesday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="wednesday")
    )
    thursday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="thursday")
    )
    friday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="friday")
    )
    saturday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="saturday")
    )
    sunday: Optional[DailyWindowEntryInput] = field(
        default=None, metadata=config(field_name="sunday")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MaintenanceWindowInput:
    """MaintenanceWindowInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    windows: Optional[DailyWindowsInput] = field(
        default=None, metadata=config(field_name="windows")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MaintenanceWindow:
    """MaintenanceWindow."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    platforms: Optional[List[EndpointPlatform]] = field(
        default=None, metadata=config(field_name="platforms")
    )
    windows: Optional[DailyWindows] = field(
        default=None, metadata=config(field_name="windows")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AgentSetting:
    """AgentSetting."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    is_default: Optional[bool] = field(
        default=None, metadata=config(field_name="isDefault")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    advanced_kernel_telemetry: Optional[AdvancedKernelTelemetry] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetry")
    )
    auto_archive: Optional[AutoArchive] = field(
        default=None, metadata=config(field_name="autoArchive")
    )
    file_analysis: Optional[FileAnalysis] = field(
        default=None, metadata=config(field_name="fileAnalysis")
    )
    maintenance_window: Optional[MaintenanceWindow] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )
    tamper_protection: Optional[TamperProtection] = field(
        default=None, metadata=config(field_name="tamperProtection")
    )
    policy_type: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateAgentSettingsInput:
    """CreateAgentSettingsInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    advanced_kernel_telemetry: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetry")
    )
    auto_archive: Optional[AutoArchiveInput] = field(
        default=None, metadata=config(field_name="autoArchive")
    )
    file_analysis: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="fileAnalysis")
    )
    tamper_protection: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="tamperProtection")
    )
    policy_type: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyType")
    )
    maintenance_window: Optional[MaintenanceWindowInput] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateAgentSettingsInput:
    """UpdateAgentSettingsInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    advanced_kernel_telemetry: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetry")
    )
    auto_archive: Optional[AutoArchiveInput] = field(
        default=None, metadata=config(field_name="autoArchive")
    )
    file_analysis: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="fileAnalysis")
    )
    tamper_protection: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="tamperProtection")
    )
    policy_type: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyType")
    )
    maintenance_window: Optional[MaintenanceWindowInput] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateDefaultAgentSettingInput:
    """UpdateDefaultAgentSettingInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    channel: Optional[str] = field(default=None, metadata=config(field_name="channel"))
    advanced_kernel_telemetry: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="advancedKernelTelemetry")
    )
    auto_archive: Optional[AutoArchiveInput] = field(
        default=None, metadata=config(field_name="autoArchive")
    )
    file_analysis: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="fileAnalysis")
    )
    tamper_protection: Optional[BooleanSettingInput] = field(
        default=None, metadata=config(field_name="tamperProtection")
    )
    policy_type: Optional[PolicyType] = field(
        default=None, metadata=config(field_name="policyType")
    )
    maintenance_window: Optional[MaintenanceWindowInput] = field(
        default=None, metadata=config(field_name="maintenanceWindow")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AgentSettings:
    """AgentSettings."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    settings: Optional[List[AgentSetting]] = field(
        default=None, metadata=config(field_name="settings")
    )
    page_info: Optional[PartialPageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )
