"""Investigations2 Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.investigations2.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.investigations2 import Investigations2Service

log = logging.getLogger(__name__)


class TaegisSDKInvestigations2Query:
    """Taegis Investigations2 Query operations."""

    def __init__(self, service: Investigations2Service):
        self.service = service

    def investigation_v2(self, arguments: InvestigationV2Arguments) -> InvestigationV2:
        """investigationV2 gets a single Investigation.."""
        endpoint = "investigationV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationV2")

    def investigations_v2(
        self, arguments: InvestigationsV2Arguments
    ) -> InvestigationsV2:
        """investigationsV2 returns a list of investigations matching the provided arguments.."""
        endpoint = "investigationsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationsV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationsV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationsV2")

    def investigation_rule(
        self, arguments: InvestigationRuleArguments
    ) -> InvestigationRule:
        """investigationRule gets an auto-investigation rule."""
        endpoint = "investigationRule"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationRule),
        )
        if result.get(endpoint) is not None:
            return InvestigationRule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationRule")

    def investigation_rules(
        self, arguments: InvestigationRulesArguments
    ) -> InvestigationRules:
        """investigationRules returns a list of investigation rules matching the provided arguments.."""
        endpoint = "investigationRules"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationRules),
        )
        if result.get(endpoint) is not None:
            return InvestigationRules.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationRules")

    def investigation_template(
        self, arguments: InvestigationTemplateArguments
    ) -> InvestigationTemplate:
        """investigationTemplate gets an auto-investigation template."""
        endpoint = "investigationTemplate"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationTemplate),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplate.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationTemplate")

    def investigation_templates(
        self, arguments: InvestigationTemplatesArguments
    ) -> InvestigationTemplates:
        """investigationTemplates returns a list of investigation templates matching the provided arguments.."""
        endpoint = "investigationTemplates"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationTemplates),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplates.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationTemplates")

    def export_investigation_resources(
        self, arguments: ExportInvestigationResourcesArguments
    ) -> InvestigationResourceExport:
        """exportInvestigationResources returns a YAML string representation for auto-investigation resources (rules & templates).
        The returned string can be saved into a file and imported back into the system using importInvestigationResources.."""
        endpoint = "exportInvestigationResources"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationResourceExport),
        )
        if result.get(endpoint) is not None:
            return InvestigationResourceExport.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query exportInvestigationResources")

    def investigation_v2_timeline(
        self, arguments: InvestigationV2TimelineArguments
    ) -> InvestigationV2Timeline:
        """investigationV2Timeline returns an investigation timeline detailing the order of alerts, events and other actions taken in relation to an investigation.."""
        endpoint = "investigationV2Timeline"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationV2Timeline),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2Timeline.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationV2Timeline")

    def comments_v2(self, arguments: CommentsV2Arguments) -> CommentsV2:
        """commentsV2 returns all the comments for an investigation."""
        endpoint = "commentsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CommentsV2),
        )
        if result.get(endpoint) is not None:
            return CommentsV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query commentsV2")

    def investigation_v2_types(self) -> List[InvestigationV2Type]:
        """investigationV2Types returns the available investigation types for a given user and the current tenant's service level."""
        endpoint = "investigationV2Types"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(InvestigationV2Type),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2Type.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query investigationV2Types")

    def investigation_file_v2(
        self, arguments: InvestigationFileV2Arguments
    ) -> InvestigationFileV2:
        """investigationFileV2 returns file details for a single file attached to an investigation based on the arguments provided.
        The result will also include a pre-signed download url.."""
        endpoint = "investigationFileV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationFileV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationFileV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationFileV2")

    def investigation_files_v2(
        self, arguments: InvestigationFilesV2Arguments
    ) -> InvestigationFilesV2:
        """investigationFilesV2 returns file details for all files matching the arguments provided.
        The results will not include pre-signed download urls for each file metadata returned.."""
        endpoint = "investigationFilesV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationFilesV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationFilesV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationFilesV2")
