"""Users Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.users.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.users import UsersService

log = logging.getLogger(__name__)


class TaegisSDKUsersQuery:
    """Taegis Users Query operations."""

    def __init__(self, service: UsersService):
        self.service = service

    def tdruser(
        self,
        id_: str,
        exclude_deactivated_role_assignments: Optional[bool] = None,
        include_masked_related_users: Optional[bool] = None,
    ) -> TDRUser:
        """Get User by id. The ID can be either the ID of the user object or the userID from Auth0."""
        endpoint = "tdruser"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "excludeDeactivatedRoleAssignments": prepare_input(
                    exclude_deactivated_role_assignments
                ),
                "includeMaskedRelatedUsers": prepare_input(
                    include_masked_related_users
                ),
            },
            output=build_output_string(TDRUser),
        )
        if result.get(endpoint) is not None:
            return TDRUser.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tdruser")

    def tdrusers(
        self,
        email: Optional[str] = None,
        role: Optional[str] = None,
        tenant_id: Optional[str] = None,
        role_ids: Optional[List[str]] = None,
        tenant_ids: Optional[List[str]] = None,
        status: Optional[str] = None,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> List[TDRUser]:
        """Search Users."""
        endpoint = "tdrusers"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "email": prepare_input(email),
                "role": prepare_input(role),
                "tenantID": prepare_input(tenant_id),
                "role_IDs": prepare_input(role_ids),
                "tenant_IDs": prepare_input(tenant_ids),
                "status": prepare_input(status),
                "page": prepare_input(page),
                "perPage": prepare_input(per_page),
            },
            output=build_output_string(TDRUser),
        )
        if result.get(endpoint) is not None:
            return TDRUser.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query tdrusers")

    def tdrusers_by_ids(self, user_ids: Optional[List[str]] = None) -> List[TDRUser]:
        """Search users by id list. The list can contain a mixture of IDs or UserIDs.."""
        endpoint = "tdrusersByIDs"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "userIDs": prepare_input(user_ids),
            },
            output=build_output_string(TDRUser),
        )
        if result.get(endpoint) is not None:
            return TDRUser.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query tdrusersByIDs")

    def search_tdrusers_by_ids(
        self,
        user_ids: Optional[List[str]] = None,
        include_masked_related_users: Optional[bool] = None,
    ) -> List[SearchByIDsResponse]:
        """ "
        Search users by id list. The list can contain a mixture of IDs or UserIDs. Errors are reported individually for each ID.
        Search will be processed using the X-Tenant-Context header as a filter first. Subsequent searches will use role assignments
        for user IDs that have not been found until all users are retrieved or all role assignments are exhausted.."""
        endpoint = "searchTDRUsersByIDs"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "userIDs": prepare_input(user_ids),
                "includeMaskedRelatedUsers": prepare_input(
                    include_masked_related_users
                ),
            },
            output=build_output_string(SearchByIDsResponse),
        )
        if result.get(endpoint) is not None:
            return SearchByIDsResponse.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query searchTDRUsersByIDs")

    def get_support_pin(self) -> TDRUserSupportPin:
        """Get the user's current support pin. The user is implicitly assumed based on the requester's access token.."""
        endpoint = "getSupportPin"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(TDRUserSupportPin),
        )
        if result.get(endpoint) is not None:
            return TDRUserSupportPin.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query getSupportPin")

    def get_support_pin_verification(self, support_pin: str) -> List[SupportPinDetails]:
        """Get a list of details associated with the given support pin.."""
        endpoint = "getSupportPinVerification"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "supportPin": prepare_input(support_pin),
            },
            output=build_output_string(SupportPinDetails),
        )
        if result.get(endpoint) is not None:
            return SupportPinDetails.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getSupportPinVerification")

    def tdr_users_search(
        self, filters: Optional[TDRUsersSearchInput] = None
    ) -> TDRUsersSearchResults:
        """Fast Search Users."""
        endpoint = "tdrUsersSearch"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filters": prepare_input(filters),
            },
            output=build_output_string(TDRUsersSearchResults),
        )
        if result.get(endpoint) is not None:
            return TDRUsersSearchResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tdrUsersSearch")

    def current_tdruser(self) -> TDRUser:
        """Get the current user."""
        endpoint = "currentTDRUser"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(TDRUser)
        )
        if result.get(endpoint) is not None:
            return TDRUser.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query currentTDRUser")
