"""Vdr Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.vdr.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.vdr import VdrService

log = logging.getLogger(__name__)


class TaegisSDKVdrQuery:
    """Taegis Vdr Query operations."""

    def __init__(self, service: VdrService):
        self.service = service

    def vdr_asset(self, arguments: VdrAssetInputArgs) -> VdrAsset:
        """Get a VDR asset."""
        endpoint = "vdrAsset"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(VdrAsset),
        )
        if result.get(endpoint) is not None:
            return VdrAsset.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query vdrAsset")

    def vdr_vulnerabilities(
        self, arguments: VdrVulnerabilitiesInputArgs
    ) -> VdrVulnerabilities:
        """Get VDR asset vulnerabilities."""
        endpoint = "vdrVulnerabilities"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(VdrVulnerabilities),
        )
        if result.get(endpoint) is not None:
            return VdrVulnerabilities.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query vdrVulnerabilities")

    def vdr_tenant(self) -> VdrTenant:
        """Get VDR organization information."""
        endpoint = "vdrTenant"

        result = self.service.execute_query(
            endpoint=endpoint, variables={}, output=build_output_string(VdrTenant)
        )
        if result.get(endpoint) is not None:
            return VdrTenant.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query vdrTenant")
