"""Vdr Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class VdrSortOrder(str, Enum):
    """VdrSortOrder."""

    ASC = "ASC"
    DESC = "DESC"


class VdrAssetType(str, Enum):
    """VdrAssetType."""

    SERVERS = "servers"
    SITES = "sites"


class VdrVulnerabilitiesSortMode(str, Enum):
    """VdrVulnerabilitiesSortMode."""

    SEVERITY = "SEVERITY"
    DESCRIPTION = "DESCRIPTION"
    PRIORITY = "PRIORITY"


class VdrVulnerabilitySeverity(str, Enum):
    """VdrVulnerabilitySeverity."""

    CRITICAL = "CRITICAL"
    MEDIUM = "MEDIUM"
    WARNING = "WARNING"
    INFO = "INFO"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrApiEntityLinks:
    """VdrApiEntityLinks."""

    default_response: Optional[str] = field(
        default=None, metadata=config(field_name="defaultResponse")
    )
    delete: Optional[str] = field(default=None, metadata=config(field_name="delete"))
    edit: Optional[str] = field(default=None, metadata=config(field_name="edit"))
    history: Optional[str] = field(default=None, metadata=config(field_name="history"))
    logs: Optional[str] = field(default=None, metadata=config(field_name="logs"))
    reports: Optional[str] = field(default=None, metadata=config(field_name="reports"))
    scan: Optional[str] = field(default=None, metadata=config(field_name="scan"))
    schedule: Optional[str] = field(
        default=None, metadata=config(field_name="schedule")
    )
    self: Optional[str] = field(default=None, metadata=config(field_name="self"))
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrAssetFeatures:
    """VdrAssetFeatures."""

    content_type: Optional[List[str]] = field(
        default=None, metadata=config(field_name="contentType")
    )
    recognized_response: Optional[List[str]] = field(
        default=None, metadata=config(field_name="recognizedResponse")
    )
    response_code: Optional[List[int]] = field(
        default=None, metadata=config(field_name="responseCode")
    )
    scheme: Optional[List[str]] = field(
        default=None, metadata=config(field_name="scheme")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrAssetFingerprint:
    """VdrAssetFingerprint."""

    creation_date: Optional[str] = field(
        default=None, metadata=config(field_name="creationDate")
    )
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrAssetSchedule:
    """VdrAssetSchedule."""

    kill_time: Optional[str] = field(
        default=None, metadata=config(field_name="killTime")
    )
    monthday: Optional[int] = field(
        default=None, metadata=config(field_name="monthday")
    )
    period: Optional[str] = field(default=None, metadata=config(field_name="period"))
    retry_count: Optional[int] = field(
        default=None, metadata=config(field_name="retryCount")
    )
    retry_delay: Optional[int] = field(
        default=None, metadata=config(field_name="retryDelay")
    )
    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="startTime")
    )
    weekday: Optional[str] = field(default=None, metadata=config(field_name="weekday"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrAssetInputArgs:
    """VdrAssetInputArgs."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrTenant:
    """VdrTenant."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    instance: Optional[str] = field(
        default=None, metadata=config(field_name="instance")
    )
    xdr_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="xdrTenantId")
    )
    host_url: Optional[str] = field(default=None, metadata=config(field_name="hostUrl"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrVulnScore:
    """VdrVulnScore."""

    base: Optional[float] = field(default=None, metadata=config(field_name="base"))
    codes: Optional[List[str]] = field(
        default=None, metadata=config(field_name="codes")
    )
    path40: Optional[str] = field(default=None, metadata=config(field_name="path40"))
    sortable: Optional[float] = field(
        default=None, metadata=config(field_name="sortable")
    )
    step_base: Optional[float] = field(
        default=None, metadata=config(field_name="stepBase")
    )
    step_final: Optional[float] = field(
        default=None, metadata=config(field_name="stepFinal")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrTimeFilterInputArgs:
    """VdrTimeFilterInputArgs."""

    from_: Optional[str] = field(default=None, metadata=config(field_name="from"))
    to: Optional[str] = field(default=None, metadata=config(field_name="to"))
    relative: Optional[int] = field(
        default=None, metadata=config(field_name="relative")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrVulnerability:
    """VdrVulnerability."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    affected_tcp_ports: Optional[List[str]] = field(
        default=None, metadata=config(field_name="affectedTCPPorts")
    )
    affected_udp_ports: Optional[List[str]] = field(
        default=None, metadata=config(field_name="affectedUDPPorts")
    )
    aggregate_group: Optional[str] = field(
        default=None, metadata=config(field_name="aggregateGroup")
    )
    assessment_date: Optional[str] = field(
        default=None, metadata=config(field_name="assessmentDate")
    )
    assessment_user_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assessmentUserIds")
    )
    attack_class: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attackClass")
    )
    classification: Optional[str] = field(
        default=None, metadata=config(field_name="classification")
    )
    columns: Optional[List[str]] = field(
        default=None, metadata=config(field_name="columns")
    )
    cve_number: Optional[str] = field(
        default=None, metadata=config(field_name="cveNumber")
    )
    definition_hash: Optional[str] = field(
        default=None, metadata=config(field_name="definitionHash")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    differentiator: Optional[str] = field(
        default=None, metadata=config(field_name="differentiator")
    )
    first_discovery_date: Optional[str] = field(
        default=None, metadata=config(field_name="firstDiscoveryDate")
    )
    fixed_in_version: Optional[str] = field(
        default=None, metadata=config(field_name="fixedInVersion")
    )
    has_note: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNote")
    )
    has_threat_intel: Optional[bool] = field(
        default=None, metadata=config(field_name="hasThreatIntel")
    )
    has_verified: Optional[bool] = field(
        default=None, metadata=config(field_name="hasVerified")
    )
    host: Optional[str] = field(default=None, metadata=config(field_name="host"))
    host_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="hostIds")
    )
    http_code: Optional[int] = field(
        default=None, metadata=config(field_name="httpCode")
    )
    http_method: Optional[str] = field(
        default=None, metadata=config(field_name="httpMethod")
    )
    identity: Optional[str] = field(
        default=None, metadata=config(field_name="identity")
    )
    is_verified: Optional[bool] = field(
        default=None, metadata=config(field_name="isVerified")
    )
    last_seen_date: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenDate")
    )
    note_date: Optional[str] = field(
        default=None, metadata=config(field_name="noteDate")
    )
    param: Optional[str] = field(default=None, metadata=config(field_name="param"))
    payload: Optional[str] = field(default=None, metadata=config(field_name="payload"))
    plan_assign_date: Optional[str] = field(
        default=None, metadata=config(field_name="planAssignDate")
    )
    plan_id: Optional[str] = field(default=None, metadata=config(field_name="planId"))
    plan_user_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="planUserIds")
    )
    port: Optional[int] = field(default=None, metadata=config(field_name="port"))
    priority: Optional[str] = field(
        default=None, metadata=config(field_name="priority")
    )
    protocol: Optional[str] = field(
        default=None, metadata=config(field_name="protocol")
    )
    related_exploit_urls: Optional[List[str]] = field(
        default=None, metadata=config(field_name="relatedExploitUrls")
    )
    severity: Optional[str] = field(
        default=None, metadata=config(field_name="severity")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))
    verify_date: Optional[str] = field(
        default=None, metadata=config(field_name="verifyDate")
    )
    verify_user_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="verifyUserIds")
    )
    score: Optional[VdrVulnScore] = field(
        default=None, metadata=config(field_name="score")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrVulnerabilitiesFiltersInputArgs:
    """VdrVulnerabilitiesFiltersInputArgs."""

    cve: Optional[List[str]] = field(default=None, metadata=config(field_name="cve"))
    severity: Optional[List[VdrVulnerabilitySeverity]] = field(
        default=None, metadata=config(field_name="severity")
    )
    first_discovery_date: Optional[VdrTimeFilterInputArgs] = field(
        default=None, metadata=config(field_name="firstDiscoveryDate")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrVulnerabilitiesInputArgs:
    """VdrVulnerabilitiesInputArgs."""

    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    host_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="hostIds")
    )
    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))
    sort_by: Optional[VdrVulnerabilitiesSortMode] = field(
        default=None, metadata=config(field_name="sortBy")
    )
    sort_order: Optional[VdrSortOrder] = field(
        default=None, metadata=config(field_name="sortOrder")
    )
    filters: Optional[VdrVulnerabilitiesFiltersInputArgs] = field(
        default=None, metadata=config(field_name="filters")
    )
    exclude_filters: Optional[VdrVulnerabilitiesFiltersInputArgs] = field(
        default=None, metadata=config(field_name="excludeFilters")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrAsset:
    """VdrAsset."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    authentication_status: Optional[List[str]] = field(
        default=None, metadata=config(field_name="authenticationStatus")
    )
    contact_information: Optional[str] = field(
        default=None, metadata=config(field_name="contactInformation")
    )
    creation_date: Optional[str] = field(
        default=None, metadata=config(field_name="creationDate")
    )
    creation_type: Optional[str] = field(
        default=None, metadata=config(field_name="creationType")
    )
    days_until_autoremove: Optional[int] = field(
        default=None, metadata=config(field_name="daysUntilAutoremove")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    deterrents: Optional[List[str]] = field(
        default=None, metadata=config(field_name="deterrents")
    )
    exposure: Optional[List[str]] = field(
        default=None, metadata=config(field_name="exposure")
    )
    high_cps: Optional[float] = field(
        default=None, metadata=config(field_name="highCps")
    )
    high_cvss: Optional[float] = field(
        default=None, metadata=config(field_name="highCvss")
    )
    host_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="hostIds")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    ip: Optional[str] = field(default=None, metadata=config(field_name="ip"))
    is_active: Optional[bool] = field(
        default=None, metadata=config(field_name="isActive")
    )
    is_discovered: Optional[bool] = field(
        default=None, metadata=config(field_name="isDiscovered")
    )
    last_report_date: Optional[str] = field(
        default=None, metadata=config(field_name="lastReportDate")
    )
    last_seen_date: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenDate")
    )
    location: Optional[str] = field(
        default=None, metadata=config(field_name="location")
    )
    mac_vendor: Optional[str] = field(
        default=None, metadata=config(field_name="macVendor")
    )
    os_family: Optional[str] = field(
        default=None, metadata=config(field_name="osFamily")
    )
    os_name: Optional[str] = field(default=None, metadata=config(field_name="osName"))
    os_type: Optional[str] = field(default=None, metadata=config(field_name="osType"))
    scan_duration: Optional[float] = field(
        default=None, metadata=config(field_name="scanDuration")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    team_id: Optional[int] = field(default=None, metadata=config(field_name="teamID"))
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))
    has_ping: Optional[bool] = field(
        default=None, metadata=config(field_name="hasPing")
    )
    has_default_response_har: Optional[bool] = field(
        default=None, metadata=config(field_name="hasDefaultResponseHar")
    )
    start_url: Optional[str] = field(
        default=None, metadata=config(field_name="startURL")
    )
    static_ip_address: Optional[str] = field(
        default=None, metadata=config(field_name="staticIPAddress")
    )
    type: Optional[VdrAssetType] = field(
        default=None, metadata=config(field_name="type")
    )
    links: Optional[VdrApiEntityLinks] = field(
        default=None, metadata=config(field_name="links")
    )
    features: Optional[VdrAssetFeatures] = field(
        default=None, metadata=config(field_name="features")
    )
    fingerprints: Optional[List[VdrAssetFingerprint]] = field(
        default=None, metadata=config(field_name="fingerprints")
    )
    schedule: Optional[VdrAssetSchedule] = field(
        default=None, metadata=config(field_name="schedule")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class VdrVulnerabilities:
    """VdrVulnerabilities."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    vulnerabilities: Optional[List[VdrVulnerability]] = field(
        default=None, metadata=config(field_name="vulnerabilities")
    )
