# Generated by Django 3.0.14 on 2022-02-01 08:53

import core.fields
import datetime
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('location', '0007_auto_20211103_1046'),
        ('product', '0002_productmutation'),
    ]

    operations = [
        migrations.CreateModel(
            name='CapitationPayment',
            fields=[
                ('validity_from', core.fields.DateTimeField(db_column='ValidityFrom', default=datetime.datetime.now)),
                ('validity_to', core.fields.DateTimeField(blank=True, db_column='ValidityTo', null=True)),
                ('legacy_id', models.IntegerField(blank=True, db_column='LegacyID', null=True)),
                ('id', models.AutoField(db_column='CapitationPaymentID', primary_key=True, serialize=False)),
                ('uuid', models.CharField(db_column='CapitationPaymentUUID', default=uuid.uuid4, max_length=36, unique=True)),
                ('year', models.IntegerField(verbose_name='Year')),
                ('month', models.IntegerField(verbose_name='Month')),
                ('region_code', models.CharField(blank=True, db_column='RegionCode', max_length=8, null=True)),
                ('region_name', models.CharField(blank=True, db_column='RegionName', max_length=50, null=True)),
                ('district_code', models.CharField(blank=True, db_column='DistrictCode', max_length=8, null=True)),
                ('district_name', models.CharField(blank=True, db_column='DistrictName', max_length=50, null=True)),
                ('health_facility_code', models.CharField(db_column='HFCode', max_length=8)),
                ('health_facility_name', models.CharField(db_column='HFName', max_length=100)),
                ('acc_code', models.CharField(blank=True, db_column='AccCode', max_length=25, null=True)),
                ('hf_level', models.CharField(blank=True, db_column='HFLevel', max_length=100, null=True)),
                ('hf_sublevel', models.CharField(blank=True, db_column='HFSublevel', max_length=100, null=True)),
                ('total_population', models.DecimalField(blank=True, db_column='TotalPopulation', decimal_places=2, default=0, max_digits=18, null=True)),
                ('total_families', models.DecimalField(blank=True, db_column='TotalFamilies', decimal_places=2, default=0, max_digits=18, null=True)),
                ('total_insured_insuree', models.DecimalField(blank=True, db_column='TotalInsuredInsuree', decimal_places=2, default=0, max_digits=18, null=True)),
                ('total_insured_families', models.DecimalField(blank=True, db_column='TotalInsuredFamilies', decimal_places=2, default=0, max_digits=18, null=True)),
                ('total_claims', models.DecimalField(blank=True, db_column='TotalClaims', decimal_places=2, default=0, max_digits=18, null=True)),
                ('alc_contri_population', models.DecimalField(blank=True, db_column='AlcContriPopulation', decimal_places=2, default=0, max_digits=18, null=True)),
                ('alc_contri_num_families', models.DecimalField(blank=True, db_column='AlcContriNumFamilies', decimal_places=2, default=0, max_digits=18, null=True)),
                ('alc_contri_ins_population', models.DecimalField(blank=True, db_column='AlcContriInsPopulation', decimal_places=2, default=0, max_digits=18, null=True)),
                ('alc_contri_ins_families', models.DecimalField(blank=True, db_column='AlcContriInsFamilies', decimal_places=2, default=0, max_digits=18, null=True)),
                ('alc_contri_visits', models.DecimalField(blank=True, db_column='AlcContriVisits', decimal_places=2, default=0, max_digits=18, null=True)),
                ('alc_contri_adjusted_amount', models.DecimalField(blank=True, db_column='AlcContriAdjustedAmount', decimal_places=2, default=0, max_digits=18, null=True)),
                ('up_population', models.DecimalField(blank=True, db_column='UPPopulation', decimal_places=2, default=0, max_digits=18, null=True)),
                ('up_num_families', models.DecimalField(blank=True, db_column='UPNumFamilies', decimal_places=2, default=0, max_digits=18, null=True)),
                ('up_ins_population', models.DecimalField(blank=True, db_column='UPInsPopulation', decimal_places=2, default=0, max_digits=18, null=True)),
                ('up_ins_families', models.DecimalField(blank=True, db_column='UPInsFamilies', decimal_places=2, default=0, max_digits=18, null=True)),
                ('up_visits', models.DecimalField(blank=True, db_column='UPVisits', decimal_places=2, default=0, max_digits=18, null=True)),
                ('up_adjusted_amount', models.DecimalField(blank=True, db_column='UPAdjustedAmount', decimal_places=2, default=0, max_digits=18, null=True)),
                ('payment_cathment', models.DecimalField(blank=True, db_column='PaymentCathment', decimal_places=2, default=0, max_digits=18, null=True)),
                ('total_adjusted', models.DecimalField(blank=True, db_column='TotalAdjusted', decimal_places=2, default=0, max_digits=18, null=True)),
                ('health_facility', models.ForeignKey(db_column='HfID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='capitation_payment_health_facility', to='location.HealthFacility')),
                ('product', models.ForeignKey(db_column='ProductID', on_delete=django.db.models.deletion.DO_NOTHING, related_name='capitation_payment_product', to='product.Product')),
            ],
            options={
                'db_table': 'tblCapitationPayment',
            },
        ),
    ]
