# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ArtifactResponse(BaseModel):
    """
    Base serializer for use with [pulpcore.app.models.Model][]  This ensures that all Serializers provide values for the 'pulp_href` field.  The class provides a default for the ``ref_name`` attribute in the ModelSerializers's ``Meta`` class. This ensures that the OpenAPI definitions of plugins are namespaced properly.
    """ # noqa: E501
    pulp_href: Optional[StrictStr] = None
    prn: Optional[StrictStr] = Field(default=None, description="The Pulp Resource Name (PRN).")
    pulp_created: Optional[datetime] = Field(default=None, description="Timestamp of creation.")
    pulp_last_updated: Optional[datetime] = Field(default=None, description="Timestamp of the last time this resource was updated. Note: for immutable resources - like content, repository versions, and publication - pulp_created and pulp_last_updated dates will be the same.")
    file: StrictStr = Field(description="The stored file.")
    size: Optional[StrictInt] = Field(default=None, description="The size of the file in bytes.")
    md5: Optional[StrictStr] = Field(default=None, description="The MD5 checksum of the file if available.")
    sha1: Optional[StrictStr] = Field(default=None, description="The SHA-1 checksum of the file if available.")
    sha224: Optional[StrictStr] = Field(default=None, description="The SHA-224 checksum of the file if available.")
    sha256: Optional[StrictStr] = Field(default=None, description="The SHA-256 checksum of the file if available.")
    sha384: Optional[StrictStr] = Field(default=None, description="The SHA-384 checksum of the file if available.")
    sha512: Optional[StrictStr] = Field(default=None, description="The SHA-512 checksum of the file if available.")
    __properties: ClassVar[List[str]] = ["pulp_href", "prn", "pulp_created", "pulp_last_updated", "file", "size", "md5", "sha1", "sha224", "sha256", "sha384", "sha512"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArtifactResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pulp_href",
            "prn",
            "pulp_created",
            "pulp_last_updated",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if md5 (nullable) is None
        # and model_fields_set contains the field
        if self.md5 is None and "md5" in self.model_fields_set:
            _dict['md5'] = None

        # set to None if sha1 (nullable) is None
        # and model_fields_set contains the field
        if self.sha1 is None and "sha1" in self.model_fields_set:
            _dict['sha1'] = None

        # set to None if sha224 (nullable) is None
        # and model_fields_set contains the field
        if self.sha224 is None and "sha224" in self.model_fields_set:
            _dict['sha224'] = None

        # set to None if sha256 (nullable) is None
        # and model_fields_set contains the field
        if self.sha256 is None and "sha256" in self.model_fields_set:
            _dict['sha256'] = None

        # set to None if sha384 (nullable) is None
        # and model_fields_set contains the field
        if self.sha384 is None and "sha384" in self.model_fields_set:
            _dict['sha384'] = None

        # set to None if sha512 (nullable) is None
        # and model_fields_set contains the field
        if self.sha512 is None and "sha512" in self.model_fields_set:
            _dict['sha512'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArtifactResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pulp_href": obj.get("pulp_href"),
            "prn": obj.get("prn"),
            "pulp_created": obj.get("pulp_created"),
            "pulp_last_updated": obj.get("pulp_last_updated"),
            "file": obj.get("file"),
            "size": obj.get("size"),
            "md5": obj.get("md5"),
            "sha1": obj.get("sha1"),
            "sha224": obj.get("sha224"),
            "sha256": obj.get("sha256"),
            "sha384": obj.get("sha384"),
            "sha512": obj.get("sha512")
        })
        return _obj


