# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class GroupRole(BaseModel):
    """
    Serializer for GroupRole.
    """ # noqa: E501
    role: Annotated[str, Field(min_length=1, strict=True)]
    content_object: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="pulp_href of the object for which role permissions should be asserted. If set to 'null', permissions will act on the model-level.")
    content_object_prn: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="prn of the object for which role permissions should be asserted. If set to 'null', permissions will act on either domain or model-level.")
    domain: Optional[StrictStr] = Field(default=None, description="Domain this role should be applied on, mutually exclusive with content_object.")
    __properties: ClassVar[List[str]] = ["role", "content_object", "content_object_prn", "domain"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GroupRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if content_object (nullable) is None
        # and model_fields_set contains the field
        if self.content_object is None and "content_object" in self.model_fields_set:
            _dict['content_object'] = None

        # set to None if content_object_prn (nullable) is None
        # and model_fields_set contains the field
        if self.content_object_prn is None and "content_object_prn" in self.model_fields_set:
            _dict['content_object_prn'] = None

        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GroupRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "role": obj.get("role"),
            "content_object": obj.get("content_object"),
            "content_object_prn": obj.get("content_object_prn"),
            "domain": obj.get("domain")
        })
        return _obj


