# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class NestedOpenPGPSignatureResponse(BaseModel):
    """
    Base serializer for use with [pulpcore.app.models.Model][]  This ensures that all Serializers provide values for the 'pulp_href` field.  The class provides a default for the ``ref_name`` attribute in the ModelSerializers's ``Meta`` class. This ensures that the OpenAPI definitions of plugins are namespaced properly.
    """ # noqa: E501
    issuer: Optional[Annotated[str, Field(strict=True, max_length=16)]] = None
    created: datetime
    expiration_time: Optional[StrictStr] = None
    signers_user_id: Optional[StrictStr] = None
    key_expiration_time: Optional[StrictStr] = None
    expired: StrictBool
    key_expired: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["issuer", "created", "expiration_time", "signers_user_id", "key_expiration_time", "expired", "key_expired"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NestedOpenPGPSignatureResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "key_expired",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if issuer (nullable) is None
        # and model_fields_set contains the field
        if self.issuer is None and "issuer" in self.model_fields_set:
            _dict['issuer'] = None

        # set to None if expiration_time (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_time is None and "expiration_time" in self.model_fields_set:
            _dict['expiration_time'] = None

        # set to None if signers_user_id (nullable) is None
        # and model_fields_set contains the field
        if self.signers_user_id is None and "signers_user_id" in self.model_fields_set:
            _dict['signers_user_id'] = None

        # set to None if key_expiration_time (nullable) is None
        # and model_fields_set contains the field
        if self.key_expiration_time is None and "key_expiration_time" in self.model_fields_set:
            _dict['key_expiration_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NestedOpenPGPSignatureResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issuer": obj.get("issuer"),
            "created": obj.get("created"),
            "expiration_time": obj.get("expiration_time"),
            "signers_user_id": obj.get("signers_user_id"),
            "key_expiration_time": obj.get("key_expiration_time"),
            "expired": obj.get("expired"),
            "key_expired": obj.get("key_expired")
        })
        return _obj


