# -*- coding: utf-8 -*-
"""EVEN_20250602_00.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1aK3OYGYkbOcHvYa5L0gBsNoXrZSei8ns

# EasyVen

settings_ven.env から生成される環境変数を利用しやすい形で読み込む

```
2025/03/25 0.1.0 完成
2025/03/25 0.1.1 バグ取り
2025/03/25 0.1.2 バグ取り
2025/03/25 0.1.5 循環参照回避の試み
2025/03/27 0.1.7 バグ取り
2025/03/27 0.1.8 arc_path 修正
2025/03/28 0.2.0 tmp_path 追加
2025/03/30 0.2.1 lcl_path バグ取り
2025/03/30 0.2.4 表示ルーチンの改良
2025/03/31 0.2.5 バグ取り
2025/04/01 0.2.6 org_path 追加
2025/04/02 0.3.0 arz_path, orz_path追加
2025/04/04 0.4.0 enva_path 追加
2025/04/06 0.4.2 依存関係修復のため
2025/04/08 0.5.0 Project Unicornのため、envb_path, uni_path を追加
2025/04/24 0.6.0 arc_pathの内容を変更する
2025/05/13 0.7.0 logging対応
2025/06/02 0.8.0 EnvManagerの読み込みファイルを指定できるようにした
```

# EasyVen

## 1. logger 定義
"""

# @title a. logging定義
import logging
from google.colab import drive

logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s [%(levelname)s] %(name)s: %(message)s",
    force=True
)

"""## 2. モジュール定義"""

# @title a. EasyVen 定義
# ────────────────────────────────────────────────────────────────
# 各モジュール用logger設定
import logging
logger = logging.getLogger(__name__)
# ────────────────────────────────────────────────────────────────

import os
from pathlib import Path

try:
    from an_envmanager import EnvManager
except ImportError:
    get_ipython().system( "pip install  --upgrade an_EnvManager" )
    from an_envmanager import EnvManager


class EasyVen:
    def __init__( self, env_dir = "/content/drive/MyDrive/env/", env_files = [ "settings_ven.env" ] ):
        self.env_dir = env_dir
        self.envmanager = EnvManager( env_files = env_files )

    def setup( self,venv_name, back = 0):
        """
        定義ファイル[settings_ven.env]から環境変数を読み込みます
        args:
            venv_name : 仮想環境名
        return:
            [ bch_path,
              dst_path,
              cur_path,
              src_path,
              arc_path,
              arz_path,
              lcl_path,
              bin_path,
              lib_path,
              tmp_path,
              org_path,
              orz_path,
              enva_path,
              envb_path,
              uni_path ]
        """
        self.venv_name = venv_name


        # 環境変数から各種パスを読み出し
        self.base_folder            = self.envmanager.get_env_var("Ven_base_folder")
        self.venv_folder            = self.envmanager.get_env_var("Ven_venv_folder")
        self.app_folder             = self.envmanager.get_env_var("Ven_app_folder")
        self.venv_config_folder     = self.envmanager.get_env_var("Ven_venv_config_folder")
        self.venv_contents_folder   = self.envmanager.get_env_var("Ven_venv_contents_folder")
        self.local_venv_folder      = self.envmanager.get_env_var("Ven_local_venv_folder")
        self.local_app_folder       = self.envmanager.get_env_var("Ven_local_app_folder")
        self.archive_folder         = self.envmanager.get_env_var("Ven_archive_folder")

        logging.info( f"base_folder           : { self.base_folder }" )
        logging.info( f"venv_folder           : { self.venv_folder }" )
        logging.info( f"app_folder            : { self.app_folder }" )
        logging.info( f"venv_config_folder    : { self.venv_config_folder }" )
        logging.info( f"venv_contents_folder  : { self.venv_contents_folder }" )
        logging.info( f"local_venv_folder     : { self.local_venv_folder }" )
        logging.info( f"local_app_folder      : { self.local_app_folder }" )
        logging.info( f"archive_folder        : { self.archive_folder }" )


        self.bch_path = os.path.join( self.venv_contents_folder )
        self.dst_path = os.path.join( self.local_venv_folder )

        self.cur_path = Path( self.base_folder )
        self.src_path = Path( self.venv_folder ).joinpath( self.venv_name, self.venv_contents_folder )
        # self.arc_path = Path( self.archive_folder ).joinpath( self.venv_name ).with_suffix( ".tar.gz" )
        # self.arz_path = Path( self.archive_folder ).joinpath( self.venv_name ).with_suffix( ".tar.zst" )
        self.arc_path = Path( self.archive_folder )
        self.arz_path = Path( self.archive_folder )
        self.lcl_path = Path( self.local_venv_folder ).joinpath( self.venv_name, self.venv_contents_folder )
        self.bin_path = self.lcl_path.joinpath( "bin" )
        self.lib_path = self.lcl_path.joinpath( "lib" )
        self.tmp_path = Path( self.local_app_folder ).joinpath( self.venv_name )
        self.org_path = Path( self.archive_folder ).joinpath( "origin" ).with_suffix( ".tar.gz" )
        self.orz_path = Path( self.archive_folder ).joinpath( "origin" ).with_suffix( ".tar.zst" )
        self.enva_path = Path( self.archive_folder ).joinpath( self.venv_name.replace( "_env", "_enva" ) ).with_suffix( ".tar.gz" )
        self.envb_path = Path( self.archive_folder ).joinpath( self.venv_name.replace( "_env", "_envb" ) ).with_suffix( ".tar.gz" )
        self.uni_path = Path( self.archive_folder ).joinpath( "starlinka_env_setup.sh")

        logging.info( f"venv_name : { self.venv_name }" )
        logging.info( f"bch_path  : { self.bch_path }" )
        logging.info( f"dst_path  : { self.dst_path }" )
        logging.info( f"cur_path  : { self.cur_path }" )
        logging.info( f"src_path  : { self.src_path }" )
        logging.info( f"arc_path  : { self.arc_path }" )
        logging.info( f"arz_path  : { self.arz_path }" )
        logging.info( f"lcl_path  : { self.lcl_path }" )
        logging.info( f"bin_path  : { self.bin_path }" )
        logging.info( f"lib_path  : { self.lib_path }" )
        logging.info( f"tmp_path  : { self.tmp_path }" )
        logging.info( f"org_path  : { self.org_path }" )
        logging.info( f"orz_path  : { self.orz_path }" )
        logging.info( f"enva_path : { self.enva_path }" )
        logging.info( f"envb_path : { self.envb_path }" )
        logging.info( f"uni_path : { self.uni_path }" )

        return  [ self.bch_path,
                  self.dst_path,
                  self.cur_path,
                  self.src_path,
                  self.arc_path,
                  self.arz_path,
                  self.lcl_path,
                  self.bin_path,
                  self.lib_path,
                  self.tmp_path,
                  self.org_path,
                  self.orz_path,
                  self.enva_path,
                  self.envb_path,
                  self.uni_path ]

    def check( self, venv_name = "kohya_env", back = 0 ):
        """
        読み込んだ環境変数をチェックします
        args:
            venv_name : 仮想環境名
        """
        [ bch_path,
        dst_path,
        cur_path,
        src_path,
        arc_path,
        arz_path,
        lcl_path,
        bin_path,
        lib_path,
        tmp_path,
        org_path,
        orz_path,
        enva_path,
        envb_path,
        uni_path ] = self.setup( venv_name = venv_name )
        # self.debug.log_step( f"venv_name : { venv_name }", success = None )
        logging.info( f"bch_path  : { bch_path }" )
        logging.info( f"dst_path  : { dst_path }" )
        logging.info( f"cur_path  : { cur_path }" )
        logging.info( f"src_path  : { src_path }" )
        logging.info( f"arc_path  : { arc_path }" )
        logging.info( f"arz_path  : { arz_path }" )
        logging.info( f"lcl_path  : { lcl_path }" )
        logging.info( f"bin_path  : { bin_path }" )
        logging.info( f"lib_path  : { lib_path }" )
        logging.info( f"tmp_path  : { tmp_path }" )
        logging.info( f"org_path  : { org_path }" )
        logging.info( f"orz_path  : { orz_path }" )
        logging.info( f"enva_path : { enva_path }" )
        logging.info( f"envb_path : { envb_path }" )
        logging.info( f"uni_path : { uni_path }" )


if __name__ == "__main__":
    from google.colab import drive
    drive.mount( '/content/drive' )
    even = EasyVen()
    even.check( venv_name = "sd_env" )
