# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class CustomDomain(Resource):
    """
    CDN CustomDomain represents a mapping between a user specified domain name
    and a CDN endpoint. This is to use custom domain names to represent the
    URLs for branding purposes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param host_name: The host name of the custom domain. Must be a domain
     name.
    :type host_name: str
    :ivar resource_state: Resource status of the custom domain. Possible
     values include: 'Creating', 'Active', 'Deleting'
    :vartype resource_state: str or :class:`CustomDomainResourceState
     <azure.mgmt.cdn.models.CustomDomainResourceState>`
    :param provisioning_state: Provisioning status of the custom domain.
     Possible values include: 'Creating', 'Succeeded', 'Failed'
    :type provisioning_state: str or :class:`ProvisioningState
     <azure.mgmt.cdn.models.ProvisioningState>`
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'host_name': {'required': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'CustomDomainResourceState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
    }

    def __init__(self, host_name, provisioning_state=None):
        super(CustomDomain, self).__init__()
        self.host_name = host_name
        self.resource_state = None
        self.provisioning_state = provisioning_state
