"""
    Bundes-Klinik-Atlas API

    Die API des Bundes-Klinik-Atlas stellt eine Vielzahl von Informationen über deutsche Kliniken und deren Ausstattung bereit.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: poststelle@bmg.bund.de
    Generated by: https://openapi-generator.tech
"""

import re  # noqa: F401
import sys  # noqa: F401

from deutschland.klinikatlas.api_client import ApiClient
from deutschland.klinikatlas.api_client import Endpoint as _Endpoint
from deutschland.klinikatlas.model.fileadmin_json_german_places_json_get200_response_inner import (
    FileadminJsonGermanPlacesJsonGet200ResponseInner,
)
from deutschland.klinikatlas.model.fileadmin_json_german_states_json_get200_response_inner import (
    FileadminJsonGermanStatesJsonGet200ResponseInner,
)
from deutschland.klinikatlas.model.fileadmin_json_icd_codes_json_get200_response_inner import (
    FileadminJsonIcdCodesJsonGet200ResponseInner,
)
from deutschland.klinikatlas.model.fileadmin_json_locations_json_get200_response_inner import (
    FileadminJsonLocationsJsonGet200ResponseInner,
)
from deutschland.klinikatlas.model.fileadmin_json_ops_codes_json_get200_response_inner import (
    FileadminJsonOpsCodesJsonGet200ResponseInner,
)
from deutschland.klinikatlas.model.fileadmin_json_states_json_get200_response_inner import (
    FileadminJsonStatesJsonGet200ResponseInner,
)
from deutschland.klinikatlas.model.searchresults_get200_response import (
    SearchresultsGet200Response,
)
from deutschland.klinikatlas.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.fileadmin_json_german_places_json_get_endpoint = _Endpoint(
            settings={
                "response_type": ([FileadminJsonGermanPlacesJsonGet200ResponseInner],),
                "auth": [],
                "endpoint_path": "/fileadmin/json/german-places.json",
                "operation_id": "fileadmin_json_german_places_json_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.fileadmin_json_german_states_json_get_endpoint = _Endpoint(
            settings={
                "response_type": ([FileadminJsonGermanStatesJsonGet200ResponseInner],),
                "auth": [],
                "endpoint_path": "/fileadmin/json/german-states.json",
                "operation_id": "fileadmin_json_german_states_json_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.fileadmin_json_icd_codes_json_get_endpoint = _Endpoint(
            settings={
                "response_type": ([FileadminJsonIcdCodesJsonGet200ResponseInner],),
                "auth": [],
                "endpoint_path": "/fileadmin/json/icd_codes.json",
                "operation_id": "fileadmin_json_icd_codes_json_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.fileadmin_json_locations_json_get_endpoint = _Endpoint(
            settings={
                "response_type": ([FileadminJsonLocationsJsonGet200ResponseInner],),
                "auth": [],
                "endpoint_path": "/fileadmin/json/locations.json",
                "operation_id": "fileadmin_json_locations_json_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.fileadmin_json_ops_codes_json_get_endpoint = _Endpoint(
            settings={
                "response_type": ([FileadminJsonOpsCodesJsonGet200ResponseInner],),
                "auth": [],
                "endpoint_path": "/fileadmin/json/ops_codes.json",
                "operation_id": "fileadmin_json_ops_codes_json_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.fileadmin_json_states_json_get_endpoint = _Endpoint(
            settings={
                "response_type": ([FileadminJsonStatesJsonGet200ResponseInner],),
                "auth": [],
                "endpoint_path": "/fileadmin/json/states.json",
                "operation_id": "fileadmin_json_states_json_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {},
                "attribute_map": {},
                "location_map": {},
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.krankenhaussuche_krankenhaus_id_get_endpoint = _Endpoint(
            settings={
                "response_type": (str,),
                "auth": [],
                "endpoint_path": "/krankenhaussuche/krankenhaus/{id}/",
                "operation_id": "krankenhaussuche_krankenhaus_id_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "id",
                    "tx_tverzhospitaldata_show_department",
                    "tx_tverzhospitaldata_show_geolabel",
                    "tx_tverzhospitaldata_show_quantile",
                    "tx_tverzhospitaldata_show_searchlabel",
                    "c_hash",
                ],
                "required": [
                    "id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "id": (int,),
                    "tx_tverzhospitaldata_show_department": (str,),
                    "tx_tverzhospitaldata_show_geolabel": (str,),
                    "tx_tverzhospitaldata_show_quantile": (str,),
                    "tx_tverzhospitaldata_show_searchlabel": (str,),
                    "c_hash": (str,),
                },
                "attribute_map": {
                    "id": "id",
                    "tx_tverzhospitaldata_show_department": "tx_tverzhospitaldata_show[department]",
                    "tx_tverzhospitaldata_show_geolabel": "tx_tverzhospitaldata_show[geolabel]",
                    "tx_tverzhospitaldata_show_quantile": "tx_tverzhospitaldata_show[quantile]",
                    "tx_tverzhospitaldata_show_searchlabel": "tx_tverzhospitaldata_show[searchlabel]",
                    "c_hash": "cHash",
                },
                "location_map": {
                    "id": "path",
                    "tx_tverzhospitaldata_show_department": "query",
                    "tx_tverzhospitaldata_show_geolabel": "query",
                    "tx_tverzhospitaldata_show_quantile": "query",
                    "tx_tverzhospitaldata_show_searchlabel": "query",
                    "c_hash": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.searchresults_get_endpoint = _Endpoint(
            settings={
                "response_type": (SearchresultsGet200Response,),
                "auth": [],
                "endpoint_path": "/searchresults/",
                "operation_id": "searchresults_get",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "tx_solr_start",
                    "tx_solr_rows",
                    "tx_solr_geolabel",
                    "tx_solr_latlon",
                    "tx_solr_ops",
                    "tx_solr_searchlabel",
                    "tx_solr_icd",
                    "tx_solr_quantile",
                    "tx_solr_department",
                ],
                "required": [],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "tx_solr_start": (int,),
                    "tx_solr_rows": (int,),
                    "tx_solr_geolabel": (str,),
                    "tx_solr_latlon": (str,),
                    "tx_solr_ops": (str,),
                    "tx_solr_searchlabel": (str,),
                    "tx_solr_icd": (str,),
                    "tx_solr_quantile": (str,),
                    "tx_solr_department": (str,),
                },
                "attribute_map": {
                    "tx_solr_start": "tx_solr[start]",
                    "tx_solr_rows": "tx_solr[rows]",
                    "tx_solr_geolabel": "tx_solr[geolabel]",
                    "tx_solr_latlon": "tx_solr[latlon]",
                    "tx_solr_ops": "tx_solr[ops]",
                    "tx_solr_searchlabel": "tx_solr[searchlabel]",
                    "tx_solr_icd": "tx_solr[icd]",
                    "tx_solr_quantile": "tx_solr[quantile]",
                    "tx_solr_department": "tx_solr[department]",
                },
                "location_map": {
                    "tx_solr_start": "query",
                    "tx_solr_rows": "query",
                    "tx_solr_geolabel": "query",
                    "tx_solr_latlon": "query",
                    "tx_solr_ops": "query",
                    "tx_solr_searchlabel": "query",
                    "tx_solr_icd": "query",
                    "tx_solr_quantile": "query",
                    "tx_solr_department": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json", "text/html"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def fileadmin_json_german_places_json_get(self, **kwargs):
        """Liste deutscher Orte abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fileadmin_json_german_places_json_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FileadminJsonGermanPlacesJsonGet200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.fileadmin_json_german_places_json_get_endpoint.call_with_http_info(
            **kwargs
        )

    def fileadmin_json_german_states_json_get(self, **kwargs):
        """Liste deutscher Bundesländer mit Koordinaten abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fileadmin_json_german_states_json_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FileadminJsonGermanStatesJsonGet200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.fileadmin_json_german_states_json_get_endpoint.call_with_http_info(
            **kwargs
        )

    def fileadmin_json_icd_codes_json_get(self, **kwargs):
        """Liste der ICD-Codes abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fileadmin_json_icd_codes_json_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FileadminJsonIcdCodesJsonGet200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.fileadmin_json_icd_codes_json_get_endpoint.call_with_http_info(
            **kwargs
        )

    def fileadmin_json_locations_json_get(self, **kwargs):
        """Liste deutscher Kliniken abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fileadmin_json_locations_json_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FileadminJsonLocationsJsonGet200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.fileadmin_json_locations_json_get_endpoint.call_with_http_info(
            **kwargs
        )

    def fileadmin_json_ops_codes_json_get(self, **kwargs):
        """Liste der OPS-Codes abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fileadmin_json_ops_codes_json_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FileadminJsonOpsCodesJsonGet200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.fileadmin_json_ops_codes_json_get_endpoint.call_with_http_info(
            **kwargs
        )

    def fileadmin_json_states_json_get(self, **kwargs):
        """Liste deutscher Bundesländer abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fileadmin_json_states_json_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [FileadminJsonStatesJsonGet200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.fileadmin_json_states_json_get_endpoint.call_with_http_info(
            **kwargs
        )

    def krankenhaussuche_krankenhaus_id_get(self, id, **kwargs):
        """Details zu einem spezifischen Krankenhaus abrufen  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.krankenhaussuche_krankenhaus_id_get(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): Eindeutige Kennung des Krankenhauses

        Keyword Args:
            tx_tverzhospitaldata_show_department (str): Abteilungsfilter. [optional]
            tx_tverzhospitaldata_show_geolabel (str): Geografischer Labelfilter. [optional]
            tx_tverzhospitaldata_show_quantile (str): Quantilfilter. [optional]
            tx_tverzhospitaldata_show_searchlabel (str): Suchlabelfilter. [optional]
            c_hash (str): Cache-Hash. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["id"] = id
        return self.krankenhaussuche_krankenhaus_id_get_endpoint.call_with_http_info(
            **kwargs
        )

    def searchresults_get(self, **kwargs):
        """Suche nach Krankenhäusern basierend auf spezifischen Kriterien  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.searchresults_get(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            tx_solr_start (int): Startindex für die Suchergebnisse. [optional]
            tx_solr_rows (int): Anzahl der zurückzugebenden Zeilen. [optional]
            tx_solr_geolabel (str): Geographisches Label zum Filtern der Ergebnisse. [optional]
            tx_solr_latlon (str): Breitengrad und Längengrad zum Filtern der Ergebnisse. [optional]
            tx_solr_ops (str): OPS-Codes zum Filtern der Ergebnisse. [optional]
            tx_solr_searchlabel (str): Suchlabel zum Filtern der Ergebnisse. [optional]
            tx_solr_icd (str): ICD-Codes zum Filtern der Ergebnisse. [optional]
            tx_solr_quantile (str): Quantil zum Filtern der Ergebnisse. [optional]
            tx_solr_department (str): Abteilung zum Filtern der Ergebnisse. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SearchresultsGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        return self.searchresults_get_endpoint.call_with_http_info(**kwargs)
