# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, constr

from .. import GlobalObjectReference
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    srcm_v3 = 'srcm/v3'


class Kind(Enum):
    cluster = 'Cluster'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/srcm/v3/clusters/lsrc-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/cloud-cluster=lsrc-12345'
        ],
    )


class ClusterStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(
        ...,
        description='The lifecyle phase of the cluster:\n\n  PROVISIONED:  cluster is provisioned;\n\n  PROVISIONING:  cluster provisioning is in progress;\n\n  FAILED:  provisioning failed\n',
        examples=['PROVISIONED'],
    )


class KindModel(Enum):
    cluster_list = 'ClusterList'


class MetadataModel(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/srcm/v3/clusters']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/srcm/v3/clusters?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/srcm/v3/clusters?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/srcm/v3/clusters?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ClusterSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None, description='The cluster name.', examples=['Stream Governance package']
    )
    package: Optional[str] = Field(
        None,
        description='The billing package.\n\nNote: Clusters can be upgraded from ESSENTIALS to ADVANCED, but cannot be\ndowngraded from ADVANCED to ESSENTIALS.\n',
        examples=['ESSENTIALS'],
    )
    http_endpoint: Optional[AnyUrl] = Field(
        None,
        description='The cluster HTTP request URL.',
        examples=['https://psrc-00000.us-central1.gcp.confluent.cloud'],
    )
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider in which the cluster is running.',
        examples=['GCP'],
    )
    region: Optional[str] = Field(
        None,
        description='The cloud service provider region where the cluster is running.',
        examples=['us-east4'],
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Cluster(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    spec: Optional[ClusterSpec] = None
    status: Optional[ClusterStatus] = None


class Datum(Cluster):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class ClusterList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
