"""
Error Detectors can take as input a Logging
class
"""

class Logging:
	"""
	defines the abstract class for logging
	"""

	def logError(self, error_object):
		"""
		Given a dict generated by an error dector, logs
		"""
		raise NotImplemented("Loggers must implement logError")


	def logSchema(self, type_array):
		"""
		Given a dict generated by the type inference
		"""
		raise NotImplemented("Loggers must implement logSchema")

	def logFileType(self, size, cols):
		"""
		Given a dict generated by the type inference
		"""
		raise NotImplemented("Loggers must implement logFileType")


	def logConfig(self, module_array, config_array):
		"""
		Given a dict input to the detector
		"""
		raise NotImplemented("Loggers must implement logConfig")
