
# GromacsWrapper: gw-partial_tempering.py
# Copyright (c) 2009 Oliver Beckstein <orbeckst@gmail.com>
# Released under the GNU Public License 3 (or higher, your choice)
# See the file COPYING for details.

from gromacs.scaling import partial_tempering
import argparse

description="""
Modify gromacs processed topology (processed.top, generated by `grompp -pp` command)
for running with solute tempering replica exchange (REST2). 
"""

def parse_args():
	parser = argparse.ArgumentParser(description=description)
	parser.add_argument("--scale_protein", type=float, help="scale protein interactions by this scaling factor (0-1)")
	parser.add_argument("--scale_lipids", type=float, help="scale lipid interactions by this scaling factor (0-1)")
	parser.add_argument("--scale_protein_lipids", type=float, help="scale lipid-lipid interactions by this scaling factor (0-1)")
	parser.add_argument("input", help="input topology (processed.top)")
	parser.add_argument("output", help="output topology")
	parser.add_argument("--banned_lines", default="", help="line numbers of dihedrals/impropers that one wishes to exclude from scaling")
	return parser.parse_args()

args = parse_args()
partial_tempering(args)