output "credentials" {
  description = "Credentials required for connecting to kubernetes cluster"
  sensitive   = true
  value = {
    # see bottom of https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/kubernetes_cluster
    endpoint               = azurerm_kubernetes_cluster.main.kube_config.0.host
    username               = azurerm_kubernetes_cluster.main.kube_config.0.username
    password               = azurerm_kubernetes_cluster.main.kube_config.0.password
    client_certificate     = base64decode(azurerm_kubernetes_cluster.main.kube_config.0.client_certificate)
    client_key             = base64decode(azurerm_kubernetes_cluster.main.kube_config.0.client_key)
    cluster_ca_certificate = base64decode(azurerm_kubernetes_cluster.main.kube_config.0.cluster_ca_certificate)
  }
}

output "kubeconfig" {
  description = "Kubernetes connection kubeconfig"
  sensitive   = true
  value       = azurerm_kubernetes_cluster.main.kube_config_raw
}
