#!python
"""
Stub files generated by stubgen will miss @dataclass decorators.
This script fixes them.
"""
import sys
import re

REGEX = re.compile(r"(class \w*\(?Contract\)?)")


def fix_stubs(file_path):
    new_lines = []
    imported = False
    with open(file_path) as f:
        for line in f:
            if not imported and (line.startswith("import") or line.startswith("from ")):
                new_lines.append("from dataclasses import dataclass\n")
                imported = True

            new_lines.append(re.sub(REGEX, r"@dataclass\n\1", line))

    with open(file_path, "w") as f:
        f.writelines(new_lines)


if __name__ == "__main__":
    for f in sys.argv[1:]:
        fix_stubs(f)
