"""Clients Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.clients.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.clients import ClientsService

log = logging.getLogger(__name__)


class TaegisSDKClientsQuery:
    """Taegis Clients Query operations."""

    def __init__(self, service: ClientsService):
        self.service = service

    def client(self, id_: str) -> Client:
        """Get Client by id. The ID can be either the ID of the client object or the client_id."""
        endpoint = "client"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(Client),
        )
        if result.get(endpoint) is not None:
            return Client.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query client")

    def clients(
        self,
        name: Optional[str] = None,
        client_ids: Optional[List[str]] = None,
        tenant_id: Optional[str] = None,
        role_ids: Optional[List[str]] = None,
        tenant_ids: Optional[List[str]] = None,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> List[Client]:
        """Search Clients."""
        endpoint = "clients"

        log.warning(
            f"GraphQL Query `{endpoint}` is deprecated: 'Use clientsSearchResults instead, which includes totalCount and totalUnfilteredCount'"
        )

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "name": prepare_input(name),
                "clientIDs": prepare_input(client_ids),
                "tenantID": prepare_input(tenant_id),
                "roleIDs": prepare_input(role_ids),
                "tenantIDs": prepare_input(tenant_ids),
                "page": prepare_input(page),
                "perPage": prepare_input(per_page),
            },
            output=build_output_string(Client),
        )
        if result.get(endpoint) is not None:
            return Client.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query clients")

    def clients_search(
        self, filters: Optional[ClientsSearchInput] = None
    ) -> ClientSearchResults:
        """Returns clients matching the search criteria along with totalCount and totalUnfilteredCount."""
        endpoint = "clientsSearch"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "filters": prepare_input(filters),
            },
            output=build_output_string(ClientSearchResults),
        )
        if result.get(endpoint) is not None:
            return ClientSearchResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query clientsSearch")
