"""Comments Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentInput:
    """CommentInput."""

    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    parent_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_id")
    )
    parent_type: Optional[str] = field(
        default=None, metadata=config(field_name="parent_type")
    )
    read_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="readBy")
    )
    section_id: Optional[str] = field(
        default=None, metadata=config(field_name="section_id")
    )
    section_type: Optional[str] = field(
        default=None, metadata=config(field_name="section_type")
    )
    mentions: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mentions")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CommentUpdate:
    """CommentUpdate."""

    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    parent_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_id")
    )
    parent_type: Optional[str] = field(
        default=None, metadata=config(field_name="parent_type")
    )
    read_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="readBy")
    )
    section_id: Optional[str] = field(
        default=None, metadata=config(field_name="section_id")
    )
    section_type: Optional[str] = field(
        default=None, metadata=config(field_name="section_type")
    )
    mentions: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mentions")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Parent:
    """Parent."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ParentCount:
    """ParentCount."""

    parent_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_id")
    )
    parent_type: Optional[str] = field(
        default=None, metadata=config(field_name="parent_type")
    )
    total: Optional[int] = field(default=None, metadata=config(field_name="total"))
    unread: Optional[int] = field(default=None, metadata=config(field_name="unread"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LatestComment:
    """LatestComment."""

    parent_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_id")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TDRUser:
    """TDRUser."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Comment:
    """Comment."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    author: Optional[str] = field(default=None, metadata=config(field_name="author"))
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    parent_id: Optional[str] = field(
        default=None, metadata=config(field_name="parent_id")
    )
    parent_type: Optional[str] = field(
        default=None, metadata=config(field_name="parent_type")
    )
    read_by: Optional[List[str]] = field(
        default=None, metadata=config(field_name="read_by")
    )
    section_id: Optional[str] = field(
        default=None, metadata=config(field_name="section_id")
    )
    section_type: Optional[str] = field(
        default=None, metadata=config(field_name="section_type")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    mentions: Optional[List[str]] = field(
        default=None, metadata=config(field_name="mentions")
    )
    modified_at: Optional[str] = field(
        default=None, metadata=config(field_name="modified_at")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deleted_at")
    )
    author_user: Optional[TDRUser] = field(
        default=None, metadata=config(field_name="author_user")
    )
    mentions_users: Optional[List[TDRUser]] = field(
        default=None, metadata=config(field_name="mentions_users")
    )
