"""CqlMetadata Subscription."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.cql_metadata.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.cql_metadata import CqlMetadataService

log = logging.getLogger(__name__)


class TaegisSDKCqlMetadataSubscription:
    """Taegis Cql_metadata Subscription operations."""

    def __init__(self, service: CqlMetadataService):
        self.service = service

    def validate_event_query(
        self, query: str, options: Optional[EventQueryOptions] = None
    ) -> List[ValidatorResults]:
        """Validates a query string and returns a valid boolean or an error."""
        endpoint = "validateEventQuery"

        result = self.service.execute_subscription(
            endpoint=endpoint,
            variables={
                "query": prepare_input(query),
                "options": prepare_input(options),
            },
            output=build_output_string(ValidatorResults),
        )
        if any(r.get(endpoint) for r in result):
            return ValidatorResults.schema().load(
                [r.get(endpoint, {}) or {} for r in result], many=True
            )
        raise GraphQLNoRowsInResultSetError("for subscription validateEventQuery")
