"""Datasources Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class AuthzObject(str, Enum):
    """AuthzObject."""

    COLLECTOR = "COLLECTOR"


class AuthzAction(str, Enum):
    """AuthzAction."""

    READ = "READ"
    DELETE = "DELETE"


class HealthState(str, Enum):
    """HealthState."""

    HEALTHY = "HEALTHY"
    NO_DATA = "NO_DATA"
    WARNING = "WARNING"


class FilterCriteria(str, Enum):
    """FilterCriteria."""

    SOURCE_ID = "SOURCE_ID"
    STATUS = "STATUS"
    TYPE = "TYPE"
    SENSOR_TYPE = "SENSOR_TYPE"
    XDR_RELAY = "XDR_RELAY"


class LastSeenAssetsSort(str, Enum):
    """LastSeenAssetsSort."""

    SOURCE_ID_ASC = "SOURCE_ID_ASC"
    SOURCE_ID_DESC = "SOURCE_ID_DESC"
    STATUS_ASC = "STATUS_ASC"
    STATUS_DESC = "STATUS_DESC"
    LOG_LAST_SEEN_ASC = "LOG_LAST_SEEN_ASC"
    LOG_LAST_SEEN_DESC = "LOG_LAST_SEEN_DESC"
    TYPE_ASC = "TYPE_ASC"
    TYPE_DESC = "TYPE_DESC"
    SENSOR_TYPE_ASC = "SENSOR_TYPE_ASC"
    SENSOR_TYPE_DESC = "SENSOR_TYPE_DESC"
    COLLECTOR_ID_ASC = "COLLECTOR_ID_ASC"
    COLLECTOR_ID_DESC = "COLLECTOR_ID_DESC"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeletedAsset:
    """DeletedAsset."""

    source_id: Optional[str] = field(
        default=None, metadata=config(field_name="sourceId")
    )
    collector_id: Optional[str] = field(
        default=None, metadata=config(field_name="collectorID")
    )
    successful: Optional[bool] = field(
        default=None, metadata=config(field_name="successful")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteAssetInput:
    """DeleteAssetInput."""

    source_id: Optional[str] = field(
        default=None, metadata=config(field_name="sourceId")
    )
    collector_id: Optional[str] = field(
        default=None, metadata=config(field_name="collectorId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GetDataSourceInput:
    """GetDataSourceInput."""

    collector_id: Optional[str] = field(
        default=None, metadata=config(field_name="collectorId")
    )
    source_id: Optional[str] = field(
        default=None, metadata=config(field_name="sourceId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PageInfo:
    """PageInfo."""

    end_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="endCursor")
    )
    start_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="startCursor")
    )
    has_next_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNextPage")
    )
    has_previous_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasPreviousPage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class QLPageCursor:
    """QLPageCursor."""

    next_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="nextCursor")
    )
    previous_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="previousCursor")
    )
    cursor: Optional[str] = field(default=None, metadata=config(field_name="cursor"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DataSourcesWhereInput:
    """DataSourcesWhereInput."""

    source_id: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sourceId")
    )
    source_id_search: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sourceIdSearch")
    )
    type: Optional[List[str]] = field(default=None, metadata=config(field_name="type"))
    sensor_type: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    collector_id: Optional[List[str]] = field(
        default=None, metadata=config(field_name="collectorId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LastSeenQueryInput:
    """LastSeenQueryInput."""

    ql: Optional[str] = field(default=None, metadata=config(field_name="ql"))
    cursor: Optional[str] = field(default=None, metadata=config(field_name="cursor"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FilterValue:
    """FilterValue."""

    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ClusterIdentity:
    """ClusterIdentity."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LastSeenAsset:
    """LastSeenAsset."""

    source_id: Optional[str] = field(
        default=None, metadata=config(field_name="sourceId")
    )
    service: Optional[str] = field(default=None, metadata=config(field_name="service"))
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    collector_id: Optional[str] = field(
        default=None, metadata=config(field_name="collectorID")
    )
    last_seen: Optional[int] = field(
        default=None, metadata=config(field_name="lastSeen")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    health: Optional[Union[HealthState, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(HealthState, x),
            field_name="health",
        ),
    )
    collector: Optional[ClusterIdentity] = field(
        default=None, metadata=config(field_name="collector")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DataSourceAssetsFilter:
    """DataSourceAssetsFilter."""

    status: Optional[List[Union[HealthState, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(HealthState, x),
            field_name="status",
        ),
    )
    where: Optional[DataSourcesWhereInput] = field(
        default=None, metadata=config(field_name="where")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LastSeenAssets:
    """LastSeenAssets."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    assets: Optional[List[LastSeenAsset]] = field(
        default=None, metadata=config(field_name="assets")
    )
    page_info: Optional[PageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LastSeenAssetsQueryResult:
    """LastSeenAssetsQueryResult."""

    aggregations: Optional[List[dict]] = field(
        default=None, metadata=config(field_name="aggregations")
    )
    assets: Optional[List[LastSeenAsset]] = field(
        default=None, metadata=config(field_name="assets")
    )
    pagination: Optional[QLPageCursor] = field(
        default=None, metadata=config(field_name="pagination")
    )


FilterValueResponse = Union[
    FilterValue,
    ClusterIdentity,
]


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class FilterValues:
    """FilterValues."""

    filter: Optional[Union[FilterCriteria, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(FilterCriteria, x),
            field_name="filter",
        ),
    )
    values: Optional[List[FilterValueResponse]] = field(
        default=None,
        metadata=config(
            decoder=lambda x: parse_union_result(FilterValueResponse, x),
            field_name="values",
        ),
    )
