"""DetectorRegistry Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.detector_registry.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.detector_registry import DetectorRegistryService

log = logging.getLogger(__name__)


class TaegisSDKDetectorRegistryQuery:
    """Taegis Detector_registry Query operations."""

    def __init__(self, service: DetectorRegistryService):
        self.service = service

    def detector(self, id_: str) -> RegisteredDetector:
        """returns registered detector by ID."""
        endpoint = "detector"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(RegisteredDetector),
        )
        if result.get(endpoint) is not None:
            return RegisteredDetector.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query detector")

    def detectors(self) -> List[RegisteredDetector]:
        """returns all detectors."""
        endpoint = "detectors"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(RegisteredDetector),
        )
        if result.get(endpoint) is not None:
            return RegisteredDetector.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query detectors")

    def search_detectors(self, input_: SearchDetectors) -> List[RegisteredDetector]:
        """searches detectors given the input criteria."""
        endpoint = "searchDetectors"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(RegisteredDetector),
        )
        if result.get(endpoint) is not None:
            return RegisteredDetector.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query searchDetectors")

    def detector_by_name(self, display_name: str) -> List[str]:
        """returns ids that match the given registered detector name."""
        endpoint = "detectorByName"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "displayName": prepare_input(display_name),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query detectorByName")
