"""EntityContext Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.entity_context.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.entity_context import EntityContextService

log = logging.getLogger(__name__)


class TaegisSDKEntityContextMutation:
    """Taegis Entity_context Mutation operations."""

    def __init__(self, service: EntityContextService):
        self.service = service

    def entity_context_add_to(
        self,
        entry_point: EntityContextEntryPoint,
        to_add: EntityContextAddToInput,
        filters: Optional[EntityContextGroupedSubgraphFilters] = None,
    ) -> EntityContextGroupedSubgraphForResponse:
        """Mutation to add an subgraph to the graph.
        The entrypoint specifies the type of object you are adding to and will syncronously call the coresponding API.
        Afterwards a subgraph will be generated from the resource ids in options and added to the graph.
        If multiple Ids are specified, the mutation will be applied to all of them and returned as one subgraph..
        """
        endpoint = "entityContextAddTo"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "entryPoint": prepare_input(entry_point),
                "toAdd": prepare_input(to_add),
                "filters": prepare_input(filters),
            },
            output=build_output_string(EntityContextGroupedSubgraphForResponse),
        )
        if result.get(endpoint) is not None:
            return EntityContextGroupedSubgraphForResponse.from_dict(
                result.get(endpoint)
            )
        raise GraphQLNoRowsInResultSetError("for mutation entityContextAddTo")
