"""EntityContext Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.entity_context.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.entity_context import EntityContextService

log = logging.getLogger(__name__)


class TaegisSDKEntityContextQuery:
    """Taegis Entity_context Query operations."""

    def __init__(self, service: EntityContextService):
        self.service = service

    def entity_context(
        self, entity_id: str, origin: Optional[EntityContextOrigin] = None
    ) -> EntityContextEntity:
        """Returns a single entity that matches the provided id. Must use hashed global id of the entity.."""
        endpoint = "entityContext"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "entityID": prepare_input(entity_id),
                "origin": prepare_input(origin),
            },
            output=build_output_string(EntityContextEntity),
        )
        if result.get(endpoint) is not None:
            return EntityContextEntity.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query entityContext")

    def entity_context_by_identifiers(
        self,
        identifiers: EntityContextIdByIdentifiers,
        origin: Optional[EntityContextOrigin] = None,
    ) -> EntityContextEntity:
        """Returns a single entity that matches the provided id. Must use valid set or superset of identifiers.
        EntityContextIdByIdentifiers.matchWeakerIdentifiers must be set to false, as only a single entity may be returned by this query.
        Use 'entityContexts' for multiple entities by identifiers.."""
        endpoint = "entityContextByIdentifiers"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "identifiers": prepare_input(identifiers),
                "origin": prepare_input(origin),
            },
            output=build_output_string(EntityContextEntity),
        )
        if result.get(endpoint) is not None:
            return EntityContextEntity.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query entityContextByIdentifiers")

    def entity_contexts(
        self,
        arguments: EntityContextsArguments,
        page: Optional[EntityContextPageInput] = None,
    ) -> EntityContexts:
        """Returns a list of entities that match the arguments.."""
        endpoint = "entityContexts"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
                "page": prepare_input(page),
            },
            output=build_output_string(EntityContexts),
        )
        if result.get(endpoint) is not None:
            return EntityContexts.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query entityContexts")

    def entity_context_edge(
        self, edge_id: str, origin: Optional[EntityContextOrigin] = None
    ) -> EntityContextEdge:
        """Returns a single edge that matches the provided id. Must use hashed global id of the edge.."""
        endpoint = "entityContextEdge"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "edgeId": prepare_input(edge_id),
                "origin": prepare_input(origin),
            },
            output=build_output_string(EntityContextEdge),
        )
        if result.get(endpoint) is not None:
            return EntityContextEdge.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query entityContextEdge")

    def entity_context_grouped_subgraph_for(
        self,
        entry_point: EntityContextEntryPoint,
        filters: Optional[EntityContextGroupedSubgraphFilters] = None,
        source: Optional[EntityContextSourceInput] = None,
        options: Optional[Any] = None,
    ) -> EntityContextGroupedSubgraphForResponse:
        """Returns a subgraph with any edges of the same type between two entities grouped together.
        The data source for the subgraph can be from the graph, on-demand, or a on-demand fallback.
        Choosing to retrieve only data currently present in the graph will be the fastest option.
        ON_DEMAND_FALLBACK is the default and is a compromise of the two, first searching the graph
        and then populating the missing data with on-demand data (which can be much slower)..
        """
        endpoint = "entityContextGroupedSubgraphFor"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "entryPoint": prepare_input(entry_point),
                "filters": prepare_input(filters),
                "source": prepare_input(source),
                "options": prepare_input(options),
            },
            output=build_output_string(EntityContextGroupedSubgraphForResponse),
        )
        if result.get(endpoint) is not None:
            return EntityContextGroupedSubgraphForResponse.from_dict(
                result.get(endpoint)
            )
        raise GraphQLNoRowsInResultSetError("for query entityContextGroupedSubgraphFor")

    def entity_context_related_resources(
        self,
        entry_point: EntityContextEntryPoint,
        time_filter: Optional[EntityContextTimeFilters] = None,
        page: Optional[EntityContextPageInput] = None,
    ) -> EntityContextRelatedResources:
        """Provides a list of related events, alerts, and investigations for a given element. If the entryPoint is of type Entity
        it will look at all the edges that are incoming or outgoing to the provided entities. All other entryPoint types will
        correspond to an edge, which will look at the incoming or outgoing edges from the provided edges vertices.

        Warning: It is possible for data to be missing for highly connected entrypoints. This is because we have a hard limit on
        the number of edges we can explore to prevent timeouts.."""
        endpoint = "entityContextRelatedResources"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "entryPoint": prepare_input(entry_point),
                "timeFilter": prepare_input(time_filter),
                "page": prepare_input(page),
            },
            output=build_output_string(EntityContextRelatedResources),
        )
        if result.get(endpoint) is not None:
            return EntityContextRelatedResources.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query entityContextRelatedResources")

    def entity_context_associated_entities(
        self,
        entry_point: EntityContextEntryPoint,
        filters: EntityContextAssociatedEntitiesFilters = EntityContextAssociatedEntitiesFilters.from_dict(
            {
                "sortOrder": "DESC",
                "filter": {"timeFilter": {"lastSeen": {}}, "collectProperties": True},
            }
        ),
        page: Optional[EntityContextPageInput] = None,
        source: Optional[EntityContextSourceInput] = None,
    ) -> EntityContextAssociatedEntitiesResponse:
        """Provides a list of related entities for a given element. If the entrypoint is an entity, it will return just the
        input entity. If its an edge or resource, it will return the entities connected to the edge or resource. If page is
        null it will return all entities. If page is not null, it will return a page of entities sorted by the filters

        Warning: It is possible for data to be missing for highly connected entrypoints. This is because we have a hard limit on
        the number of edges we can explore to prevent timeouts.."""
        endpoint = "entityContextAssociatedEntities"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "entryPoint": prepare_input(entry_point),
                "filters": prepare_input(filters),
                "page": prepare_input(page),
                "source": prepare_input(source),
            },
            output=build_output_string(EntityContextAssociatedEntitiesResponse),
        )
        if result.get(endpoint) is not None:
            return EntityContextAssociatedEntitiesResponse.from_dict(
                result.get(endpoint)
            )
        raise GraphQLNoRowsInResultSetError("for query entityContextAssociatedEntities")

    def entity_context_pivot_ql(
        self,
        entry_point: EntityContextEntryPoint,
        options: EntityContextPivotQLOptions = EntityContextPivotQLOptions.from_dict(
            {
                "aggregation": "PER_ENTITY",
                "type": "EVENTS",
                "useStructuredEntities": True,
            }
        ),
        source: Optional[EntityContextSourceInput] = None,
    ) -> List[EntityContextPivotQLQuery]:
        """Provides a list of QL queries that can be used to pivot from the provided entry point. If the entrypoint is an
        edge, event, alert, or investigation, it will return a list of queries that can be used to pivot to the entities
        associated with them.."""
        endpoint = "entityContextPivotQL"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "entryPoint": prepare_input(entry_point),
                "options": prepare_input(options),
                "source": prepare_input(source),
            },
            output=build_output_string(EntityContextPivotQLQuery),
        )
        if result.get(endpoint) is not None:
            return EntityContextPivotQLQuery.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query entityContextPivotQL")
