"""EntityContext Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class EntityContextEntryPointType(str, Enum):
    """EntityContextEntryPointType."""

    ENTITY = "ENTITY"
    EDGE = "EDGE"
    ALERT = "ALERT"
    EVENT = "EVENT"
    INVESTIGATION = "INVESTIGATION"
    PROCESS = "PROCESS"


class EntityContextOriginType(str, Enum):
    """EntityContextOriginType."""

    ALERT = "ALERT"
    EVENT = "EVENT"
    INVESTIGATION = "INVESTIGATION"


class EntityContextSource(str, Enum):
    """EntityContextSource."""

    GRAPH = "GRAPH"
    ON_DEMAND = "ON_DEMAND"
    ON_DEMAND_FALLBACK = "ON_DEMAND_FALLBACK"


class EntityContextTraversalStrategy(str, Enum):
    """EntityContextTraversalStrategy."""

    OUTGOING = "OUTGOING"
    INCOMING = "INCOMING"
    BOTH = "BOTH"


class EntityContextSortOrder(str, Enum):
    """EntityContextSortOrder."""

    ASC = "ASC"
    DESC = "DESC"
    SHUFFLE = "SHUFFLE"


class ENTITY_CONTEXT_PROPERTY_CARDINALITY(str, Enum):
    """ENTITY_CONTEXT_PROPERTY_CARDINALITY."""

    UNKNOWN = "UNKNOWN"
    SINGLE = "SINGLE"
    SET = "SET"
    LIST = "LIST"


class ENTITY_CONTEXT_PROPERTY_DATA_TYPE(str, Enum):
    """ENTITY_CONTEXT_PROPERTY_DATA_TYPE."""

    UNKNOWN = "UNKNOWN"
    BOOL = "BOOL"
    BYTE = "BYTE"
    SHORT = "SHORT"
    INT = "INT"
    LONG = "LONG"
    FLOAT = "FLOAT"
    DOUBLE = "DOUBLE"
    STRING = "STRING"
    DATE = "DATE"


class EntityContextPivotQLType(str, Enum):
    """EntityContextPivotQLType."""

    EVENTS = "EVENTS"
    ALERTS = "ALERTS"


class EntityContextPivotQLAggregation(str, Enum):
    """EntityContextPivotQLAggregation."""

    PER_ENTITY = "PER_ENTITY"
    PER_SOURCE = "PER_SOURCE"


class ENTITY_CONTEXT_PROPERTY_COMPARATOR(str, Enum):
    """ENTITY_CONTEXT_PROPERTY_COMPARATOR."""

    EQUALS = "EQUALS"
    NOT_EQUALS = "NOT_EQUALS"
    GREATER_THAN = "GREATER_THAN"
    GREATER_THAN_OR_EQUAL = "GREATER_THAN_OR_EQUAL"
    LESS_THAN = "LESS_THAN"
    LESS_THAN_OR_EQUAL = "LESS_THAN_OR_EQUAL"
    CONTAINS = "CONTAINS"
    STARTS_WITH = "STARTS_WITH"
    ENDS_WITH = "ENDS_WITH"


class EntityContextAddToTypeInput(str, Enum):
    """EntityContextAddToTypeInput."""

    ALERT = "ALERT"
    EVENT = "EVENT"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextPivotQLQuery:
    """EntityContextPivotQLQuery."""

    source: Optional[List[str]] = field(
        default=None, metadata=config(field_name="source")
    )
    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    source_entities: Optional[List[str]] = field(
        default=None, metadata=config(field_name="sourceEntities")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextIpGeoEnrichment:
    """EntityContextIpGeoEnrichment."""

    city_id: Optional[int] = field(default=None, metadata=config(field_name="cityId"))
    city_names: Optional[dict] = field(
        default=None, metadata=config(field_name="cityNames")
    )
    continent_id: Optional[int] = field(
        default=None, metadata=config(field_name="continentId")
    )
    continent_code: Optional[str] = field(
        default=None, metadata=config(field_name="continentCode")
    )
    country_id: Optional[int] = field(
        default=None, metadata=config(field_name="countryId")
    )
    country_iso_code: Optional[str] = field(
        default=None, metadata=config(field_name="countryIsoCode")
    )
    aso: Optional[str] = field(default=None, metadata=config(field_name="aso"))
    asn: Optional[int] = field(default=None, metadata=config(field_name="asn"))
    latitude: Optional[float] = field(
        default=None, metadata=config(field_name="latitude")
    )
    longitude: Optional[float] = field(
        default=None, metadata=config(field_name="longitude")
    )
    metro_code: Optional[int] = field(
        default=None, metadata=config(field_name="metroCode")
    )
    time_zone: Optional[str] = field(
        default=None, metadata=config(field_name="timeZone")
    )
    accuracy_radius: Optional[int] = field(
        default=None, metadata=config(field_name="accuracyRadius")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextIdentifier:
    """EntityContextIdentifier."""

    property_key: Optional[str] = field(
        default=None, metadata=config(field_name="propertyKey")
    )
    property_value: Optional[Any] = field(
        default=None, metadata=config(field_name="propertyValue")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextPageInput:
    """EntityContextPageInput."""

    start_range: Optional[int] = field(
        default=None, metadata=config(field_name="startRange")
    )
    end_range: Optional[int] = field(
        default=None, metadata=config(field_name="endRange")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextPageInfo:
    """EntityContextPageInfo."""

    start_range: Optional[int] = field(
        default=None, metadata=config(field_name="startRange")
    )
    end_range: Optional[int] = field(
        default=None, metadata=config(field_name="endRange")
    )
    has_next: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNext")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextTimeRange:
    """EntityContextTimeRange."""

    start: Optional[str] = field(default=None, metadata=config(field_name="start"))
    end: Optional[str] = field(default=None, metadata=config(field_name="end"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatContextDomainInfo:
    """ThreatContextDomainInfo."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatContextIPInfo:
    """ThreatContextIPInfo."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatContextFileInfo:
    """ThreatContextFileInfo."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ThreatContextURLInfo:
    """ThreatContextURLInfo."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetEndpointGroupV2:
    """EntityContextAssetEndpointGroupV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetHostnameV2:
    """EntityContextAssetHostnameV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetEthernetAddressV2:
    """EntityContextAssetEthernetAddressV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    mac: Optional[str] = field(default=None, metadata=config(field_name="mac"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetIpAddressV2:
    """EntityContextAssetIpAddressV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    ip: Optional[str] = field(default=None, metadata=config(field_name="ip"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetUserV2:
    """EntityContextAssetUserV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetTagV2:
    """EntityContextAssetTagV2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    tag: Optional[str] = field(default=None, metadata=config(field_name="tag"))
    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextWhoIsTimeInfo:
    """EntityContextWhoIsTimeInfo."""

    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    updated: Optional[str] = field(default=None, metadata=config(field_name="updated"))
    expires: Optional[str] = field(default=None, metadata=config(field_name="expires"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextWhoIsContact:
    """EntityContextWhoIsContact."""

    email: Optional[str] = field(default=None, metadata=config(field_name="email"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    organization: Optional[str] = field(
        default=None, metadata=config(field_name="organization")
    )
    street1: Optional[str] = field(default=None, metadata=config(field_name="street1"))
    street2: Optional[str] = field(default=None, metadata=config(field_name="street2"))
    street3: Optional[str] = field(default=None, metadata=config(field_name="street3"))
    street4: Optional[str] = field(default=None, metadata=config(field_name="street4"))
    city: Optional[str] = field(default=None, metadata=config(field_name="city"))
    state: Optional[str] = field(default=None, metadata=config(field_name="state"))
    postal_code: Optional[str] = field(
        default=None, metadata=config(field_name="postalCode")
    )
    country: Optional[str] = field(default=None, metadata=config(field_name="country"))
    fax: Optional[str] = field(default=None, metadata=config(field_name="fax"))
    fax_ext: Optional[str] = field(default=None, metadata=config(field_name="faxExt"))
    telephone: Optional[str] = field(
        default=None, metadata=config(field_name="telephone")
    )
    telephone_ext: Optional[str] = field(
        default=None, metadata=config(field_name="telephoneExt")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextOrigin:
    """EntityContextOrigin."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    type: Optional[Union[EntityContextOriginType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextOriginType, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextSourceInput:
    """EntityContextSourceInput."""

    source: Optional[Union[EntityContextSource, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextSource, x),
            field_name="source",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextIdByIdentifiers:
    """EntityContextIdByIdentifiers."""

    entity_type: Optional[str] = field(
        default=None, metadata=config(field_name="entityType")
    )
    match_weaker_identifiers: Optional[bool] = field(
        default=None, metadata=config(field_name="matchWeakerIdentifiers")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    identifiers: Optional[List[EntityContextIdentifier]] = field(
        default=None, metadata=config(field_name="identifiers")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextRelatedResources:
    """EntityContextRelatedResources."""

    related_events: Optional[List[str]] = field(
        default=None, metadata=config(field_name="relatedEvents")
    )
    related_alerts: Optional[List[str]] = field(
        default=None, metadata=config(field_name="relatedAlerts")
    )
    related_investigations: Optional[List[str]] = field(
        default=None, metadata=config(field_name="relatedInvestigations")
    )
    page_info: Optional[EntityContextPageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextPropertyQuery:
    """EntityContextPropertyQuery."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    value: Optional[Any] = field(default=None, metadata=config(field_name="value"))
    comparator: Optional[Union[ENTITY_CONTEXT_PROPERTY_COMPARATOR, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ENTITY_CONTEXT_PROPERTY_COMPARATOR, x),
            field_name="comparator",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAddToInput:
    """EntityContextAddToInput."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    type: Optional[Union[EntityContextAddToTypeInput, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextAddToTypeInput, x),
            field_name="type",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextProperty:
    """EntityContextProperty."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    values: Optional[List[Any]] = field(
        default=None, metadata=config(field_name="values")
    )
    cardinality: Optional[Union[ENTITY_CONTEXT_PROPERTY_CARDINALITY, TaegisEnum]] = (
        field(
            default=None,
            metadata=config(
                encoder=encode_enum,
                decoder=lambda x: decode_enum(ENTITY_CONTEXT_PROPERTY_CARDINALITY, x),
                field_name="cardinality",
            ),
        )
    )
    data_type: Optional[Union[ENTITY_CONTEXT_PROPERTY_DATA_TYPE, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ENTITY_CONTEXT_PROPERTY_DATA_TYPE, x),
            field_name="dataType",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextTimeFilters:
    """EntityContextTimeFilters."""

    first_seen: Optional[EntityContextTimeRange] = field(
        default=None, metadata=config(field_name="firstSeen")
    )
    last_seen: Optional[EntityContextTimeRange] = field(
        default=None, metadata=config(field_name="lastSeen")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextEntryPoint:
    """EntityContextEntryPoint."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    options: Optional[Any] = field(default=None, metadata=config(field_name="options"))
    type: Optional[Union[EntityContextEntryPointType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextEntryPointType, x),
            field_name="type",
        ),
    )
    ids_by_identifiers: Optional[List[EntityContextIdByIdentifiers]] = field(
        default=None, metadata=config(field_name="idsByIdentifiers")
    )
    origin: Optional[EntityContextOrigin] = field(
        default=None, metadata=config(field_name="origin")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextThreatContextEnrichment:
    """EntityContextThreatContextEnrichment."""

    domain: Optional[ThreatContextDomainInfo] = field(
        default=None, metadata=config(field_name="domain")
    )
    ip: Optional[ThreatContextIPInfo] = field(
        default=None, metadata=config(field_name="ip")
    )
    file: Optional[ThreatContextFileInfo] = field(
        default=None, metadata=config(field_name="file")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextPivotQLOptions:
    """EntityContextPivotQLOptions."""

    min_alert_severity: Optional[float] = field(
        default=None, metadata=config(field_name="minAlertSeverity")
    )
    use_structured_entities: Optional[bool] = field(
        default=None, metadata=config(field_name="useStructuredEntities")
    )
    aggregation: Optional[Union[EntityContextPivotQLAggregation, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextPivotQLAggregation, x),
            field_name="aggregation",
        ),
    )
    type: Optional[Union[EntityContextPivotQLType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextPivotQLType, x),
            field_name="type",
        ),
    )
    time_range: Optional[EntityContextTimeRange] = field(
        default=None, metadata=config(field_name="timeRange")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextsArguments:
    """EntityContextsArguments."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    entity_types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="entityTypes")
    )
    identifiers: Optional[List[EntityContextIdByIdentifiers]] = field(
        default=None, metadata=config(field_name="identifiers")
    )
    properties: Optional[List[EntityContextPropertyQuery]] = field(
        default=None, metadata=config(field_name="properties")
    )
    time_filter: Optional[EntityContextTimeFilters] = field(
        default=None, metadata=config(field_name="timeFilter")
    )
    origin: Optional[EntityContextOrigin] = field(
        default=None, metadata=config(field_name="origin")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssetEnrichment:
    """EntityContextAssetEnrichment."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostId"))
    rn: Optional[str] = field(default=None, metadata=config(field_name="rn"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    sensor_tenant: Optional[str] = field(
        default=None, metadata=config(field_name="sensorTenant")
    )
    sensor_id: Optional[str] = field(
        default=None, metadata=config(field_name="sensorId")
    )
    ingest_time: Optional[str] = field(
        default=None, metadata=config(field_name="ingestTime")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deletedAt")
    )
    last_seen_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt")
    )
    bios_serial: Optional[str] = field(
        default=None, metadata=config(field_name="biosSerial")
    )
    first_disk_serial: Optional[str] = field(
        default=None, metadata=config(field_name="firstDiskSerial")
    )
    system_volume_serial: Optional[str] = field(
        default=None, metadata=config(field_name="systemVolumeSerial")
    )
    sensor_version: Optional[str] = field(
        default=None, metadata=config(field_name="sensorVersion")
    )
    endpoint_type: Optional[str] = field(
        default=None, metadata=config(field_name="endpointType")
    )
    endpoint_platform: Optional[str] = field(
        default=None, metadata=config(field_name="endpointPlatform")
    )
    architecture: Optional[str] = field(
        default=None, metadata=config(field_name="architecture")
    )
    os_family: Optional[str] = field(
        default=None, metadata=config(field_name="osFamily")
    )
    os_version: Optional[str] = field(
        default=None, metadata=config(field_name="osVersion")
    )
    os_version_normalized: Optional[str] = field(
        default=None, metadata=config(field_name="osVersionNormalized")
    )
    os_distributor: Optional[str] = field(
        default=None, metadata=config(field_name="osDistributor")
    )
    os_release: Optional[str] = field(
        default=None, metadata=config(field_name="osRelease")
    )
    system_type: Optional[str] = field(
        default=None, metadata=config(field_name="systemType")
    )
    os_codename: Optional[str] = field(
        default=None, metadata=config(field_name="osCodename")
    )
    kernel_release: Optional[str] = field(
        default=None, metadata=config(field_name="kernelRelease")
    )
    kernel_version: Optional[str] = field(
        default=None, metadata=config(field_name="kernelVersion")
    )
    connection_status: Optional[str] = field(
        default=None, metadata=config(field_name="connectionStatus")
    )
    isolation_status: Optional[str] = field(
        default=None, metadata=config(field_name="isolationStatus")
    )
    desired_isolation_status: Optional[str] = field(
        default=None, metadata=config(field_name="desiredIsolationStatus")
    )
    model: Optional[str] = field(default=None, metadata=config(field_name="model"))
    cloud_provider_name: Optional[str] = field(
        default=None, metadata=config(field_name="cloudProviderName")
    )
    cloud_instance_id: Optional[str] = field(
        default=None, metadata=config(field_name="cloudInstanceId")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    hostnames: Optional[List[EntityContextAssetHostnameV2]] = field(
        default=None, metadata=config(field_name="hostnames")
    )
    ethernet_addresses: Optional[List[EntityContextAssetEthernetAddressV2]] = field(
        default=None, metadata=config(field_name="ethernetAddresses")
    )
    ip_addresses: Optional[List[EntityContextAssetIpAddressV2]] = field(
        default=None, metadata=config(field_name="ipAddresses")
    )
    users: Optional[List[EntityContextAssetUserV2]] = field(
        default=None, metadata=config(field_name="users")
    )
    tags: Optional[List[EntityContextAssetTagV2]] = field(
        default=None, metadata=config(field_name="tags")
    )
    endpoint_group: Optional[EntityContextAssetEndpointGroupV2] = field(
        default=None, metadata=config(field_name="endpointGroup")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextWhoIs:
    """EntityContextWhoIs."""

    domain_name: Optional[str] = field(
        default=None, metadata=config(field_name="domainName")
    )
    registrar_name: Optional[str] = field(
        default=None, metadata=config(field_name="registrarName")
    )
    contact_email: Optional[str] = field(
        default=None, metadata=config(field_name="contactEmail")
    )
    whois_server: Optional[str] = field(
        default=None, metadata=config(field_name="whoisServer")
    )
    name_servers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="nameServers")
    )
    status: Optional[str] = field(default=None, metadata=config(field_name="status"))
    registrant: Optional[EntityContextWhoIsContact] = field(
        default=None, metadata=config(field_name="registrant")
    )
    administrative_contact: Optional[EntityContextWhoIsContact] = field(
        default=None, metadata=config(field_name="administrativeContact")
    )
    entry_time: Optional[EntityContextWhoIsTimeInfo] = field(
        default=None, metadata=config(field_name="entryTime")
    )
    registration_time: Optional[EntityContextWhoIsTimeInfo] = field(
        default=None, metadata=config(field_name="registrationTime")
    )
    standard_registration_time: Optional[EntityContextWhoIsTimeInfo] = field(
        default=None, metadata=config(field_name="standardRegistrationTime")
    )
    audit_time: Optional[EntityContextWhoIsTimeInfo] = field(
        default=None, metadata=config(field_name="auditTime")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextEdge:
    """EntityContextEdge."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    first_seen: Optional[str] = field(
        default=None, metadata=config(field_name="firstSeen")
    )
    last_seen: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeen")
    )
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    identities: Optional[List[str]] = field(
        default=None, metadata=config(field_name="identities")
    )
    identifiers: Optional[List[List[str]]] = field(
        default=None, metadata=config(field_name="identifiers")
    )
    alert_id: Optional[str] = field(default=None, metadata=config(field_name="alertId"))
    event_id: Optional[str] = field(default=None, metadata=config(field_name="eventId"))
    source_entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="sourceEntityID")
    )
    source_entity_type: Optional[str] = field(
        default=None, metadata=config(field_name="sourceEntityType")
    )
    target_entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="targetEntityID")
    )
    target_entity_type: Optional[str] = field(
        default=None, metadata=config(field_name="targetEntityType")
    )
    properties: Optional[List[EntityContextProperty]] = field(
        default=None, metadata=config(field_name="properties")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextGroupedEdge:
    """EntityContextGroupedEdge."""

    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    alert_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="alertIds")
    )
    event_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="eventIds")
    )
    investigation_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="investigationIds")
    )
    edge_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="edgeIds")
    )
    first_seen: Optional[str] = field(
        default=None, metadata=config(field_name="firstSeen")
    )
    last_seen: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeen")
    )
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    source_entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="sourceEntityID")
    )
    source_entity_type: Optional[str] = field(
        default=None, metadata=config(field_name="sourceEntityType")
    )
    target_entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="targetEntityID")
    )
    target_entity_type: Optional[str] = field(
        default=None, metadata=config(field_name="targetEntityType")
    )
    properties: Optional[List[EntityContextProperty]] = field(
        default=None, metadata=config(field_name="properties")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextEntityCollectionFilter:
    """EntityContextEntityCollectionFilter."""

    types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="types")
    )
    collect_properties: Optional[bool] = field(
        default=None, metadata=config(field_name="collectProperties")
    )
    limit_properties: Optional[List[str]] = field(
        default=None, metadata=config(field_name="limitProperties")
    )
    time_filter: Optional[EntityContextTimeFilters] = field(
        default=None, metadata=config(field_name="timeFilter")
    )
    properties: Optional[List[EntityContextPropertyQuery]] = field(
        default=None, metadata=config(field_name="properties")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextTraversalFilter:
    """EntityContextTraversalFilter."""

    depth: Optional[int] = field(default=None, metadata=config(field_name="depth"))
    entity_types: Optional[List[str]] = field(
        default=None, metadata=config(field_name="entityTypes")
    )
    traversal_strategy: Optional[Union[EntityContextTraversalStrategy, TaegisEnum]] = (
        field(
            default=None,
            metadata=config(
                encoder=encode_enum,
                decoder=lambda x: decode_enum(EntityContextTraversalStrategy, x),
                field_name="traversalStrategy",
            ),
        )
    )
    time_filter: Optional[EntityContextTimeFilters] = field(
        default=None, metadata=config(field_name="timeFilter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextEntityEnrichments:
    """EntityContextEntityEnrichments."""

    ip_geo: Optional[EntityContextIpGeoEnrichment] = field(
        default=None, metadata=config(field_name="ipGeo")
    )
    threat_context: Optional[EntityContextThreatContextEnrichment] = field(
        default=None, metadata=config(field_name="threatContext")
    )
    asset: Optional[EntityContextAssetEnrichment] = field(
        default=None, metadata=config(field_name="asset")
    )
    whois: Optional[EntityContextWhoIs] = field(
        default=None, metadata=config(field_name="whois")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextGroupedSubgraphFilters:
    """EntityContextGroupedSubgraphFilters."""

    group_props: Optional[List[str]] = field(
        default=None, metadata=config(field_name="groupProps")
    )
    traversal_filters: Optional[EntityContextTraversalFilter] = field(
        default=None, metadata=config(field_name="traversalFilters")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextEntity:
    """EntityContextEntity."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    first_seen: Optional[str] = field(
        default=None, metadata=config(field_name="firstSeen")
    )
    last_seen: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeen")
    )
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    display_name: Optional[str] = field(
        default=None, metadata=config(field_name="displayName")
    )
    identities: Optional[List[str]] = field(
        default=None, metadata=config(field_name="identities")
    )
    identifiers: Optional[List[List[str]]] = field(
        default=None, metadata=config(field_name="identifiers")
    )
    properties: Optional[List[EntityContextProperty]] = field(
        default=None, metadata=config(field_name="properties")
    )
    enrichments: Optional[EntityContextEntityEnrichments] = field(
        default=None, metadata=config(field_name="enrichments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContexts:
    """EntityContexts."""

    error: Optional[str] = field(default=None, metadata=config(field_name="error"))
    entities: Optional[List[EntityContextEntity]] = field(
        default=None, metadata=config(field_name="entities")
    )
    page_info: Optional[EntityContextPageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssociatedEntitiesFilters:
    """EntityContextAssociatedEntitiesFilters."""

    sort_by: Optional[str] = field(default=None, metadata=config(field_name="sortBy"))
    sort_order: Optional[Union[EntityContextSortOrder, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EntityContextSortOrder, x),
            field_name="sortOrder",
        ),
    )
    filter: Optional[EntityContextEntityCollectionFilter] = field(
        default=None, metadata=config(field_name="filter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextGroupedSubgraph:
    """EntityContextGroupedSubgraph."""

    entities: Optional[List[EntityContextEntity]] = field(
        default=None, metadata=config(field_name="entities")
    )
    grouped_edges: Optional[List[EntityContextGroupedEdge]] = field(
        default=None, metadata=config(field_name="groupedEdges")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextAssociatedEntitiesResponse:
    """EntityContextAssociatedEntitiesResponse."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    error: Optional[str] = field(default=None, metadata=config(field_name="error"))
    entities: Optional[List[EntityContextEntity]] = field(
        default=None, metadata=config(field_name="entities")
    )
    page_info: Optional[EntityContextPageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityContextGroupedSubgraphForResponse:
    """EntityContextGroupedSubgraphForResponse."""

    error: Optional[str] = field(default=None, metadata=config(field_name="error"))
    subgraph: Optional[EntityContextGroupedSubgraph] = field(
        default=None, metadata=config(field_name="subgraph")
    )
