"""Investigations2 Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.investigations2.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.investigations2 import Investigations2Service

log = logging.getLogger(__name__)


class TaegisSDKInvestigations2Query:
    """Taegis Investigations2 Query operations."""

    def __init__(self, service: Investigations2Service):
        self.service = service

    def case(self, arguments: CaseArguments) -> Case:
        """case gets a single case.."""
        endpoint = "case"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(Case),
        )
        if result.get(endpoint) is not None:
            return Case.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query case")

    def cases(self, arguments: CasesArguments) -> Cases:
        """cases returns a list of cases matching the provided arguments.."""
        endpoint = "cases"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(Cases),
        )
        if result.get(endpoint) is not None:
            return Cases.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query cases")

    def case_evidence(self, arguments: CaseEvidenceArguments) -> CaseEvidence:
        """caseEvidence returns the attached evidence for a case.."""
        endpoint = "caseEvidence"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseEvidence),
        )
        if result.get(endpoint) is not None:
            return CaseEvidence.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseEvidence")

    def case_rule(self, arguments: CaseRuleArguments) -> CaseRule:
        """caseRule gets an auto-case rule."""
        endpoint = "caseRule"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseRule),
        )
        if result.get(endpoint) is not None:
            return CaseRule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseRule")

    def case_rules(self, arguments: CaseRulesArguments) -> CaseRules:
        """caseRules returns a list of case rules matching the provided arguments.."""
        endpoint = "caseRules"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseRules),
        )
        if result.get(endpoint) is not None:
            return CaseRules.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseRules")

    def case_template(self, arguments: CaseTemplateArguments) -> CaseTemplate:
        """caseTemplate gets an auto-case template."""
        endpoint = "caseTemplate"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseTemplate),
        )
        if result.get(endpoint) is not None:
            return CaseTemplate.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseTemplate")

    def case_templates(self, arguments: CaseTemplatesArguments) -> CaseTemplates:
        """caseTemplates returns a list of case templates matching the provided arguments.."""
        endpoint = "caseTemplates"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseTemplates),
        )
        if result.get(endpoint) is not None:
            return CaseTemplates.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseTemplates")

    def export_case_resources(
        self, arguments: ExportCaseResourcesArguments
    ) -> CaseResourceExport:
        """exportCaseResources returns a YAML string representation for auto-case resources (rules & templates).
        The returned string can be saved into a file and imported back into the system using importCaseResources..
        """
        endpoint = "exportCaseResources"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseResourceExport),
        )
        if result.get(endpoint) is not None:
            return CaseResourceExport.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query exportCaseResources")

    def case_timeline(self, arguments: CaseTimelineArguments) -> CaseTimeline:
        """caseTimeline returns a case timeline detailing the order of alerts, events and other actions taken in relation to a case.."""
        endpoint = "caseTimeline"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseTimeline),
        )
        if result.get(endpoint) is not None:
            return CaseTimeline.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseTimeline")

    def case_comments(self, arguments: CaseCommentsArguments) -> CaseComments:
        """comments returns all the comments for a case."""
        endpoint = "caseComments"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseComments),
        )
        if result.get(endpoint) is not None:
            return CaseComments.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseComments")

    def case_types(self, arguments: CaseTypesArguments) -> CaseTypes:
        """caseTypes returns the available case types for a given user and the current tenant's service level."""
        endpoint = "caseTypes"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseTypes),
        )
        if result.get(endpoint) is not None:
            return CaseTypes.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseTypes")

    def case_secondary_statuses(
        self, arguments: CaseSecondaryStatusesArguments
    ) -> CaseSecondaryStatuses:
        """CaseSecondaryStatuses returns the available case statuses for a given user and the current tenant's service level."""
        endpoint = "CaseSecondaryStatuses"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseSecondaryStatuses),
        )
        if result.get(endpoint) is not None:
            return CaseSecondaryStatuses.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query CaseSecondaryStatuses")

    def case_primary_statuses(
        self, arguments: CasePrimaryStatusesArguments
    ) -> CasePrimaryStatuses:
        """casePrimaryStatuses returns the available case primary statuses for a given user and the current tenant's service level."""
        endpoint = "casePrimaryStatuses"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CasePrimaryStatuses),
        )
        if result.get(endpoint) is not None:
            return CasePrimaryStatuses.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query casePrimaryStatuses")

    def case_file(self, arguments: CaseFileArguments) -> CaseFile:
        """caseFile returns file details for a single file attached to a case based on the arguments provided.
        The result will also include a pre-signed download url.."""
        endpoint = "caseFile"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseFile),
        )
        if result.get(endpoint) is not None:
            return CaseFile.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseFile")

    def case_files(self, arguments: CaseFilesArguments) -> CaseFiles:
        """caseFiles returns file details for all files matching the arguments provided.
        The results will not include pre-signed download urls for each file metadata returned..
        """
        endpoint = "caseFiles"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CaseFiles),
        )
        if result.get(endpoint) is not None:
            return CaseFiles.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query caseFiles")

    def cases_aggregation(
        self, arguments: CasesAggregationArguments
    ) -> CasesAggregation:
        """casesAggregation allows aggregating data for cases.
        It cannot be used to fetch individual cases or lists of cases, only aggregate data.
        It should not be used by external clients and should only be called from the Taegis UI.
        Use of this endpoint is discouraged as it may be changed at any time without notice..
        """
        endpoint = "casesAggregation"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CasesAggregation),
        )
        if result.get(endpoint) is not None:
            return CasesAggregation.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query casesAggregation")

    def investigation_v2(self, arguments: InvestigationV2Arguments) -> InvestigationV2:
        """investigationV2 gets a single Investigation.."""
        endpoint = "investigationV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationV2")

    def investigations_v2(
        self, arguments: InvestigationsV2Arguments
    ) -> InvestigationsV2:
        """investigationsV2 returns a list of investigations matching the provided arguments.."""
        endpoint = "investigationsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationsV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationsV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationsV2")

    def investigation_rule(
        self, arguments: InvestigationRuleArguments
    ) -> InvestigationRule:
        """investigationRule gets an auto-investigation rule."""
        endpoint = "investigationRule"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationRule),
        )
        if result.get(endpoint) is not None:
            return InvestigationRule.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationRule")

    def investigation_rules(
        self, arguments: InvestigationRulesArguments
    ) -> InvestigationRules:
        """investigationRules returns a list of investigation rules matching the provided arguments.."""
        endpoint = "investigationRules"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationRules),
        )
        if result.get(endpoint) is not None:
            return InvestigationRules.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationRules")

    def investigation_template(
        self, arguments: InvestigationTemplateArguments
    ) -> InvestigationTemplate:
        """investigationTemplate gets an auto-investigation template."""
        endpoint = "investigationTemplate"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationTemplate),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplate.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationTemplate")

    def investigation_templates(
        self, arguments: InvestigationTemplatesArguments
    ) -> InvestigationTemplates:
        """investigationTemplates returns a list of investigation templates matching the provided arguments.."""
        endpoint = "investigationTemplates"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationTemplates),
        )
        if result.get(endpoint) is not None:
            return InvestigationTemplates.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationTemplates")

    def export_investigation_resources(
        self, arguments: ExportInvestigationResourcesArguments
    ) -> InvestigationResourceExport:
        """exportInvestigationResources returns a YAML string representation for auto-investigation resources (rules & templates).
        The returned string can be saved into a file and imported back into the system using importInvestigationResources..
        """
        endpoint = "exportInvestigationResources"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationResourceExport),
        )
        if result.get(endpoint) is not None:
            return InvestigationResourceExport.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query exportInvestigationResources")

    def investigation_v2_timeline(
        self, arguments: InvestigationV2TimelineArguments
    ) -> InvestigationV2Timeline:
        """investigationV2Timeline returns an investigation timeline detailing the order of alerts, events and other actions taken in relation to an investigation.."""
        endpoint = "investigationV2Timeline"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationV2Timeline),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2Timeline.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationV2Timeline")

    def comments_v2(self, arguments: CommentsV2Arguments) -> CommentsV2:
        """commentsV2 returns all the comments for an investigation."""
        endpoint = "commentsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(CommentsV2),
        )
        if result.get(endpoint) is not None:
            return CommentsV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query commentsV2")

    def investigation_v2_types(self) -> List[InvestigationV2Type]:
        """investigationV2Types returns the available investigation types for a given user and the current tenant's service level."""
        endpoint = "investigationV2Types"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(InvestigationV2Type),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2Type.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query investigationV2Types")

    def investigation_v2_statuses(
        self, arguments: InvestigationV2StatusesArguments
    ) -> List[InvestigationV2Status]:
        """investigationStatuses returns the available investigation statuses for a given user and the current tenant's service level."""
        endpoint = "investigationV2Statuses"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationV2Status),
        )
        if result.get(endpoint) is not None:
            return InvestigationV2Status.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query investigationV2Statuses")

    def investigation_file_v2(
        self, arguments: InvestigationFileV2Arguments
    ) -> InvestigationFileV2:
        """investigationFileV2 returns file details for a single file attached to an investigation based on the arguments provided.
        The result will also include a pre-signed download url.."""
        endpoint = "investigationFileV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationFileV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationFileV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationFileV2")

    def investigation_files_v2(
        self, arguments: InvestigationFilesV2Arguments
    ) -> InvestigationFilesV2:
        """investigationFilesV2 returns file details for all files matching the arguments provided.
        The results will not include pre-signed download urls for each file metadata returned..
        """
        endpoint = "investigationFilesV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(InvestigationFilesV2),
        )
        if result.get(endpoint) is not None:
            return InvestigationFilesV2.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query investigationFilesV2")
