"""ProcessTrees Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class OrderByDirectionInput(str, Enum):
    """OrderByDirectionInput."""

    ASC = "asc"
    DESC = "desc"


class OrderByFieldInput(str, Enum):
    """OrderByFieldInput."""

    PROCESS_CREATION_TIME = "processCreationTime"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ProgramHash:
    """ProgramHash."""

    md5: Optional[str] = field(default=None, metadata=config(field_name="md5"))
    sha1: Optional[str] = field(default=None, metadata=config(field_name="sha1"))
    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    sha512: Optional[str] = field(default=None, metadata=config(field_name="sha512"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ProcessEvent:
    """ProcessEvent."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    host_id: Optional[str] = field(default=None, metadata=config(field_name="hostID"))
    process_correlation_id: Optional[str] = field(
        default=None, metadata=config(field_name="processCorrelationID")
    )
    resource_id: Optional[str] = field(
        default=None, metadata=config(field_name="resourceID")
    )
    parent_process_correlation_id: Optional[str] = field(
        default=None, metadata=config(field_name="parentProcessCorrelationID")
    )
    process_id: Optional[str] = field(
        default=None, metadata=config(field_name="processID")
    )
    parent_process_id: Optional[str] = field(
        default=None, metadata=config(field_name="parentProcessID")
    )
    process_time_window: Optional[int] = field(
        default=None, metadata=config(field_name="processTimeWindow")
    )
    process_creation_time: Optional[int] = field(
        default=None, metadata=config(field_name="processCreationTime")
    )
    process_is_admin: Optional[bool] = field(
        default=None, metadata=config(field_name="processIsAdmin")
    )
    real_pid: Optional[str] = field(default=None, metadata=config(field_name="realPid"))
    commandline: Optional[str] = field(
        default=None, metadata=config(field_name="commandline")
    )
    image_path: Optional[str] = field(
        default=None, metadata=config(field_name="imagePath")
    )
    username: Optional[str] = field(
        default=None, metadata=config(field_name="username")
    )
    user_is_admin: Optional[bool] = field(
        default=None, metadata=config(field_name="userIsAdmin")
    )
    was_blocked: Optional[bool] = field(
        default=None, metadata=config(field_name="wasBlocked")
    )
    normalizer: Optional[str] = field(
        default=None, metadata=config(field_name="normalizer")
    )
    sensor_type: Optional[str] = field(
        default=None, metadata=config(field_name="sensorType")
    )
    event_time_usec: Optional[int] = field(
        default=None, metadata=config(field_name="eventTimeUsec")
    )
    children_count: Optional[int] = field(
        default=None, metadata=config(field_name="childrenCount")
    )
    alerts: Optional[List[str]] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "Use 'alertsV2' or `events-search` instead",
            },
            field_name="alerts",
        ),
    )
    program_hash: Optional[ProgramHash] = field(
        default=None, metadata=config(field_name="programHash")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Children:
    """Children."""

    children_count: Optional[int] = field(
        default=None, metadata=config(field_name="childrenCount")
    )
    next_token: Optional[str] = field(
        default=None, metadata=config(field_name="nextToken")
    )
    process_list: Optional[List[ProcessEvent]] = field(
        default=None, metadata=config(field_name="processList")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ProcessLineage:
    """ProcessLineage."""

    depth: Optional[int] = field(default=None, metadata=config(field_name="depth"))
    lineage: Optional[List[ProcessEvent]] = field(
        default=None, metadata=config(field_name="lineage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class OrderByInput:
    """OrderByInput."""

    field_: Optional[Union[OrderByFieldInput, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(OrderByFieldInput, x),
            field_name="field",
        ),
    )
    direction: Optional[Union[OrderByDirectionInput, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(OrderByDirectionInput, x),
            field_name="direction",
        ),
    )
