"""Subjects Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class SubjectType(str, Enum):
    """SubjectType."""

    CLIENT_SUBJECT = "CLIENT_SUBJECT"
    USER_SUBJECT = "USER_SUBJECT"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TDRUser:
    """TDRUser."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Client:
    """Client."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CentralUser:
    """CentralUser."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubjectSelector:
    """SubjectSelector."""

    with_types: Optional[List[Union[SubjectType, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(SubjectType, x),
            field_name="withTypes",
        ),
    )


SubjectIdentity = Union[
    TDRUser,
    Client,
    CentralUser,
]


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubjectRoleAssignment:
    """SubjectRoleAssignment."""

    role_id: Optional[str] = field(default=None, metadata=config(field_name="roleId"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    role_name: Optional[str] = field(
        default=None, metadata=config(field_name="roleName")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    deactivated: Optional[bool] = field(
        default=None, metadata=config(field_name="deactivated")
    )
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    is_scwx_role_assignment: Optional[bool] = field(
        default=None, metadata=config(field_name="isScwxRoleAssignment")
    )
    is_parent_role_assignment: Optional[bool] = field(
        default=None, metadata=config(field_name="isParentRoleAssignment")
    )
    created_by: Optional[SubjectIdentity] = field(
        default=None,
        metadata=config(
            decoder=lambda x: parse_union_result(SubjectIdentity, x),
            field_name="createdBy",
        ),
    )
    updated_by: Optional[SubjectIdentity] = field(
        default=None,
        metadata=config(
            decoder=lambda x: parse_union_result(SubjectIdentity, x),
            field_name="updatedBy",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubjectRoleAssignmentData:
    """SubjectRoleAssignmentData."""

    assigned_tenant_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assignedTenantIDs")
    )
    assigned_partner_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="assignedPartnerIDs")
    )
    can_read_all_tenants: Optional[bool] = field(
        default=None, metadata=config(field_name="canReadAllTenants")
    )
    has_support_access: Optional[bool] = field(
        default=None, metadata=config(field_name="hasSupportAccess")
    )
    has_scwx_role_assignment: Optional[bool] = field(
        default=None, metadata=config(field_name="hasScwxRoleAssignment")
    )
    role_assignments: Optional[List[SubjectRoleAssignment]] = field(
        default=None, metadata=config(field_name="roleAssignments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Subject:
    """Subject."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    display_name: Optional[str] = field(
        default=None, metadata=config(field_name="displayName")
    )
    role_assignment_data: Optional[SubjectRoleAssignmentData] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "Use permission-based authorization checks instead of role assignments",
            },
            field_name="roleAssignmentData",
        ),
    )
    identity: Optional[SubjectIdentity] = field(
        default=None,
        metadata=config(
            decoder=lambda x: parse_union_result(SubjectIdentity, x),
            field_name="identity",
        ),
    )
