"""Tenants4 Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.tenants4.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.tenants4 import Tenants4Service

log = logging.getLogger(__name__)


class TaegisSDKTenants4Query:
    """Taegis Tenants4 Query operations."""

    def __init__(self, service: Tenants4Service):
        self.service = service

    def tenants(self, tenants_query: TenantsQuery) -> TenantResults:
        """Allows to query tenants using various filters, if running on a public endpoint, this results will be filtered to show only tenants that the subject has access to."""
        endpoint = "tenants"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "tenantsQuery": prepare_input(tenants_query),
            },
            output=build_output_string(TenantResults),
        )
        if result.get(endpoint) is not None:
            return TenantResults.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tenants")

    def tenant(self, id_: str) -> TenantV4:
        """Retrieves a single tenant. Accepts a Taegis ID (numeric) or a Sophos ID (uuid). Tenant won't be returned if the subject does not have access to it (and requesting on an endpoint with authorization enabled)."""
        endpoint = "tenant"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(TenantV4),
        )
        if result.get(endpoint) is not None:
            return TenantV4.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tenant")

    def available_regions(self) -> List[TenantRegion]:
        """@deprecated — use availableEnvironments instead."""
        endpoint = "availableRegions"

        log.warning(
            f"GraphQL Query `{endpoint}` is deprecated: 'Use 'availableEnvironments' with TenantEnvironment instead'"
        )

        result = self.service.execute_query(endpoint=endpoint, variables={}, output="")
        if result.get(endpoint) is not None:
            return [TenantRegion(r) for r in result.get(endpoint)]
        raise GraphQLNoRowsInResultSetError("for query availableRegions")

    def available_environments(self) -> List[TenantEnvironment]:
        """Returns the environments where the tenant in XTC can be enabled at (excluding any environments currently enabled at). If a partner tenant ID is provided, this returns the environments where the partner can enable children at. If multiple tenants are provided in XTC, only the first is used. If none provided, an error is returned."""
        endpoint = "availableEnvironments"

        result = self.service.execute_query(endpoint=endpoint, variables={}, output="")
        if result.get(endpoint) is not None:
            return [TenantEnvironment(r) for r in result.get(endpoint)]
        raise GraphQLNoRowsInResultSetError("for query availableEnvironments")

    def tenant_licenses(
        self, tenant_licenses: TenantLicensesInput
    ) -> TenantLicenseResponse:
        """Retrieval of a tenant's currently active licenses.."""
        endpoint = "tenantLicenses"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "tenantLicenses": prepare_input(tenant_licenses),
            },
            output=build_output_string(TenantLicenseResponse),
        )
        if result.get(endpoint) is not None:
            return TenantLicenseResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query tenantLicenses")

    def product_catalog(
        self, product_catalog: ProductCatalogInput
    ) -> ProductCatalogResponse:
        """Retrieval of the product catalog available for licensing by tenants.."""
        endpoint = "productCatalog"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "productCatalog": prepare_input(product_catalog),
            },
            output=build_output_string(ProductCatalogResponse),
        )
        if result.get(endpoint) is not None:
            return ProductCatalogResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query productCatalog")
