"""TriggerAction Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.trigger_action.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.trigger_action import TriggerActionService


log = logging.getLogger(__name__)


class TaegisSDKTriggerActionQuery:
    """Taegis Trigger_action Query operations."""

    def __init__(self, service: TriggerActionService):
        self.service = service

    def playbook_action_category(self, id_: str) -> PlaybookActionCategory:
        """playbookActionCategory accepts an action id and returns the category the action falls into."""
        endpoint = "playbookActionCategory"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(PlaybookActionCategory),
        )
        if result.get(endpoint) is not None:
            return PlaybookActionCategory.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query playbookActionCategory")

    def playbook_action_categories(self) -> List[PlaybookActionCategory]:
        """playbookActionCategories return a list of all the possible categories an action can be tied to."""
        endpoint = "playbookActionCategories"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(PlaybookActionCategory),
        )
        if result.get(endpoint) is not None:
            return PlaybookActionCategory.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query playbookActionCategories")

    def playbook_action_context(self, id_: str) -> PlaybookActionContext:
        """playbookActionContext returns a single response action context."""
        endpoint = "playbookActionContext"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(PlaybookActionContext),
        )
        if result.get(endpoint) is not None:
            return PlaybookActionContext.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query playbookActionContext")

    def playbook_action_contexts(self) -> List[PlaybookActionContext]:
        """playbookActionContexts returns all registered action contexts that can be associated to response actions."""
        endpoint = "playbookActionContexts"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={},
            output=build_output_string(PlaybookActionContext),
        )
        if result.get(endpoint) is not None:
            return PlaybookActionContext.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query playbookActionContexts")

    def playbook_actions(
        self,
        playbook_action_context: str,
        inputs: Any,
        playbook_action_category: Optional[str] = None,
    ) -> List[PlaybookAction]:
        """playbookActions returns all actions that can be taken for a given context, category and input."""
        endpoint = "playbookActions"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "playbookActionContext": prepare_input(playbook_action_context),
                "playbookActionCategory": prepare_input(playbook_action_category),
                "inputs": prepare_input(inputs),
            },
            output=build_output_string(PlaybookAction),
        )
        if result.get(endpoint) is not None:
            return PlaybookAction.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query playbookActions")

    def playbook_actions_configured(
        self, arguments: Optional[PlaybookActionsConfiguredArguments] = None
    ) -> List[PlaybookAction]:
        """playbookActionsConfigured returns all known trigger actions

        Scoped by the caller's tenant id."""
        endpoint = "playbookActionsConfigured"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(PlaybookAction),
        )
        if result.get(endpoint) is not None:
            return PlaybookAction.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query playbookActionsConfigured")

    def playbook_actions_v2(
        self, arguments: PlaybookActionsV2Arguments
    ) -> PlaybookActions:
        """playbookActionsV2 returns all known trigger actions

        Scoped by the caller's tenant id."""
        endpoint = "playbookActionsV2"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "arguments": prepare_input(arguments),
            },
            output=build_output_string(PlaybookActions),
        )
        if result.get(endpoint) is not None:
            return PlaybookActions.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query playbookActionsV2")

    def evaluate_expr(self, input_: ExprInput) -> ExprResult:
        """Test an expression against a context."""
        endpoint = "evaluateExpr"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ExprResult),
        )
        if result.get(endpoint) is not None:
            return ExprResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query evaluateExpr")
