"""XdrCentralConnector Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.xdr_central_connector.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.xdr_central_connector import (
        XdrCentralConnectorService,
    )

log = logging.getLogger(__name__)


class TaegisSDKXdrCentralConnectorMutation:
    """Taegis Xdr_central_connector Mutation operations."""

    def __init__(self, service: XdrCentralConnectorService):
        self.service = service

    def cixa_isolate_endpoint(
        self, input_: IsolateEndpointInput
    ) -> EndpointIsolationPayload:
        """Sends isolate command,."""
        endpoint = "cixaIsolateEndpoint"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndpointIsolationPayload),
        )
        if result.get(endpoint) is not None:
            return EndpointIsolationPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation cixaIsolateEndpoint")

    def cixa_isolate_endpoints(
        self, input_: IsolateEndpointsInput
    ) -> EndpointsIsolationPayload:
        """Set the desired isolation state for multiple endpoints.."""
        endpoint = "cixaIsolateEndpoints"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndpointsIsolationPayload),
        )
        if result.get(endpoint) is not None:
            return EndpointsIsolationPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation cixaIsolateEndpoints")

    def cixa_endpoint_forensic_logs(
        self, input_: ForensicLogsInput
    ) -> ForensicLogsPayload:
        """Sends a request to the endpoint to collect forensic log.."""
        endpoint = "cixaEndpointForensicLogs"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(ForensicLogsPayload),
        )
        if result.get(endpoint) is not None:
            return ForensicLogsPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation cixaEndpointForensicLogs")

    def launch_live_terminal_server(
        self, input_: LiveResponseInput
    ) -> LiveResponsePayload:
        """start live terminal session for a server.."""
        endpoint = "launchLiveTerminalServer"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(LiveResponsePayload),
        )
        if result.get(endpoint) is not None:
            return LiveResponsePayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation launchLiveTerminalServer")

    def launch_live_terminal_endpoint(
        self, input_: LiveResponseInput
    ) -> LiveResponsePayload:
        """start live terminal session for an endpoint.."""
        endpoint = "launchLiveTerminalEndpoint"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(LiveResponsePayload),
        )
        if result.get(endpoint) is not None:
            return LiveResponsePayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation launchLiveTerminalEndpoint")

    def end_live_terminal_session_server(
        self, input_: EndLiveResponseInput
    ) -> EndLiveResponseSessionPayload:
        """end the live response with the given session id. Response is "true" if the session was successfully ended.."""
        endpoint = "endLiveTerminalSessionServer"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndLiveResponseSessionPayload),
        )
        if result.get(endpoint) is not None:
            return EndLiveResponseSessionPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation endLiveTerminalSessionServer")

    def end_live_terminal_session_endpoint(
        self, input_: EndLiveResponseInput
    ) -> EndLiveResponseSessionPayload:
        """end the live response with the given session id. Response is "true" if the session was successfully ended.."""
        endpoint = "endLiveTerminalSessionEndpoint"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(EndLiveResponseSessionPayload),
        )
        if result.get(endpoint) is not None:
            return EndLiveResponseSessionPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation endLiveTerminalSessionEndpoint"
        )
