"""XdrCentralConnector Query."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.xdr_central_connector.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.xdr_central_connector import (
        XdrCentralConnectorService,
    )

log = logging.getLogger(__name__)


class TaegisSDKXdrCentralConnectorQuery:
    """Taegis Xdr_central_connector Query operations."""

    def __init__(self, service: XdrCentralConnectorService):
        self.service = service

    def cixa_endpoint_details(self, id_: str) -> EndpointDetails:
        """Get an endpoint based on ID.."""
        endpoint = "cixaEndpointDetails"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(EndpointDetails),
        )
        if result.get(endpoint) is not None:
            return EndpointDetails.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query cixaEndpointDetails")

    def cixa_endpoint_downloads(
        self, args: Optional[PackageDownloadInput] = None
    ) -> EndpointInstallers:
        """Get all the endpoint installer links for a tenant.."""
        endpoint = "cixaEndpointDownloads"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "args": prepare_input(args),
            },
            output=build_output_string(EndpointInstallers),
        )
        if result.get(endpoint) is not None:
            return EndpointInstallers.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query cixaEndpointDownloads")

    def cixa_endpoint_forensic_logs_status(
        self, endpoint_id: str, forensic_log_request_id: str
    ) -> ForensicLogsPayload:
        """Gets the status of the forensic log collection.."""
        endpoint = "cixaEndpointForensicLogsStatus"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "endpointID": prepare_input(endpoint_id),
                "forensicLogRequestId": prepare_input(forensic_log_request_id),
            },
            output=build_output_string(ForensicLogsPayload),
        )
        if result.get(endpoint) is not None:
            return ForensicLogsPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query cixaEndpointForensicLogsStatus")

    def launch_live_terminal_check(self, endpoint_id: str) -> LiveTerminalCheckPayload:
        """Determine if endpoint is eligible for live terminal. Authz check is performed in the resolver."""
        endpoint = "launchLiveTerminalCheck"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "endpointID": prepare_input(endpoint_id),
            },
            output=build_output_string(LiveTerminalCheckPayload),
        )
        if result.get(endpoint) is not None:
            return LiveTerminalCheckPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query launchLiveTerminalCheck")
