"""XdrCentralConnector Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum, parse_union_result


class SensorMode(str, Enum):
    """SensorMode."""

    XDR_SENSOR = "XDR_SENSOR"
    ENDPOINT = "ENDPOINT"
    XDR = "XDR"


class CixaEndpointType(str, Enum):
    """CixaEndpointType."""

    COMPUTER = "COMPUTER"
    SERVER = "SERVER"
    SECURITY_VM = "SECURITY_VM"


class HealthStatus(str, Enum):
    """HealthStatus."""

    UNKNOWN_HEALTH = "UNKNOWN_HEALTH"
    GOOD = "GOOD"
    NEEDS_ATTENTION = "NEEDS_ATTENTION"
    CRITICAL = "CRITICAL"


class ServiceStatus(str, Enum):
    """ServiceStatus."""

    RUNNING = "RUNNING"
    STOPPED = "STOPPED"
    MISSING = "MISSING"


class ProductCode(str, Enum):
    """ProductCode."""

    CORE_AGENT = "coreAgent"
    INTERCEPT_X = "interceptX"
    XDR = "xdr"
    ENDPOINT_PROTECTION = "endpointProtection"
    DEVICE_ENCRYPTION = "deviceEncryption"
    MTR = "mtr"
    ZTNA = "ztna"


class InstallationStatus(str, Enum):
    """InstallationStatus."""

    INSTALLED = "INSTALLED"
    NOT_INSTALLED = "NOT_INSTALLED"


class EndpointPlatform(str, Enum):
    """EndpointPlatform."""

    WINDOWS = "WINDOWS"
    LINUX = "LINUX"
    MAC = "MAC"


class VolumeEncryptionStatus(str, Enum):
    """VolumeEncryptionStatus."""

    NOT_ENCRYPTED = "NOT_ENCRYPTED"
    ENCRYPTED = "ENCRYPTED"
    ENCRYPTING = "ENCRYPTING"
    NOT_SUPPORTED = "NOT_SUPPORTED"
    SUSPENDED = "SUSPENDED"
    UNKNOWN = "UNKNOWN"


class LockdownStatus(str, Enum):
    """LockdownStatus."""

    CREATING_WHITE_LIST = "CREATING_WHITE_LIST"
    INSTALLING = "INSTALLING"
    LOCKED = "LOCKED"
    LOCKING = "LOCKING"
    NOT_INSTALLED = "NOT_INSTALLED"
    REGISTERING = "REGISTERING"
    STARTING = "STARTING"
    STOPPING = "STOPPING"
    UNAVAILABLE = "UNAVAILABLE"
    UNINSTALLED = "UNINSTALLED"
    UNLOCKED = "UNLOCKED"


class CloudProvider(str, Enum):
    """CloudProvider."""

    AWS = "AWS"
    AZURE = "AZURE"


class IsolationStatus(str, Enum):
    """IsolationStatus."""

    ISOLATED = "ISOLATED"
    NOT_ISOLATED = "NOT_ISOLATED"


class IsolatedPrincipalType(str, Enum):
    """IsolatedPrincipalType."""

    USER = "USER"
    SERVICE = "SERVICE"
    SYSTEM = "SYSTEM"


class AccountType(str, Enum):
    """AccountType."""

    PARTNER = "PARTNER"
    TENANT = "TENANT"
    ORGANIZATION = "ORGANIZATION"


class ForensicLogMode(str, Enum):
    """ForensicLogMode."""

    FAST = "FAST"
    FULL = "FULL"
    STANDARD = "STANDARD"
    NONE = "NONE"


class ForensicLogStatus(str, Enum):
    """ForensicLogStatus."""

    PENDING = "PENDING"
    FINISHED = "FINISHED"
    EXPIRED = "EXPIRED"
    FAILED = "FAILED"


class LiveTerminalDisabledReason(str, Enum):
    """LiveTerminalDisabledReason."""

    NOT_ENABLED_IN_SETTINGS = "NOT_ENABLED_IN_SETTINGS"
    DEVICE_NOT_ONLINE = "DEVICE_NOT_ONLINE"
    DEVICE_EXCLUDED = "DEVICE_EXCLUDED"
    XDR_UNASSIGNED = "XDR_UNASSIGNED"
    NOT_ENABLED_IN_POLICY = "NOT_ENABLED_IN_POLICY"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CixaEndpointGroup:
    """CixaEndpointGroup."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssociatedPerson:
    """AssociatedPerson."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    via_login: Optional[str] = field(
        default=None, metadata=config(field_name="viaLogin")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ForensicLogFile:
    """ForensicLogFile."""

    file_name: Optional[str] = field(
        default=None, metadata=config(field_name="fileName")
    )
    sha256: Optional[str] = field(default=None, metadata=config(field_name="sha256"))
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LiveResponsePayload:
    """LiveResponsePayload."""

    session_url: Optional[str] = field(
        default=None, metadata=config(field_name="sessionUrl")
    )
    cert_fingerprint: Optional[str] = field(
        default=None, metadata=config(field_name="certFingerprint")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndLiveResponseSessionPayload:
    """EndLiveResponseSessionPayload."""

    success: Optional[bool] = field(default=None, metadata=config(field_name="success"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IsolateEndpointsInput:
    """IsolateEndpointsInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IsolateEndpointInput:
    """IsolateEndpointInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LiveResponseInput:
    """LiveResponseInput."""

    endpoint_id: Optional[str] = field(
        default=None, metadata=config(field_name="endpointID")
    )
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    session_id: Optional[str] = field(
        default=None, metadata=config(field_name="sessionId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndLiveResponseInput:
    """EndLiveResponseInput."""

    endpoint_id: Optional[str] = field(
        default=None, metadata=config(field_name="endpointID")
    )
    session_id: Optional[str] = field(
        default=None, metadata=config(field_name="sessionId")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointHealthThreats:
    """EndpointHealthThreats."""

    status: Optional[Union[HealthStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(HealthStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ServiceDetail:
    """ServiceDetail."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    status: Optional[Union[ServiceStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ServiceStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class OsInfo:
    """OsInfo."""

    is_server: Optional[bool] = field(
        default=None, metadata=config(field_name="isServer")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    major_version: Optional[int] = field(
        default=None, metadata=config(field_name="majorVersion")
    )
    minor_version: Optional[int] = field(
        default=None, metadata=config(field_name="minorVersion")
    )
    build: Optional[int] = field(default=None, metadata=config(field_name="build"))
    platform: Optional[Union[EndpointPlatform, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointPlatform, x),
            field_name="platform",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointVolume:
    """EndpointVolume."""

    volume_id: Optional[str] = field(
        default=None, metadata=config(field_name="volumeID")
    )
    status: Optional[Union[VolumeEncryptionStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(VolumeEncryptionStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointEncryption:
    """EndpointEncryption."""

    volumes: Optional[List[EndpointVolume]] = field(
        default=None, metadata=config(field_name="volumes")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Lockdown:
    """Lockdown."""

    status: Optional[Union[LockdownStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(LockdownStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Cloud:
    """Cloud."""

    instance_id: Optional[str] = field(
        default=None, metadata=config(field_name="instanceId")
    )
    provider: Optional[Union[CloudProvider, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(CloudProvider, x),
            field_name="provider",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointIsolation:
    """EndpointIsolation."""

    admin_isolated: Optional[bool] = field(
        default=None, metadata=config(field_name="adminIsolated")
    )
    self_isolated: Optional[bool] = field(
        default=None, metadata=config(field_name="selfIsolated")
    )
    status: Optional[Union[IsolationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(IsolationStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LiveTerminalCheckPayload:
    """LiveTerminalCheckPayload."""

    should_render: Optional[bool] = field(
        default=None, metadata=config(field_name="shouldRender")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    disabled_reason: Optional[Union[LiveTerminalDisabledReason, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(LiveTerminalDisabledReason, x),
            field_name="disabledReason",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ForensicLogsInput:
    """ForensicLogsInput."""

    endpoint_id: Optional[str] = field(
        default=None, metadata=config(field_name="endpointID")
    )
    expires: Optional[str] = field(default=None, metadata=config(field_name="expires"))
    password: Optional[str] = field(
        default=None, metadata=config(field_name="password")
    )
    paths: Optional[List[str]] = field(
        default=None, metadata=config(field_name="paths")
    )
    mode: Optional[Union[ForensicLogMode, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ForensicLogMode, x),
            field_name="mode",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointServices:
    """EndpointServices."""

    status: Optional[Union[HealthStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(HealthStatus, x),
            field_name="status",
        ),
    )
    service_details: Optional[List[ServiceDetail]] = field(
        default=None, metadata=config(field_name="serviceDetails")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AssignedProduct:
    """AssignedProduct."""

    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    code: Optional[Union[ProductCode, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ProductCode, x),
            field_name="code",
        ),
    )
    status: Optional[Union[InstallationStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(InstallationStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IsolateUserDetails:
    """IsolateUserDetails."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    account_id: Optional[str] = field(
        default=None, metadata=config(field_name="accountID")
    )
    type: Optional[Union[IsolatedPrincipalType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(IsolatedPrincipalType, x),
            field_name="type",
        ),
    )
    account_type: Optional[Union[AccountType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AccountType, x),
            field_name="accountType",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointIsolationPayload:
    """EndpointIsolationPayload."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    last_enabled_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastEnabledAt")
    )
    last_disabled_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastDisabledAt")
    )
    comment: Optional[str] = field(default=None, metadata=config(field_name="comment"))
    last_enabled_by: Optional[IsolateUserDetails] = field(
        default=None, metadata=config(field_name="lastEnabledBy")
    )
    last_disabled_by: Optional[IsolateUserDetails] = field(
        default=None, metadata=config(field_name="lastDisabledBy")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ForensicLogsPayload:
    """ForensicLogsPayload."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    received_at: Optional[str] = field(
        default=None, metadata=config(field_name="receivedAt")
    )
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    error_message: Optional[str] = field(
        default=None, metadata=config(field_name="errorMessage")
    )
    status: Optional[Union[ForensicLogStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ForensicLogStatus, x),
            field_name="status",
        ),
    )
    forensic_log_file: Optional[ForensicLogFile] = field(
        default=None, metadata=config(field_name="forensicLogFile")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageDownloadInput:
    """PackageDownloadInput."""

    requested_products: Optional[List[Union[ProductCode, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ProductCode, x),
            field_name="requestedProducts",
        ),
    )
    platforms: Optional[List[Union[EndpointPlatform, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointPlatform, x),
            field_name="platforms",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointHealth:
    """EndpointHealth."""

    overall: Optional[Union[HealthStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(HealthStatus, x),
            field_name="overall",
        ),
    )
    threats: Optional[EndpointHealthThreats] = field(
        default=None, metadata=config(field_name="threats")
    )
    services: Optional[EndpointServices] = field(
        default=None, metadata=config(field_name="services")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointInstaller:
    """EndpointInstaller."""

    product_name: Optional[str] = field(
        default=None, metadata=config(field_name="productName")
    )
    download_url: Optional[str] = field(
        default=None, metadata=config(field_name="downloadUrl")
    )
    platform: Optional[Union[EndpointPlatform, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EndpointPlatform, x),
            field_name="platform",
        ),
    )
    type: Optional[Union[CixaEndpointType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(CixaEndpointType, x),
            field_name="type",
        ),
    )
    supported_products: Optional[List[Union[ProductCode, TaegisEnum]]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(ProductCode, x),
            field_name="supportedProducts",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointDetails:
    """EndpointDetails."""

    sensor_tenant: Optional[str] = field(
        default=None, metadata=config(field_name="sensorTenant")
    )
    hostname: Optional[str] = field(
        default=None, metadata=config(field_name="hostname")
    )
    ipv4_addresses: Optional[List[str]] = field(
        default=None, metadata=config(field_name="ipv4Addresses")
    )
    ipv6_addresses: Optional[List[str]] = field(
        default=None, metadata=config(field_name="ipv6Addresses")
    )
    mac_addresses: Optional[List[str]] = field(
        default=None, metadata=config(field_name="macAddresses")
    )
    tamper_protection_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="tamperProtectionEnabled")
    )
    last_seen_at: Optional[str] = field(
        default=None, metadata=config(field_name="lastSeenAt")
    )
    online: Optional[bool] = field(default=None, metadata=config(field_name="online"))
    type: Optional[Union[CixaEndpointType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(CixaEndpointType, x),
            field_name="type",
        ),
    )
    health: Optional[EndpointHealth] = field(
        default=None, metadata=config(field_name="health")
    )
    os: Optional[OsInfo] = field(default=None, metadata=config(field_name="os"))
    group: Optional[CixaEndpointGroup] = field(
        default=None, metadata=config(field_name="group")
    )
    associated_person: Optional[AssociatedPerson] = field(
        default=None, metadata=config(field_name="associatedPerson")
    )
    assigned_products: Optional[List[AssignedProduct]] = field(
        default=None, metadata=config(field_name="assignedProducts")
    )
    encryption: Optional[EndpointEncryption] = field(
        default=None, metadata=config(field_name="encryption")
    )
    lockdown: Optional[Lockdown] = field(
        default=None, metadata=config(field_name="lockdown")
    )
    cloud: Optional[Cloud] = field(default=None, metadata=config(field_name="cloud"))
    isolation: Optional[EndpointIsolation] = field(
        default=None, metadata=config(field_name="isolation")
    )
    sensor_mode: Optional[Union[SensorMode, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(SensorMode, x),
            field_name="sensorMode",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IsolatePayloadItem:
    """IsolatePayloadItem."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    payload: Optional[EndpointIsolationPayload] = field(
        default=None, metadata=config(field_name="payload")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointsIsolationPayload:
    """EndpointsIsolationPayload."""

    items: Optional[List[IsolatePayloadItem]] = field(
        default=None, metadata=config(field_name="items")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointInstallers:
    """EndpointInstallers."""

    sensor_tenant: Optional[str] = field(
        default=None, metadata=config(field_name="sensorTenant")
    )
    licensed_products: Optional[List[str]] = field(
        default=None, metadata=config(field_name="licensedProducts")
    )
    installers: Optional[List[EndpointInstaller]] = field(
        default=None, metadata=config(field_name="installers")
    )
