# Feature Specification: {{FEATURE_NAME}}

**Spec**: `{{SPEC_NUMBER}}-{{FEATURE_SLUG}}`
**Created**: {{DATE}}
**Status**: Draft
**Branch**: {{BRANCH}}

## Description

{{DESCRIPTION}}

---

## User Scenarios

### Primary User Story
[Describe the main user journey - what the user needs to accomplish and why]

### Acceptance Scenarios
1. **Given** [initial state], **When** [user action], **Then** [expected outcome]
2. **Given** [initial state], **When** [user action], **Then** [expected outcome]
3. **Given** [initial state], **When** [user action], **Then** [expected outcome]

### Edge Cases
- What happens when [boundary condition]?
- How does system handle [error scenario]?
- What if [unusual input or state]?

---

## Requirements

### Functional Requirements
- **FR-001**: System MUST [specific capability]
- **FR-002**: System MUST [specific capability]
- **FR-003**: Users MUST be able to [user action]
- **FR-004**: System MUST [data requirement]
- **FR-005**: System MUST [behavior or constraint]

### Non-Functional Requirements (if applicable)
- **NFR-001**: Performance: [specific target - e.g., <200ms response time]
- **NFR-002**: Security: [specific requirement]
- **NFR-003**: Scalability: [specific target]

### Key Entities (if applicable)
- **[Entity 1]**: [What it represents, key attributes]
- **[Entity 2]**: [What it represents, relationships to other entities]

---

## Success Criteria

- [ ] [Measurable outcome 1]
- [ ] [Measurable outcome 2]
- [ ] [Measurable outcome 3]

## Out of Scope

- [What we're explicitly NOT building in this spec]

---

## Next Steps

1. Review and complete requirements above
2. Create technical plan: `plan.md`
3. Create task breakdown: `tasks.md`
4. Optional: `/iterate:tasks {{SPEC_NUMBER}}-{{FEATURE_SLUG}}` for multi-agent work
5. Start work: `/supervisor:start {{SPEC_NUMBER}}-{{FEATURE_SLUG}}`
