# Component Specification Template
# Purpose: Define component API, props, state, events, and integration requirements
# Variables: {{COMPONENT_NAME}}, {{COMPONENT_TYPE}}, {{STATUS}}, {{CURRENT_DATE}}, {{COMPONENT_PURPOSE}}, {{USER_TYPE}}, {{ACTION}}, {{BENEFIT}}, {{USE_CASE_1}}
# Generated by: frontend-developer agent
# Template location: multiagent_core/templates/.multiagent/frontend/templates/COMPONENT_SPEC.md

# Component Specification

## Overview

**Component Name**: {{COMPONENT_NAME}}
**Type**: {{COMPONENT_TYPE}} (Page/Layout/UI/Form/Data Display)
**Status**: {{STATUS}} (Draft/In Development/Complete)
**Last Updated**: {{CURRENT_DATE}}

## Purpose

{{COMPONENT_PURPOSE}}

## User Stories

### Primary Use Case
As a {{USER_TYPE}}, I want to {{ACTION}}, so that {{BENEFIT}}.

### Additional Use Cases
- {{USE_CASE_1}}
- {{USE_CASE_2}}
- {{USE_CASE_3}}

## Design

### Visual Reference
- Figma: {{FIGMA_LINK}}
- Screenshot: {{SCREENSHOT_PATH}}

### Layout Structure

```
{{COMPONENT_NAME}}
├── {{CHILD_COMPONENT_1}}
├── {{CHILD_COMPONENT_2}}
└── {{CHILD_COMPONENT_3}}
```

### Component Hierarchy

```jsx
<{{COMPONENT_NAME}}>
  <{{CHILD_1}}>
    {{CONTENT_1}}
  </{{CHILD_1}}>
  <{{CHILD_2}}>
    {{CONTENT_2}}
  </{{CHILD_2}}>
</{{COMPONENT_NAME}}>
```

## Props / Interface

### TypeScript Interface

```typescript
interface {{COMPONENT_NAME}}Props {
  // Required Props
  {{PROP_1}}: {{TYPE_1}};
  {{PROP_2}}: {{TYPE_2}};

  // Optional Props
  {{PROP_3}}?: {{TYPE_3}};
  {{PROP_4}}?: {{TYPE_4}};

  // Event Handlers
  {{HANDLER_1}}?: ({{PARAMS}}) => void;
  {{HANDLER_2}}?: ({{PARAMS}}) => void;

  // Children
  children?: React.ReactNode;

  // Style Overrides
  className?: string;
  style?: React.CSSProperties;
}
```

### Prop Descriptions

| Prop | Type | Required | Default | Description |
|------|------|----------|---------|-------------|
| {{PROP_1}} | {{TYPE_1}} | Yes | - | {{DESCRIPTION_1}} |
| {{PROP_2}} | {{TYPE_2}} | Yes | - | {{DESCRIPTION_2}} |
| {{PROP_3}} | {{TYPE_3}} | No | {{DEFAULT_3}} | {{DESCRIPTION_3}} |
| {{PROP_4}} | {{TYPE_4}} | No | {{DEFAULT_4}} | {{DESCRIPTION_4}} |

## State Management

### Local State

```typescript
const [{{STATE_1}}, set{{STATE_1}}] = useState<{{TYPE}}>({{INITIAL_VALUE}});
const [{{STATE_2}}, set{{STATE_2}}] = useState<{{TYPE}}>({{INITIAL_VALUE}});
```

### Global State

**Store**: {{STORE_NAME}} (Redux/Zustand/Context)

```typescript
// State slice
interface {{SLICE_NAME}}State {
  {{STATE_FIELD_1}}: {{TYPE_1}};
  {{STATE_FIELD_2}}: {{TYPE_2}};
}

// Selectors
const {{SELECTOR_1}} = (state) => state.{{SLICE}}.{{FIELD}};
const {{SELECTOR_2}} = (state) => state.{{SLICE}}.{{FIELD}};

// Actions
dispatch({{ACTION_1}}({{PAYLOAD}}));
dispatch({{ACTION_2}}({{PAYLOAD}}));
```

### Derived State

```typescript
const {{DERIVED_STATE}} = useMemo(() => {
  return {{COMPUTATION}};
}, [{{DEPENDENCIES}}]);
```

## Data Flow

### Input Data Sources

1. **Props**: {{PROPS_DESCRIPTION}}
2. **API Calls**: {{API_ENDPOINTS}}
3. **Global State**: {{STATE_SOURCES}}
4. **URL Parameters**: {{URL_PARAMS}}
5. **Local Storage**: {{LOCAL_STORAGE_KEYS}}

### Output Events

1. **{{EVENT_1}}**: Fired when {{TRIGGER_CONDITION}}
   - Payload: `{{PAYLOAD_TYPE}}`
   - Handler: `{{HANDLER_NAME}}`

2. **{{EVENT_2}}**: Fired when {{TRIGGER_CONDITION}}
   - Payload: `{{PAYLOAD_TYPE}}`
   - Handler: `{{HANDLER_NAME}}`

## API Integration

### Endpoints Used

| Endpoint | Method | Purpose | Response Type |
|----------|--------|---------|---------------|
| {{ENDPOINT_1}} | {{METHOD}} | {{PURPOSE}} | {{RESPONSE_TYPE}} |
| {{ENDPOINT_2}} | {{METHOD}} | {{PURPOSE}} | {{RESPONSE_TYPE}} |

### Data Fetching

```typescript
// React Query / SWR
const { data, isLoading, error } = {{HOOK_NAME}}({{PARAMS}});

// Fetch on mount
useEffect(() => {
  {{FETCH_FUNCTION}}({{PARAMS}});
}, [{{DEPENDENCIES}}]);
```

### Error Handling

```typescript
try {
  const result = await {{API_CALL}}({{PARAMS}});
  // Success handling
} catch (error) {
  // Error handling
  {{ERROR_HANDLER}}(error);
}
```

## Behavior

### User Interactions

1. **{{INTERACTION_1}}**:
   - Trigger: {{TRIGGER}}
   - Action: {{ACTION}}
   - Result: {{RESULT}}

2. **{{INTERACTION_2}}**:
   - Trigger: {{TRIGGER}}
   - Action: {{ACTION}}
   - Result: {{RESULT}}

### Loading States

```typescript
if (isLoading) {
  return <{{LOADING_COMPONENT}} />;
}

if (error) {
  return <{{ERROR_COMPONENT}} error={error} />;
}

return <{{MAIN_COMPONENT}} data={data} />;
```

### Form Validation (if applicable)

```typescript
const validationSchema = {{SCHEMA_LIBRARY}}.object({
  {{FIELD_1}}: {{VALIDATOR_1}},
  {{FIELD_2}}: {{VALIDATOR_2}},
});

// Validation errors
interface ValidationErrors {
  {{FIELD_1}}?: string;
  {{FIELD_2}}?: string;
}
```

## Styling

### CSS Modules / Styled Components

```css
/* {{COMPONENT_NAME}}.module.css */
.{{CLASS_1}} {
  /* Styles */
}

.{{CLASS_2}} {
  /* Styles */
}
```

```typescript
// Styled Components
const {{STYLED_COMPONENT}} = styled.{{ELEMENT}}`
  {{STYLES}}
`;
```

### Responsive Design

| Breakpoint | Behavior |
|------------|----------|
| Mobile (<768px) | {{MOBILE_BEHAVIOR}} |
| Tablet (768px-1024px) | {{TABLET_BEHAVIOR}} |
| Desktop (>1024px) | {{DESKTOP_BEHAVIOR}} |

### Theme Variables

```typescript
// Uses design system tokens
const styles = {
  color: 'var(--color-primary)',
  spacing: 'var(--spacing-md)',
  fontSize: 'var(--font-size-body)',
};
```

## Accessibility

### ARIA Attributes

```jsx
<{{COMPONENT_NAME}}
  role="{{ROLE}}"
  aria-label="{{LABEL}}"
  aria-describedby="{{DESCRIPTION_ID}}"
  aria-expanded={{{STATE}}}
/>
```

### Keyboard Navigation

| Key | Action |
|-----|--------|
| Tab | {{TAB_ACTION}} |
| Enter | {{ENTER_ACTION}} |
| Escape | {{ESCAPE_ACTION}} |
| Arrow Keys | {{ARROW_ACTION}} |

### Screen Reader Support

- All images have alt text
- Form inputs have associated labels
- Error messages announced
- Loading states announced

## Performance

### Optimization Strategies

1. **Memoization**: {{MEMO_USAGE}}
2. **Code Splitting**: {{LAZY_LOADING}}
3. **Virtualization**: {{VIRTUAL_SCROLLING}}
4. **Debouncing**: {{DEBOUNCE_USAGE}}

```typescript
// React.memo for expensive components
export const {{COMPONENT_NAME}} = React.memo({{COMPONENT}}, (prev, next) => {
  return {{COMPARISON_LOGIC}};
});

// useMemo for expensive computations
const {{COMPUTED_VALUE}} = useMemo(() => {{COMPUTATION}}, [{{DEPS}}]);

// useCallback for stable function references
const {{HANDLER}} = useCallback(() => {{LOGIC}}, [{{DEPS}}]);
```

## Testing

### Unit Tests

```typescript
describe('{{COMPONENT_NAME}}', () => {
  it('{{TEST_DESCRIPTION_1}}', () => {
    // Arrange
    const props = {{TEST_PROPS}};

    // Act
    render(<{{COMPONENT_NAME}} {...props} />);

    // Assert
    expect({{ASSERTION}}).toBe({{EXPECTED}});
  });

  it('{{TEST_DESCRIPTION_2}}', () => {
    // Test implementation
  });
});
```

### Integration Tests

```typescript
describe('{{COMPONENT_NAME}} Integration', () => {
  it('{{INTEGRATION_TEST_DESCRIPTION}}', async () => {
    // Test with real API calls or mocked responses
  });
});
```

### E2E Tests (Playwright)

```typescript
test('{{E2E_TEST_DESCRIPTION}}', async ({ page }) => {
  await page.goto('{{URL}}');
  await page.click('{{SELECTOR}}');
  await expect(page.locator('{{SELECTOR}}')).toContainText('{{TEXT}}');
});
```

## Dependencies

### NPM Packages

| Package | Version | Purpose |
|---------|---------|---------|
| {{PACKAGE_1}} | {{VERSION_1}} | {{PURPOSE_1}} |
| {{PACKAGE_2}} | {{VERSION_2}} | {{PURPOSE_2}} |

### Internal Dependencies

- `{{COMPONENT_1}}` - {{USAGE_1}}
- `{{HOOK_1}}` - {{USAGE_2}}
- `{{UTILITY_1}}` - {{USAGE_3}}

## File Structure

```
src/
├── components/
│   └── {{COMPONENT_NAME}}/
│       ├── index.ts                    # Public exports
│       ├── {{COMPONENT_NAME}}.tsx      # Main component
│       ├── {{COMPONENT_NAME}}.module.css # Styles
│       ├── {{COMPONENT_NAME}}.test.tsx # Tests
│       ├── {{COMPONENT_NAME}}.stories.tsx # Storybook
│       └── components/                 # Sub-components
│           ├── {{SUB_COMPONENT_1}}.tsx
│           └── {{SUB_COMPONENT_2}}.tsx
```

## Examples

### Basic Usage

```jsx
<{{COMPONENT_NAME}}
  {{PROP_1}}={{{VALUE_1}}}
  {{PROP_2}}={{{VALUE_2}}}
  {{HANDLER_1}}={{{HANDLER_FUNCTION}}}
/>
```

### Advanced Usage

```jsx
<{{COMPONENT_NAME}}
  {{PROP_1}}={{{VALUE_1}}}
  {{PROP_2}}={{{VALUE_2}}}
  {{HANDLER_1}}={{{HANDLER_FUNCTION}}}
>
  <{{CHILD_COMPONENT}}>
    {{CHILD_CONTENT}}
  </{{CHILD_COMPONENT}}>
</{{COMPONENT_NAME}}>
```

### With Custom Styling

```jsx
<{{COMPONENT_NAME}}
  className="custom-class"
  style={{ {{CUSTOM_STYLES}} }}
/>
```

## Edge Cases

### Handling Empty Data

```typescript
if (!data || data.length === 0) {
  return <{{EMPTY_STATE_COMPONENT}} />;
}
```

### Error States

```typescript
if (error) {
  return (
    <{{ERROR_COMPONENT}}
      error={error}
      onRetry={{RETRY_HANDLER}}
    />
  );
}
```

### Loading States

```typescript
if (isLoading) {
  return <{{SKELETON_COMPONENT}} count={{COUNT}} />;
}
```

## Future Enhancements

- [ ] {{ENHANCEMENT_1}}
- [ ] {{ENHANCEMENT_2}}
- [ ] {{ENHANCEMENT_3}}

## Notes

{{ADDITIONAL_NOTES}}

## Related Documentation

- [Design System](./DESIGN_SYSTEM.md)
- [API Client](./API_CLIENT.md)
- [State Architecture](./STATE_ARCHITECTURE.md)
- Component docs: `{{RELATED_COMPONENT_DOCS}}`

---

**Maintainer**: {{MAINTAINER_NAME}}
**Last Review**: {{REVIEW_DATE}}
**Status**: {{CURRENT_STATUS}}
