#!/usr/bin/env bash
# Worktree Configuration Template
# Purpose: Environment setup script for new worktrees
# Variables: {{WORKTREE_NAME}}, {{BASE_BRANCH}}, {{PROJECT_NAME}}
# Generated by: git-worktree-manager agent
# Template location: ~/.multiagent/git/templates/configs/worktree-config.template.sh

# Worktree Information
export WORKTREE_NAME="{{WORKTREE_NAME}}"
export BASE_BRANCH="{{BASE_BRANCH}}"
export PROJECT_NAME="{{PROJECT_NAME}}"
export WORKTREE_PATH="../{{WORKTREE_NAME}}"

# Display worktree info
echo "========================================="
echo "Worktree: $WORKTREE_NAME"
echo "Base Branch: $BASE_BRANCH"
echo "Project: $PROJECT_NAME"
echo "Path: $WORKTREE_PATH"
echo "========================================="

# Optional: Set up project-specific environment
# Uncomment and customize as needed:

# export NODE_ENV=development
# export DATABASE_URL="postgresql://localhost/{{PROJECT_NAME}}_dev"

# Optional: Run setup commands
# npm install
# python -m venv venv
# source venv/bin/activate

echo "Worktree environment configured!"
echo "To switch to this worktree:"
echo "  cd $WORKTREE_PATH"
