# Issue Review Subsystem (Contributor-Only)

**Purpose**: Triage incoming GitHub issues from users and convert them into actionable specs.

**Context**: This subsystem is CONTRIBUTOR-ONLY - not shipped to user projects.

---

## 📋 Overview

The issue-review subsystem helps maintainers:
- Review incoming issues from users
- Categorize and prioritize issues
- Check completeness and clarity
- Generate specs from approved requests
- Link related issues
- Maintain roadmap

---

## 🔄 Workflow

```
1. User submits issue on GitHub
   ↓
2. Contributor runs: /github:issue-review
   ↓
3. issue-reviewer subagent analyzes:
   - Category (bug, enhancement, feature, question, docs)
   - Priority (critical, high, medium, low)
   - Completeness (complete, missing info, incomplete)
   ↓
4. Generates analysis report:
   → .multiagent/github/issue-review/reports/issue-{N}-analysis.md
   ↓
5. Suggests action:
   ✅ Create new spec
   ✅ Add to existing spec
   ⚠️ Request more info
   ✅ Answer & close
   ⏸️ Defer
   ↓
6. If approved to create spec:
   → specs/{NEXT_NUMBER}-{FEATURE_NAME}/spec.md
   → Uses templates/spec-from-issue.md
   ↓
7. Comments on issue with plan
   ↓
8. Adds labels and links related issues
   ↓
9. Generates summary:
   → .multiagent/github/issue-review/summaries/issue-{N}-summary.md
```

---

## 📁 Directory Structure

```
.multiagent/github/issue-review/
├── README.md                           # This file
├── templates/                          # Output templates
│   ├── issue-analysis.md              # Analysis report template
│   ├── spec-from-issue.md             # Spec generation template
│   └── issue-summary.md               # Quick summary template
└── scripts/                            # Automation scripts
    └── create-spec-from-issue.sh      # Helper script for spec generation

# Outputs go to:
/project-root/
└── issue-triage/                       # Working directory (OUTPUT)
    ├── issue-42-analysis.md           # Detailed analysis
    ├── issue-42-summary.md            # Quick reference
    └── issue-38-analysis.md           # Another analysis
```

---

## 📤 Outputs

### 1. Analysis Report (Working File)

**Location**: `issue-triage/issue-{N}-analysis.md`

**Contains**:
- Issue metadata (number, title, author, labels)
- Quick assessment (category, priority, clarity, completeness)
- Detailed analysis
- Recommended action with rationale
- Next steps
- Missing information (if any)
- Related issues
- Implementation estimate

**When created**: After running `/github:issue-review {N}`

**Lifecycle**: Created during triage, can be deleted after spec created

### 2. Spec File (Permanent)

**Location**: `specs/{NEXT_NUMBER}-{FEATURE_NAME}/spec.md`

**Contains**:
- Overview from issue
- User story (quoted from issue)
- Requirements (extracted from issue)
- Technical approach (to be filled by `/planning:plan`)
- Implementation plan (to be generated by `/planning:tasks`)
- Testing strategy
- Documentation updates
- Success criteria

**When created**: After approving "Create new spec" recommendation

**Lifecycle**: Permanent - this is the source of truth

### 3. Terminal Output Only

**Summary information displayed in terminal:**
- One-line summary
- Quick assessment
- Recommended action
- Next steps

**Not persisted** - shown during `/github:issue-review` execution

---

## 📁 Output Directory: `issue-triage/`

**Purpose**: Working directory for issue analysis files

**Location**: Project root (`/project-root/issue-triage/`)

**Contents**:
```
issue-triage/
├── issue-42-analysis.md    # Full analysis of issue #42
├── issue-38-analysis.md    # Full analysis of issue #38
└── README.md               # Explains this is temporary working dir
```

**Lifecycle**:
- Created during issue triage
- Contains working analysis files
- Can be cleared after specs created
- Add to `.gitignore` (temporary working files)

**When to clean up:**
```bash
# After creating specs, old analyses can be removed
rm issue-triage/issue-42-analysis.md  # Spec created, no longer needed
```

---

## 🎯 Usage

### Review All Open Issues

```bash
/github:issue-review

# Output:
# → Scans all open issues
# → Generates reports/ for high-priority ones
# → Shows summary of all issues
# → Recommends actions
```

### Review Specific Issue

```bash
/github:issue-review 42

# Output:
# → reports/issue-42-analysis.md (detailed analysis)
# → summaries/issue-42-summary.md (quick reference)
# → Suggests specific action
```

### Review by Label

```bash
/github:issue-review --label=bug
/github:issue-review --label=enhancement

# Output:
# → Filters issues by label
# → Generates reports for matching issues
# → Prioritizes within label
```

### Create Spec from Issue

```bash
/github:issue-review 42 --create-spec

# If approved, creates:
# → specs/007-typescript-support/spec.md
# → Uses templates/spec-from-issue.md
# → Comments on issue #42 with plan
# → Adds 'planned' label
# → Links related issues
```

---

## 📋 Templates

### issue-analysis.md

Comprehensive analysis template with:
- Quick assessment section
- Detailed analysis
- Recommendation with rationale
- Next steps for each action type
- Missing information checklist
- Implementation estimate

**Use for**: Detailed issue review

### spec-from-issue.md

Spec generation template with:
- Overview from issue
- User story section
- Requirements (functional and non-functional)
- Technical approach placeholder
- Implementation plan placeholder
- Testing strategy
- Documentation section
- Success criteria

**Use for**: Creating specs from issues

### issue-summary.md

Quick reference template with:
- One-line summary
- Quick facts table
- Action taken
- Output locations
- GitHub actions
- Next steps

**Use for**: Quick lookups and status checks

---

## 🔧 Integration

### With Planning System

```bash
# After creating spec from issue
/github:issue-review 42 --create-spec
# Creates: specs/007-typescript-support/spec.md

# Add technical details
cd specs/007-typescript-support
/planning:plan
# Fills technical approach section

# Generate tasks
/planning:tasks
# Creates: specs/007-typescript-support/tasks.md
```

### With GitHub

**Automated actions**:
- Comments on issues with plans
- Adds labels: `planned`, `needs-info`, `deferred`
- Links related issues
- Closes issues (if answering questions)

**Requires**: `gh` CLI installed and authenticated

---

## 📊 Issue Categories

| Category | Keywords | Priority | Action |
|----------|----------|----------|--------|
| **Bug** 🐛 | "doesn't work", "error", "crash" | High | Create hotfix spec or add to existing |
| **Enhancement** ✨ | "improve", "better", "could" | Medium | Add to existing spec or create new |
| **Feature** 🚀 | "add", "new", "support for" | High (if frequent) | Create new spec |
| **Question** ❓ | "how to", "can I", "help" | Low | Answer and close |
| **Docs** 📚 | "unclear", "docs", "guide" | Medium | Update docs |

---

## 🎯 Priority Levels

| Level | Indicators | Timeline |
|-------|-----------|----------|
| **Critical** 🔴 | Security, data loss, production broken | Immediate |
| **High** 🟠 | Affects many users, frequently requested | Next sprint |
| **Medium** 🟡 | Minor bug, nice-to-have feature | Backlog |
| **Low** 🟢 | Edge case, niche use case | Future |

---

## ✅ Best Practices

1. **Review regularly** - Check issues weekly
2. **Respond quickly** - Comment within 48 hours
3. **Group similar issues** - One spec can solve multiple problems
4. **Request clarification** - Don't guess requirements
5. **Link specs to issues** - Cross-reference for tracking
6. **Update roadmap** - Keep ROADMAP.md current
7. **Close the loop** - Update issues when work completes

---

## 🛠️ Troubleshooting

### "gh not found"
```bash
# Install GitHub CLI
brew install gh  # macOS
sudo apt install gh  # Ubuntu
winget install GitHub.cli  # Windows

# Authenticate
gh auth login
```

### "Cannot create spec directory"
- Check you're in project root
- Verify `specs/` directory exists
- Ensure write permissions

### "No issues found"
- Verify you're in correct repository
- Check issue state (open vs closed)
- Try without filters

---

## 📈 Success Metrics

Track effectiveness:
- **Response time**: < 48 hours for all issues
- **Conversion rate**: % of issues → specs
- **User satisfaction**: Feedback on issue handling
- **Roadmap alignment**: Community needs reflected

---

**Remember**: You're the bridge between users and development - make every interaction count!
