# Validation Checklists

**Purpose**: Dynamic validation checklists generated per subsystem, not pre-filled static files.

---

## How Checklists Work

### ❌ NOT Pre-Filled (Overkill)
Don't create 700-line checklists for each subsystem in advance.

### ✅ Dynamically Generated (Correct)
Generate checklists on-demand using the template + agent analysis.

---

## Generation Process

### Step 1: Agent Analyzes Subsystem
```bash
/validation:validate --subsystem implementation
```

The **validation-analyzer agent**:
1. Reads subsystem README
2. Lists all scripts in `scripts/`
3. Lists all commands in `~/.claude/commands/{subsystem}/`
4. Lists all agents used by subsystem
5. Understands what each component does

### Step 2: Template Filled Dynamically
Agent fills `checklist.md.template` with actual content:

```markdown
### Script 1: `find-proposal.sh`
**Purpose**: [extracted from script header]
- [ ] Executable and has correct shebang
- [ ] Validates --type parameter (enhancement|refactor|idea)
- [ ] Finds enhancement in docs/enhancements/**/*.md
- [ ] Returns absolute file path
```

### Step 3: Checklist Saved
Generated checklist saved to:
```
checklists/implementation-subsystem-2025-10-19.md
```

---

## Template Placeholders

The template has placeholders that get filled dynamically:

| Placeholder | Filled With |
|-------------|-------------|
| `{{SUBSYSTEM_NAME}}` | Subsystem being validated |
| `{{DATE}}` | Current date |
| `{{STATUS}}` | PENDING/IN_PROGRESS/COMPLETE |
| `{{PROGRESS}}` | Percentage complete |
| `{{SCRIPT_TESTS}}` | Per-script test cases (agent-generated) |
| `{{COMMAND_TESTS}}` | Per-command test cases (agent-generated) |
| `{{INTEGRATION_TESTS}}` | Integration points (agent-discovered) |
| `{{WORKFLOW_TESTS}}` | End-to-end workflows (agent-defined) |

---

## Example: implementation-subsystem.md

One example checklist is kept to show what a filled template looks like:
- `implementation-subsystem.md` - 706 lines, shows full detail

This demonstrates the template can handle complexity.

---

## Usage

### Generate Checklist
```bash
# Validation command generates checklist automatically
/validation:validate --subsystem implementation

# Creates: checklists/implementation-subsystem-2025-10-19.md
```

### Use Existing Template
```bash
# Agent uses template
cat templates/checklist.md.template

# Fills placeholders based on subsystem analysis
# Outputs filled checklist
```

---

## Why Not Pre-Fill?

**Problem with pre-filled checklists**:
- 3,473 lines (116KB) of static content
- Out of date the moment subsystem changes
- Maintenance nightmare
- Not flexible for new subsystems

**Solution with dynamic generation**:
- Template: 200 lines
- Generated per validation run
- Always current
- Works for any subsystem

---

## Directory Contents

```
checklists/
├── README.md                       # This file
└── implementation-subsystem.md     # Example (shows template capability)
```

**Note**: Other checklists (enhancement, refactoring, core, documentation) are generated dynamically when needed, not stored here.

---

**Summary**: Checklists are dynamically generated by validation-analyzer agent using the template, not pre-created static files.
