# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: 33585ef
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from knowledge_stack.models.chunk_lineage import ChunkLineage
from knowledge_stack.models.chunk_type import ChunkType
from knowledge_stack.models.synthetic_chunk_validation_status import SyntheticChunkValidationStatus
from typing import Optional, Set
from typing_extensions import Self

class RespChunk(BaseModel):
    """
    Chunk response exposed by the public API.
    """ # noqa: E501
    id: UUID = Field(description="Chunk identifier")
    chunk_container_id: UUID = Field(description="Chunk container identifier")
    text: StrictStr = Field(description="Chunk content")
    chunk_type: ChunkType = Field(description="Chunk type")
    chunk_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Flexible chunk metadata.")
    chunk_validation_status: SyntheticChunkValidationStatus = Field(description="Chunk validation status")
    chunk_validation_details: Optional[Dict[str, Any]] = Field(default=None, description="Validation details")
    created_at: datetime = Field(description="Creation timestamp")
    updated_at: datetime = Field(description="Update timestamp")
    asset_download_url: Optional[StrictStr] = Field(default=None, description="Presigned URL for assets")
    citations: Optional[List[ChunkLineage]] = Field(default=None, description="Parent citations for the chunk")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "chunk_container_id", "text", "chunk_type", "chunk_metadata", "chunk_validation_status", "chunk_validation_details", "created_at", "updated_at", "asset_download_url", "citations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespChunk from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in citations (list)
        _items = []
        if self.citations:
            for _item_citations in self.citations:
                if _item_citations:
                    _items.append(_item_citations.to_dict())
            _dict['citations'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespChunk from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "chunk_container_id": obj.get("chunk_container_id"),
            "text": obj.get("text"),
            "chunk_type": obj.get("chunk_type"),
            "chunk_metadata": obj.get("chunk_metadata"),
            "chunk_validation_status": obj.get("chunk_validation_status"),
            "chunk_validation_details": obj.get("chunk_validation_details"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "asset_download_url": obj.get("asset_download_url"),
            "citations": [ChunkLineage.from_dict(_item) for _item in obj["citations"]] if obj.get("citations") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


