/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalOauthIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the OAuth integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#comment ExternalOauthIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether to initiate operation of the integration or suspend it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#enabled ExternalOauthIntegration#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Specifies the list of roles that the client can set as the primary role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_allowed_roles_list ExternalOauthIntegration#external_oauth_allowed_roles_list}
    */
    readonly externalOauthAllowedRolesList?: string[];
    /**
    * Specifies whether the OAuth client or user can use a role that is not defined in the OAuth access token. Valid values are (case-insensitive): `DISABLE` | `ENABLE` | `ENABLE_FOR_PRIVILEGE`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_any_role_mode ExternalOauthIntegration#external_oauth_any_role_mode}
    */
    readonly externalOauthAnyRoleMode?: string;
    /**
    * Specifies additional values that can be used for the access token's audience validation on top of using the Customer's Snowflake Account URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_audience_list ExternalOauthIntegration#external_oauth_audience_list}
    */
    readonly externalOauthAudienceList?: string[];
    /**
    * Specifies the list of roles that a client cannot set as the primary role. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the EXTERNAL_OAUTH_ADD_PRIVILEGED_ROLES_TO_BLOCKED_LIST account parameter to FALSE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_blocked_roles_list ExternalOauthIntegration#external_oauth_blocked_roles_list}
    */
    readonly externalOauthBlockedRolesList?: string[];
    /**
    * Specifies the URL to define the OAuth 2.0 authorization server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_issuer ExternalOauthIntegration#external_oauth_issuer}
    */
    readonly externalOauthIssuer: string;
    /**
    * Specifies the endpoint or a list of endpoints from which to download public keys or certificates to validate an External OAuth access token. The maximum number of URLs that can be specified in the list is 3. If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_jws_keys_url ExternalOauthIntegration#external_oauth_jws_keys_url}
    */
    readonly externalOauthJwsKeysUrl?: string[];
    /**
    * Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_rsa_public_key ExternalOauthIntegration#external_oauth_rsa_public_key}
    */
    readonly externalOauthRsaPublicKey?: string;
    /**
    * Specifies a second RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. Used for key rotation. If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_rsa_public_key_2 ExternalOauthIntegration#external_oauth_rsa_public_key_2}
    */
    readonly externalOauthRsaPublicKey2?: string;
    /**
    * Specifies the scope delimiter in the authorization token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_scope_delimiter ExternalOauthIntegration#external_oauth_scope_delimiter}
    */
    readonly externalOauthScopeDelimiter?: string;
    /**
    * Specifies the access token claim to map the access token to an account role. If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_scope_mapping_attribute ExternalOauthIntegration#external_oauth_scope_mapping_attribute}
    */
    readonly externalOauthScopeMappingAttribute?: string;
    /**
    * Indicates which Snowflake user record attribute should be used to map the access token to a Snowflake user record. Valid values are (case-insensitive): `LOGIN_NAME` | `EMAIL_ADDRESS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_snowflake_user_mapping_attribute ExternalOauthIntegration#external_oauth_snowflake_user_mapping_attribute}
    */
    readonly externalOauthSnowflakeUserMappingAttribute: string;
    /**
    * Specifies the access token claim or claims that can be used to map the access token to a Snowflake user record. If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_token_user_mapping_claim ExternalOauthIntegration#external_oauth_token_user_mapping_claim}
    */
    readonly externalOauthTokenUserMappingClaim: string[];
    /**
    * Specifies the OAuth 2.0 authorization server to be Okta, Microsoft Azure AD, Ping Identity PingFederate, or a Custom OAuth 2.0 authorization server. Valid values are (case-insensitive): `OKTA` | `AZURE` | `PING_FEDERATE` | `CUSTOM`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#external_oauth_type ExternalOauthIntegration#external_oauth_type}
    */
    readonly externalOauthType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#id ExternalOauthIntegration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the External Oath integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#name ExternalOauthIntegration#name}
    */
    readonly name: string;
}
export interface ExternalOauthIntegrationDescribeOutputComment {
}
export declare function externalOauthIntegrationDescribeOutputCommentToTerraform(struct?: ExternalOauthIntegrationDescribeOutputComment): any;
export declare function externalOauthIntegrationDescribeOutputCommentToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputComment): any;
export declare class ExternalOauthIntegrationDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputComment | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputCommentOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputEnabled {
}
export declare function externalOauthIntegrationDescribeOutputEnabledToTerraform(struct?: ExternalOauthIntegrationDescribeOutputEnabled): any;
export declare function externalOauthIntegrationDescribeOutputEnabledToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputEnabled): any;
export declare class ExternalOauthIntegrationDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputEnabled | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputEnabledOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStruct {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStructToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStruct): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStructToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStruct): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStruct | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStructOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleMode {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthAnyRoleModeToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleMode): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthAnyRoleModeToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleMode): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleModeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleMode | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleMode | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleModeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleModeOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStruct {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthAudienceListStructToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStruct): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthAudienceListStructToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStruct): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStruct | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStructOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStruct {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStructToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStruct): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStructToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStruct): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStruct | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStructOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthIssuer {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthIssuerToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthIssuer): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthIssuerToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthIssuer): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthIssuerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthIssuer | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthIssuer | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthIssuerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthIssuerOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrl {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrlToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrl): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrlToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrl): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrl | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrl | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrlOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthRsaPublicKeyToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthRsaPublicKeyToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKeyOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2 {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2ToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2ToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2 | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2 | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2OutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiter {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthScopeDelimiterToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiter): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthScopeDelimiterToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiter): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiter | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiter | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiterOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttribute {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttributeToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttribute): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttributeToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttribute): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttributeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttribute | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttribute | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttributeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttributeOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaim {
}
export declare function externalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaimToTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaim): any;
export declare function externalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaimToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaim): any;
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaim | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaim | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaimList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaimOutputReference;
}
export interface ExternalOauthIntegrationDescribeOutput {
}
export declare function externalOauthIntegrationDescribeOutputToTerraform(struct?: ExternalOauthIntegrationDescribeOutput): any;
export declare function externalOauthIntegrationDescribeOutputToHclTerraform(struct?: ExternalOauthIntegrationDescribeOutput): any;
export declare class ExternalOauthIntegrationDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationDescribeOutput | undefined;
    set internalValue(value: ExternalOauthIntegrationDescribeOutput | undefined);
    private _comment;
    get comment(): ExternalOauthIntegrationDescribeOutputCommentList;
    private _enabled;
    get enabled(): ExternalOauthIntegrationDescribeOutputEnabledList;
    private _externalOauthAllowedRolesList;
    get externalOauthAllowedRolesList(): ExternalOauthIntegrationDescribeOutputExternalOauthAllowedRolesListStructList;
    private _externalOauthAnyRoleMode;
    get externalOauthAnyRoleMode(): ExternalOauthIntegrationDescribeOutputExternalOauthAnyRoleModeList;
    private _externalOauthAudienceList;
    get externalOauthAudienceList(): ExternalOauthIntegrationDescribeOutputExternalOauthAudienceListStructList;
    private _externalOauthBlockedRolesList;
    get externalOauthBlockedRolesList(): ExternalOauthIntegrationDescribeOutputExternalOauthBlockedRolesListStructList;
    private _externalOauthIssuer;
    get externalOauthIssuer(): ExternalOauthIntegrationDescribeOutputExternalOauthIssuerList;
    private _externalOauthJwsKeysUrl;
    get externalOauthJwsKeysUrl(): ExternalOauthIntegrationDescribeOutputExternalOauthJwsKeysUrlList;
    private _externalOauthRsaPublicKey;
    get externalOauthRsaPublicKey(): ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKeyList;
    private _externalOauthRsaPublicKey2;
    get externalOauthRsaPublicKey2(): ExternalOauthIntegrationDescribeOutputExternalOauthRsaPublicKey2List;
    private _externalOauthScopeDelimiter;
    get externalOauthScopeDelimiter(): ExternalOauthIntegrationDescribeOutputExternalOauthScopeDelimiterList;
    private _externalOauthSnowflakeUserMappingAttribute;
    get externalOauthSnowflakeUserMappingAttribute(): ExternalOauthIntegrationDescribeOutputExternalOauthSnowflakeUserMappingAttributeList;
    private _externalOauthTokenUserMappingClaim;
    get externalOauthTokenUserMappingClaim(): ExternalOauthIntegrationDescribeOutputExternalOauthTokenUserMappingClaimList;
}
export declare class ExternalOauthIntegrationDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationDescribeOutputOutputReference;
}
export interface ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStruct {
}
export declare function externalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStructToTerraform(struct?: ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStruct): any;
export declare function externalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStructToHclTerraform(struct?: ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStruct): any;
export declare class ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStruct | undefined;
    set internalValue(value: ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStruct | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStructOutputReference;
}
export interface ExternalOauthIntegrationRelatedParameters {
}
export declare function externalOauthIntegrationRelatedParametersToTerraform(struct?: ExternalOauthIntegrationRelatedParameters): any;
export declare function externalOauthIntegrationRelatedParametersToHclTerraform(struct?: ExternalOauthIntegrationRelatedParameters): any;
export declare class ExternalOauthIntegrationRelatedParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationRelatedParameters | undefined;
    set internalValue(value: ExternalOauthIntegrationRelatedParameters | undefined);
    private _externalOauthAddPrivilegedRolesToBlockedList;
    get externalOauthAddPrivilegedRolesToBlockedList(): ExternalOauthIntegrationRelatedParametersExternalOauthAddPrivilegedRolesToBlockedListStructList;
}
export declare class ExternalOauthIntegrationRelatedParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationRelatedParametersOutputReference;
}
export interface ExternalOauthIntegrationShowOutput {
}
export declare function externalOauthIntegrationShowOutputToTerraform(struct?: ExternalOauthIntegrationShowOutput): any;
export declare function externalOauthIntegrationShowOutputToHclTerraform(struct?: ExternalOauthIntegrationShowOutput): any;
export declare class ExternalOauthIntegrationShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalOauthIntegrationShowOutput | undefined;
    set internalValue(value: ExternalOauthIntegrationShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class ExternalOauthIntegrationShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalOauthIntegrationShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration snowflake_external_oauth_integration}
*/
export declare class ExternalOauthIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_external_oauth_integration";
    /**
    * Generates CDKTF code for importing a ExternalOauthIntegration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExternalOauthIntegration to import
    * @param importFromId The id of the existing ExternalOauthIntegration that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExternalOauthIntegration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/external_oauth_integration snowflake_external_oauth_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalOauthIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: ExternalOauthIntegrationConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ExternalOauthIntegrationDescribeOutputList;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _externalOauthAllowedRolesList?;
    get externalOauthAllowedRolesList(): string[];
    set externalOauthAllowedRolesList(value: string[]);
    resetExternalOauthAllowedRolesList(): void;
    get externalOauthAllowedRolesListInput(): string[] | undefined;
    private _externalOauthAnyRoleMode?;
    get externalOauthAnyRoleMode(): string;
    set externalOauthAnyRoleMode(value: string);
    resetExternalOauthAnyRoleMode(): void;
    get externalOauthAnyRoleModeInput(): string | undefined;
    private _externalOauthAudienceList?;
    get externalOauthAudienceList(): string[];
    set externalOauthAudienceList(value: string[]);
    resetExternalOauthAudienceList(): void;
    get externalOauthAudienceListInput(): string[] | undefined;
    private _externalOauthBlockedRolesList?;
    get externalOauthBlockedRolesList(): string[];
    set externalOauthBlockedRolesList(value: string[]);
    resetExternalOauthBlockedRolesList(): void;
    get externalOauthBlockedRolesListInput(): string[] | undefined;
    private _externalOauthIssuer?;
    get externalOauthIssuer(): string;
    set externalOauthIssuer(value: string);
    get externalOauthIssuerInput(): string | undefined;
    private _externalOauthJwsKeysUrl?;
    get externalOauthJwsKeysUrl(): string[];
    set externalOauthJwsKeysUrl(value: string[]);
    resetExternalOauthJwsKeysUrl(): void;
    get externalOauthJwsKeysUrlInput(): string[] | undefined;
    private _externalOauthRsaPublicKey?;
    get externalOauthRsaPublicKey(): string;
    set externalOauthRsaPublicKey(value: string);
    resetExternalOauthRsaPublicKey(): void;
    get externalOauthRsaPublicKeyInput(): string | undefined;
    private _externalOauthRsaPublicKey2?;
    get externalOauthRsaPublicKey2(): string;
    set externalOauthRsaPublicKey2(value: string);
    resetExternalOauthRsaPublicKey2(): void;
    get externalOauthRsaPublicKey2Input(): string | undefined;
    private _externalOauthScopeDelimiter?;
    get externalOauthScopeDelimiter(): string;
    set externalOauthScopeDelimiter(value: string);
    resetExternalOauthScopeDelimiter(): void;
    get externalOauthScopeDelimiterInput(): string | undefined;
    private _externalOauthScopeMappingAttribute?;
    get externalOauthScopeMappingAttribute(): string;
    set externalOauthScopeMappingAttribute(value: string);
    resetExternalOauthScopeMappingAttribute(): void;
    get externalOauthScopeMappingAttributeInput(): string | undefined;
    private _externalOauthSnowflakeUserMappingAttribute?;
    get externalOauthSnowflakeUserMappingAttribute(): string;
    set externalOauthSnowflakeUserMappingAttribute(value: string);
    get externalOauthSnowflakeUserMappingAttributeInput(): string | undefined;
    private _externalOauthTokenUserMappingClaim?;
    get externalOauthTokenUserMappingClaim(): string[];
    set externalOauthTokenUserMappingClaim(value: string[]);
    get externalOauthTokenUserMappingClaimInput(): string[] | undefined;
    private _externalOauthType?;
    get externalOauthType(): string;
    set externalOauthType(value: string);
    get externalOauthTypeInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _relatedParameters;
    get relatedParameters(): ExternalOauthIntegrationRelatedParametersList;
    private _showOutput;
    get showOutput(): ExternalOauthIntegrationShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
