/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LegacyServiceUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT_DETACHED_QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#abort_detached_query LegacyServiceUser#abort_detached_query}
    */
    readonly abortDetachedQuery?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#autocommit LegacyServiceUser#autocommit}
    */
    readonly autocommit?: boolean | cdktf.IResolvable;
    /**
    * The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#binary_input_format LegacyServiceUser#binary_input_format}
    */
    readonly binaryInputFormat?: string;
    /**
    * The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#binary_output_format LegacyServiceUser#binary_output_format}
    */
    readonly binaryOutputFormat?: string;
    /**
    * Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT_MEMORY_LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_memory_limit LegacyServiceUser#client_memory_limit}
    */
    readonly clientMemoryLimit?: number;
    /**
    * For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_metadata_request_use_connection_ctx LegacyServiceUser#client_metadata_request_use_connection_ctx}
    */
    readonly clientMetadataRequestUseConnectionCtx?: boolean | cdktf.IResolvable;
    /**
    * Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT_PREFETCH_THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_prefetch_threads LegacyServiceUser#client_prefetch_threads}
    */
    readonly clientPrefetchThreads?: number;
    /**
    * Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT_RESULT_CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_result_chunk_size LegacyServiceUser#client_result_chunk_size}
    */
    readonly clientResultChunkSize?: number;
    /**
    * Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT_RESULT_COLUMN_CASE_INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_result_column_case_insensitive LegacyServiceUser#client_result_column_case_insensitive}
    */
    readonly clientResultColumnCaseInsensitive?: boolean | cdktf.IResolvable;
    /**
    * Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_session_keep_alive LegacyServiceUser#client_session_keep_alive}
    */
    readonly clientSessionKeepAlive?: boolean | cdktf.IResolvable;
    /**
    * Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_session_keep_alive_heartbeat_frequency LegacyServiceUser#client_session_keep_alive_heartbeat_frequency}
    */
    readonly clientSessionKeepAliveHeartbeatFrequency?: number;
    /**
    * Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT_TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#client_timestamp_type_mapping LegacyServiceUser#client_timestamp_type_mapping}
    */
    readonly clientTimestampTypeMapping?: string;
    /**
    * Specifies a comment for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#comment LegacyServiceUser#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#date_input_format LegacyServiceUser#date_input_format}
    */
    readonly dateInputFormat?: string;
    /**
    * Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#date_output_format LegacyServiceUser#date_output_format}
    */
    readonly dateOutputFormat?: string;
    /**
    * Specifies the number of days after which the user status is set to `Expired` and the user is no longer allowed to log in. This is useful for defining temporary users (i.e. users who should only have access to Snowflake for a limited time period). In general, you should not set this property for [account administrators](https://docs.snowflake.com/en/user-guide/security-access-control-considerations.html#label-accountadmin-users) (i.e. users with the `ACCOUNTADMIN` role) because Snowflake locks them out when they become `Expired`. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#days_to_expiry LegacyServiceUser#days_to_expiry}
    */
    readonly daysToExpiry?: number;
    /**
    * Specifies the namespace (database only or database and schema) that is active by default for the user’s session upon login. Note that the CREATE USER operation does not verify that the namespace exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#default_namespace LegacyServiceUser#default_namespace}
    */
    readonly defaultNamespace?: string;
    /**
    * Specifies the role that is active by default for the user’s session upon login. Note that specifying a default role for a user does **not** grant the role to the user. The role must be granted explicitly to the user using the [GRANT ROLE](https://docs.snowflake.com/en/sql-reference/sql/grant-role) command. In addition, the CREATE USER operation does not verify that the role exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#default_role LegacyServiceUser#default_role}
    */
    readonly defaultRole?: string;
    /**
    * Specifies the secondary roles that are active for the user’s session upon login. Valid values are (case-insensitive): `DEFAULT` | `NONE` | `ALL`. More information can be found in [doc](https://docs.snowflake.com/en/sql-reference/sql/create-user#optional-object-properties-objectproperties).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#default_secondary_roles_option LegacyServiceUser#default_secondary_roles_option}
    */
    readonly defaultSecondaryRolesOption?: string;
    /**
    * Specifies the virtual warehouse that is active by default for the user’s session upon login. Note that the CREATE USER operation does not verify that the warehouse exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#default_warehouse LegacyServiceUser#default_warehouse}
    */
    readonly defaultWarehouse?: string;
    /**
    * Specifies whether the user is disabled, which prevents logging in and aborts all the currently-running queries for the user. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#disabled LegacyServiceUser#disabled}
    */
    readonly disabled?: string;
    /**
    * Name displayed for the user in the Snowflake web interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#display_name LegacyServiceUser#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#email LegacyServiceUser#email}
    */
    readonly email?: string;
    /**
    * Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE_UNLOAD_PHYSICAL_TYPE_OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#enable_unload_physical_type_optimization LegacyServiceUser#enable_unload_physical_type_optimization}
    */
    readonly enableUnloadPhysicalTypeOptimization?: boolean | cdktf.IResolvable;
    /**
    * Controls whether query text is redacted if a SQL query fails due to a syntax or parsing error. If `FALSE`, the content of a failed query is redacted in the views, pages, and functions that provide a query history. Only users with a role that is granted or inherits the AUDIT privilege can set the ENABLE_UNREDACTED_QUERY_SYNTAX_ERROR parameter. When using the ALTER USER command to set the parameter to `TRUE` for a particular user, modify the user that you want to see the query text, not the user who executed the query (if those are different users). For more information, check [ENABLE_UNREDACTED_QUERY_SYNTAX_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unredacted-query-syntax-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#enable_unredacted_query_syntax_error LegacyServiceUser#enable_unredacted_query_syntax_error}
    */
    readonly enableUnredactedQuerySyntaxError?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#error_on_nondeterministic_merge LegacyServiceUser#error_on_nondeterministic_merge}
    */
    readonly errorOnNondeterministicMerge?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#error_on_nondeterministic_update LegacyServiceUser#error_on_nondeterministic_update}
    */
    readonly errorOnNondeterministicUpdate?: boolean | cdktf.IResolvable;
    /**
    * Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#geography_output_format LegacyServiceUser#geography_output_format}
    */
    readonly geographyOutputFormat?: string;
    /**
    * Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#geometry_output_format LegacyServiceUser#geometry_output_format}
    */
    readonly geometryOutputFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#id LegacyServiceUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies how JDBC processes columns that have a scale of zero (0). For more information, check [JDBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#jdbc_treat_decimal_as_int LegacyServiceUser#jdbc_treat_decimal_as_int}
    */
    readonly jdbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Specifies how JDBC processes TIMESTAMP_NTZ values. For more information, check [JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#jdbc_treat_timestamp_ntz_as_utc LegacyServiceUser#jdbc_treat_timestamp_ntz_as_utc}
    */
    readonly jdbcTreatTimestampNtzAsUtc?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC_USE_SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#jdbc_use_session_timezone LegacyServiceUser#jdbc_use_session_timezone}
    */
    readonly jdbcUseSessionTimezone?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#json_indent LegacyServiceUser#json_indent}
    */
    readonly jsonIndent?: number;
    /**
    * Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#lock_timeout LegacyServiceUser#lock_timeout}
    */
    readonly lockTimeout?: number;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#log_level LegacyServiceUser#log_level}
    */
    readonly logLevel?: string;
    /**
    * The name users use to log in. If not supplied, snowflake will use name instead. Login names are always case-insensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#login_name LegacyServiceUser#login_name}
    */
    readonly loginName?: string;
    /**
    * Specifies the number of minutes until the temporary lock on the user login is cleared. To protect against unauthorized user login, Snowflake places a temporary lock on a user after five consecutive unsuccessful login attempts. When creating a user, this property can be set to prevent them from logging in until the specified amount of time passes. To remove a lock immediately for a user, specify a value of 0 for this parameter. **Note** because this value changes continuously after setting it, the provider is currently NOT handling the external changes to it. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#mins_to_unlock LegacyServiceUser#mins_to_unlock}
    */
    readonly minsToUnlock?: number;
    /**
    * Number of statements to execute when using the multi-statement capability. For more information, check [MULTI_STATEMENT_COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#multi_statement_count LegacyServiceUser#multi_statement_count}
    */
    readonly multiStatementCount?: number;
    /**
    * Specifies whether the user is forced to change their password on next login (including their first/initial login) into the system. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#must_change_password LegacyServiceUser#must_change_password}
    */
    readonly mustChangePassword?: string;
    /**
    * Name of the user. Note that if you do not supply login_name this will be used as login_name. Check the [docs](https://docs.snowflake.net/manuals/sql-reference/sql/create-user.html#required-parameters). Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#name LegacyServiceUser#name}
    */
    readonly name: string;
    /**
    * Specifies the network policy to enforce for your account. Network policies enable restricting access to your account based on users’ IP address. For more details, see [Controlling network traffic with network policies](https://docs.snowflake.com/en/user-guide/network-policies). Any existing network policy (created using [CREATE NETWORK POLICY](https://docs.snowflake.com/en/sql-reference/sql/create-network-policy)). For more information, check [NETWORK_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#network-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#network_policy LegacyServiceUser#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER_SEQUENCE_AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#noorder_sequence_as_default LegacyServiceUser#noorder_sequence_as_default}
    */
    readonly noorderSequenceAsDefault?: boolean | cdktf.IResolvable;
    /**
    * Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#odbc_treat_decimal_as_int LegacyServiceUser#odbc_treat_decimal_as_int}
    */
    readonly odbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Password for the user. **WARNING:** this will put the password in the terraform state file. Use carefully.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#password LegacyServiceUser#password}
    */
    readonly password?: string;
    /**
    * Specifies whether to prevent data unload operations to internal (Snowflake) stages using [COPY INTO <location>](https://docs.snowflake.com/en/sql-reference/sql/copy-into-location) statements. For more information, check [PREVENT_UNLOAD_TO_INTERNAL_STAGES docs](https://docs.snowflake.com/en/sql-reference/parameters#prevent-unload-to-internal-stages).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#prevent_unload_to_internal_stages LegacyServiceUser#prevent_unload_to_internal_stages}
    */
    readonly preventUnloadToInternalStages?: boolean | cdktf.IResolvable;
    /**
    * Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY_HISTORY, QUERY_HISTORY_BY_*](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#query_tag LegacyServiceUser#query_tag}
    */
    readonly queryTag?: string;
    /**
    * Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED_IDENTIFIERS_IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#quoted_identifiers_ignore_case LegacyServiceUser#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS_PER_RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#rows_per_resultset LegacyServiceUser#rows_per_resultset}
    */
    readonly rowsPerResultset?: number;
    /**
    * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#rsa_public_key LegacyServiceUser#rsa_public_key}
    */
    readonly rsaPublicKey?: string;
    /**
    * Specifies the user’s second RSA public key; used to rotate the public and private keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#rsa_public_key_2 LegacyServiceUser#rsa_public_key_2}
    */
    readonly rsaPublicKey2?: string;
    /**
    * Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3_STAGE_VPCE_DNS_NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#s3_stage_vpce_dns_name LegacyServiceUser#s3_stage_vpce_dns_name}
    */
    readonly s3StageVpceDnsName?: string;
    /**
    * Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#search_path LegacyServiceUser#search_path}
    */
    readonly searchPath?: string;
    /**
    * Specifies the name of a consumer account to simulate for testing/validating shared data, particularly shared secure views. When this parameter is set in a session, shared views return rows as if executed in the specified consumer account rather than the provider account. For more information, see [Introduction to Secure Data Sharing](https://docs.snowflake.com/en/user-guide/data-sharing-intro) and [Working with shares](https://docs.snowflake.com/en/user-guide/data-sharing-provider). For more information, check [SIMULATED_DATA_SHARING_CONSUMER docs](https://docs.snowflake.com/en/sql-reference/parameters#simulated-data-sharing-consumer).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#simulated_data_sharing_consumer LegacyServiceUser#simulated_data_sharing_consumer}
    */
    readonly simulatedDataSharingConsumer?: string;
    /**
    * Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX_CONCURRENCY_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT_QUEUED_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#statement_queued_timeout_in_seconds LegacyServiceUser#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#statement_timeout_in_seconds LegacyServiceUser#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT_JSON_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#strict_json_output LegacyServiceUser#strict_json_output}
    */
    readonly strictJsonOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#time_input_format LegacyServiceUser#time_input_format}
    */
    readonly timeInputFormat?: string;
    /**
    * Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#time_output_format LegacyServiceUser#time_output_format}
    */
    readonly timeOutputFormat?: string;
    /**
    * Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP_DAY_IS_ALWAYS_24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_day_is_always_24h LegacyServiceUser#timestamp_day_is_always_24h}
    */
    readonly timestampDayIsAlways24H?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_input_format LegacyServiceUser#timestamp_input_format}
    */
    readonly timestampInputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_LTZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_LTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_ltz_output_format LegacyServiceUser#timestamp_ltz_output_format}
    */
    readonly timestampLtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_NTZ data type. For more information, check [TIMESTAMP_NTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_ntz_output_format LegacyServiceUser#timestamp_ntz_output_format}
    */
    readonly timestampNtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_output_format LegacyServiceUser#timestamp_output_format}
    */
    readonly timestampOutputFormat?: string;
    /**
    * Specifies the TIMESTAMP_* variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_type_mapping LegacyServiceUser#timestamp_type_mapping}
    */
    readonly timestampTypeMapping?: string;
    /**
    * Specifies the display format for the TIMESTAMP_TZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_TZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timestamp_tz_output_format LegacyServiceUser#timestamp_tz_output_format}
    */
    readonly timestampTzOutputFormat?: string;
    /**
    * Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#timezone LegacyServiceUser#timezone}
    */
    readonly timezone?: string;
    /**
    * Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#trace_level LegacyServiceUser#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION_ABORT_ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#transaction_abort_on_error LegacyServiceUser#transaction_abort_on_error}
    */
    readonly transactionAbortOnError?: boolean | cdktf.IResolvable;
    /**
    * Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION_DEFAULT_ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#transaction_default_isolation_level LegacyServiceUser#transaction_default_isolation_level}
    */
    readonly transactionDefaultIsolationLevel?: string;
    /**
    * Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO_DIGIT_CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#two_digit_century_start LegacyServiceUser#two_digit_century_start}
    */
    readonly twoDigitCenturyStart?: number;
    /**
    * Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED_DDL_ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#unsupported_ddl_action LegacyServiceUser#unsupported_ddl_action}
    */
    readonly unsupportedDdlAction?: string;
    /**
    * Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE_CACHED_RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#use_cached_result LegacyServiceUser#use_cached_result}
    */
    readonly useCachedResult?: boolean | cdktf.IResolvable;
    /**
    * Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK_OF_YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#week_of_year_policy LegacyServiceUser#week_of_year_policy}
    */
    readonly weekOfYearPolicy?: number;
    /**
    * Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#week_start LegacyServiceUser#week_start}
    */
    readonly weekStart?: number;
}
export interface LegacyServiceUserParametersAbortDetachedQuery {
}
export declare function legacyServiceUserParametersAbortDetachedQueryToTerraform(struct?: LegacyServiceUserParametersAbortDetachedQuery): any;
export declare function legacyServiceUserParametersAbortDetachedQueryToHclTerraform(struct?: LegacyServiceUserParametersAbortDetachedQuery): any;
export declare class LegacyServiceUserParametersAbortDetachedQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersAbortDetachedQuery | undefined;
    set internalValue(value: LegacyServiceUserParametersAbortDetachedQuery | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersAbortDetachedQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersAbortDetachedQueryOutputReference;
}
export interface LegacyServiceUserParametersAutocommit {
}
export declare function legacyServiceUserParametersAutocommitToTerraform(struct?: LegacyServiceUserParametersAutocommit): any;
export declare function legacyServiceUserParametersAutocommitToHclTerraform(struct?: LegacyServiceUserParametersAutocommit): any;
export declare class LegacyServiceUserParametersAutocommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersAutocommit | undefined;
    set internalValue(value: LegacyServiceUserParametersAutocommit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersAutocommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersAutocommitOutputReference;
}
export interface LegacyServiceUserParametersBinaryInputFormat {
}
export declare function legacyServiceUserParametersBinaryInputFormatToTerraform(struct?: LegacyServiceUserParametersBinaryInputFormat): any;
export declare function legacyServiceUserParametersBinaryInputFormatToHclTerraform(struct?: LegacyServiceUserParametersBinaryInputFormat): any;
export declare class LegacyServiceUserParametersBinaryInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersBinaryInputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersBinaryInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersBinaryInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersBinaryInputFormatOutputReference;
}
export interface LegacyServiceUserParametersBinaryOutputFormat {
}
export declare function legacyServiceUserParametersBinaryOutputFormatToTerraform(struct?: LegacyServiceUserParametersBinaryOutputFormat): any;
export declare function legacyServiceUserParametersBinaryOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersBinaryOutputFormat): any;
export declare class LegacyServiceUserParametersBinaryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersBinaryOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersBinaryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersBinaryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersBinaryOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersClientMemoryLimit {
}
export declare function legacyServiceUserParametersClientMemoryLimitToTerraform(struct?: LegacyServiceUserParametersClientMemoryLimit): any;
export declare function legacyServiceUserParametersClientMemoryLimitToHclTerraform(struct?: LegacyServiceUserParametersClientMemoryLimit): any;
export declare class LegacyServiceUserParametersClientMemoryLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientMemoryLimit | undefined;
    set internalValue(value: LegacyServiceUserParametersClientMemoryLimit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientMemoryLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientMemoryLimitOutputReference;
}
export interface LegacyServiceUserParametersClientMetadataRequestUseConnectionCtx {
}
export declare function legacyServiceUserParametersClientMetadataRequestUseConnectionCtxToTerraform(struct?: LegacyServiceUserParametersClientMetadataRequestUseConnectionCtx): any;
export declare function legacyServiceUserParametersClientMetadataRequestUseConnectionCtxToHclTerraform(struct?: LegacyServiceUserParametersClientMetadataRequestUseConnectionCtx): any;
export declare class LegacyServiceUserParametersClientMetadataRequestUseConnectionCtxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientMetadataRequestUseConnectionCtx | undefined;
    set internalValue(value: LegacyServiceUserParametersClientMetadataRequestUseConnectionCtx | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientMetadataRequestUseConnectionCtxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientMetadataRequestUseConnectionCtxOutputReference;
}
export interface LegacyServiceUserParametersClientPrefetchThreads {
}
export declare function legacyServiceUserParametersClientPrefetchThreadsToTerraform(struct?: LegacyServiceUserParametersClientPrefetchThreads): any;
export declare function legacyServiceUserParametersClientPrefetchThreadsToHclTerraform(struct?: LegacyServiceUserParametersClientPrefetchThreads): any;
export declare class LegacyServiceUserParametersClientPrefetchThreadsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientPrefetchThreads | undefined;
    set internalValue(value: LegacyServiceUserParametersClientPrefetchThreads | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientPrefetchThreadsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientPrefetchThreadsOutputReference;
}
export interface LegacyServiceUserParametersClientResultChunkSize {
}
export declare function legacyServiceUserParametersClientResultChunkSizeToTerraform(struct?: LegacyServiceUserParametersClientResultChunkSize): any;
export declare function legacyServiceUserParametersClientResultChunkSizeToHclTerraform(struct?: LegacyServiceUserParametersClientResultChunkSize): any;
export declare class LegacyServiceUserParametersClientResultChunkSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientResultChunkSize | undefined;
    set internalValue(value: LegacyServiceUserParametersClientResultChunkSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientResultChunkSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientResultChunkSizeOutputReference;
}
export interface LegacyServiceUserParametersClientResultColumnCaseInsensitive {
}
export declare function legacyServiceUserParametersClientResultColumnCaseInsensitiveToTerraform(struct?: LegacyServiceUserParametersClientResultColumnCaseInsensitive): any;
export declare function legacyServiceUserParametersClientResultColumnCaseInsensitiveToHclTerraform(struct?: LegacyServiceUserParametersClientResultColumnCaseInsensitive): any;
export declare class LegacyServiceUserParametersClientResultColumnCaseInsensitiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientResultColumnCaseInsensitive | undefined;
    set internalValue(value: LegacyServiceUserParametersClientResultColumnCaseInsensitive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientResultColumnCaseInsensitiveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientResultColumnCaseInsensitiveOutputReference;
}
export interface LegacyServiceUserParametersClientSessionKeepAlive {
}
export declare function legacyServiceUserParametersClientSessionKeepAliveToTerraform(struct?: LegacyServiceUserParametersClientSessionKeepAlive): any;
export declare function legacyServiceUserParametersClientSessionKeepAliveToHclTerraform(struct?: LegacyServiceUserParametersClientSessionKeepAlive): any;
export declare class LegacyServiceUserParametersClientSessionKeepAliveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientSessionKeepAlive | undefined;
    set internalValue(value: LegacyServiceUserParametersClientSessionKeepAlive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientSessionKeepAliveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientSessionKeepAliveOutputReference;
}
export interface LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequency {
}
export declare function legacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyToTerraform(struct?: LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare function legacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyToHclTerraform(struct?: LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare class LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequency | undefined;
    set internalValue(value: LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequency | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference;
}
export interface LegacyServiceUserParametersClientTimestampTypeMapping {
}
export declare function legacyServiceUserParametersClientTimestampTypeMappingToTerraform(struct?: LegacyServiceUserParametersClientTimestampTypeMapping): any;
export declare function legacyServiceUserParametersClientTimestampTypeMappingToHclTerraform(struct?: LegacyServiceUserParametersClientTimestampTypeMapping): any;
export declare class LegacyServiceUserParametersClientTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersClientTimestampTypeMapping | undefined;
    set internalValue(value: LegacyServiceUserParametersClientTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersClientTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersClientTimestampTypeMappingOutputReference;
}
export interface LegacyServiceUserParametersDateInputFormat {
}
export declare function legacyServiceUserParametersDateInputFormatToTerraform(struct?: LegacyServiceUserParametersDateInputFormat): any;
export declare function legacyServiceUserParametersDateInputFormatToHclTerraform(struct?: LegacyServiceUserParametersDateInputFormat): any;
export declare class LegacyServiceUserParametersDateInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersDateInputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersDateInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersDateInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersDateInputFormatOutputReference;
}
export interface LegacyServiceUserParametersDateOutputFormat {
}
export declare function legacyServiceUserParametersDateOutputFormatToTerraform(struct?: LegacyServiceUserParametersDateOutputFormat): any;
export declare function legacyServiceUserParametersDateOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersDateOutputFormat): any;
export declare class LegacyServiceUserParametersDateOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersDateOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersDateOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersDateOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersDateOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimization {
}
export declare function legacyServiceUserParametersEnableUnloadPhysicalTypeOptimizationToTerraform(struct?: LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimization): any;
export declare function legacyServiceUserParametersEnableUnloadPhysicalTypeOptimizationToHclTerraform(struct?: LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimization): any;
export declare class LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimization | undefined;
    set internalValue(value: LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimization | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimizationOutputReference;
}
export interface LegacyServiceUserParametersEnableUnredactedQuerySyntaxError {
}
export declare function legacyServiceUserParametersEnableUnredactedQuerySyntaxErrorToTerraform(struct?: LegacyServiceUserParametersEnableUnredactedQuerySyntaxError): any;
export declare function legacyServiceUserParametersEnableUnredactedQuerySyntaxErrorToHclTerraform(struct?: LegacyServiceUserParametersEnableUnredactedQuerySyntaxError): any;
export declare class LegacyServiceUserParametersEnableUnredactedQuerySyntaxErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersEnableUnredactedQuerySyntaxError | undefined;
    set internalValue(value: LegacyServiceUserParametersEnableUnredactedQuerySyntaxError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersEnableUnredactedQuerySyntaxErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersEnableUnredactedQuerySyntaxErrorOutputReference;
}
export interface LegacyServiceUserParametersErrorOnNondeterministicMerge {
}
export declare function legacyServiceUserParametersErrorOnNondeterministicMergeToTerraform(struct?: LegacyServiceUserParametersErrorOnNondeterministicMerge): any;
export declare function legacyServiceUserParametersErrorOnNondeterministicMergeToHclTerraform(struct?: LegacyServiceUserParametersErrorOnNondeterministicMerge): any;
export declare class LegacyServiceUserParametersErrorOnNondeterministicMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersErrorOnNondeterministicMerge | undefined;
    set internalValue(value: LegacyServiceUserParametersErrorOnNondeterministicMerge | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersErrorOnNondeterministicMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersErrorOnNondeterministicMergeOutputReference;
}
export interface LegacyServiceUserParametersErrorOnNondeterministicUpdate {
}
export declare function legacyServiceUserParametersErrorOnNondeterministicUpdateToTerraform(struct?: LegacyServiceUserParametersErrorOnNondeterministicUpdate): any;
export declare function legacyServiceUserParametersErrorOnNondeterministicUpdateToHclTerraform(struct?: LegacyServiceUserParametersErrorOnNondeterministicUpdate): any;
export declare class LegacyServiceUserParametersErrorOnNondeterministicUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersErrorOnNondeterministicUpdate | undefined;
    set internalValue(value: LegacyServiceUserParametersErrorOnNondeterministicUpdate | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersErrorOnNondeterministicUpdateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersErrorOnNondeterministicUpdateOutputReference;
}
export interface LegacyServiceUserParametersGeographyOutputFormat {
}
export declare function legacyServiceUserParametersGeographyOutputFormatToTerraform(struct?: LegacyServiceUserParametersGeographyOutputFormat): any;
export declare function legacyServiceUserParametersGeographyOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersGeographyOutputFormat): any;
export declare class LegacyServiceUserParametersGeographyOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersGeographyOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersGeographyOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersGeographyOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersGeographyOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersGeometryOutputFormat {
}
export declare function legacyServiceUserParametersGeometryOutputFormatToTerraform(struct?: LegacyServiceUserParametersGeometryOutputFormat): any;
export declare function legacyServiceUserParametersGeometryOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersGeometryOutputFormat): any;
export declare class LegacyServiceUserParametersGeometryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersGeometryOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersGeometryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersGeometryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersGeometryOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersJdbcTreatDecimalAsInt {
}
export declare function legacyServiceUserParametersJdbcTreatDecimalAsIntToTerraform(struct?: LegacyServiceUserParametersJdbcTreatDecimalAsInt): any;
export declare function legacyServiceUserParametersJdbcTreatDecimalAsIntToHclTerraform(struct?: LegacyServiceUserParametersJdbcTreatDecimalAsInt): any;
export declare class LegacyServiceUserParametersJdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersJdbcTreatDecimalAsInt | undefined;
    set internalValue(value: LegacyServiceUserParametersJdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersJdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersJdbcTreatDecimalAsIntOutputReference;
}
export interface LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtc {
}
export declare function legacyServiceUserParametersJdbcTreatTimestampNtzAsUtcToTerraform(struct?: LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtc): any;
export declare function legacyServiceUserParametersJdbcTreatTimestampNtzAsUtcToHclTerraform(struct?: LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtc): any;
export declare class LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtc | undefined;
    set internalValue(value: LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtc | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtcOutputReference;
}
export interface LegacyServiceUserParametersJdbcUseSessionTimezone {
}
export declare function legacyServiceUserParametersJdbcUseSessionTimezoneToTerraform(struct?: LegacyServiceUserParametersJdbcUseSessionTimezone): any;
export declare function legacyServiceUserParametersJdbcUseSessionTimezoneToHclTerraform(struct?: LegacyServiceUserParametersJdbcUseSessionTimezone): any;
export declare class LegacyServiceUserParametersJdbcUseSessionTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersJdbcUseSessionTimezone | undefined;
    set internalValue(value: LegacyServiceUserParametersJdbcUseSessionTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersJdbcUseSessionTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersJdbcUseSessionTimezoneOutputReference;
}
export interface LegacyServiceUserParametersJsonIndent {
}
export declare function legacyServiceUserParametersJsonIndentToTerraform(struct?: LegacyServiceUserParametersJsonIndent): any;
export declare function legacyServiceUserParametersJsonIndentToHclTerraform(struct?: LegacyServiceUserParametersJsonIndent): any;
export declare class LegacyServiceUserParametersJsonIndentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersJsonIndent | undefined;
    set internalValue(value: LegacyServiceUserParametersJsonIndent | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersJsonIndentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersJsonIndentOutputReference;
}
export interface LegacyServiceUserParametersLockTimeout {
}
export declare function legacyServiceUserParametersLockTimeoutToTerraform(struct?: LegacyServiceUserParametersLockTimeout): any;
export declare function legacyServiceUserParametersLockTimeoutToHclTerraform(struct?: LegacyServiceUserParametersLockTimeout): any;
export declare class LegacyServiceUserParametersLockTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersLockTimeout | undefined;
    set internalValue(value: LegacyServiceUserParametersLockTimeout | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersLockTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersLockTimeoutOutputReference;
}
export interface LegacyServiceUserParametersLogLevel {
}
export declare function legacyServiceUserParametersLogLevelToTerraform(struct?: LegacyServiceUserParametersLogLevel): any;
export declare function legacyServiceUserParametersLogLevelToHclTerraform(struct?: LegacyServiceUserParametersLogLevel): any;
export declare class LegacyServiceUserParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersLogLevel | undefined;
    set internalValue(value: LegacyServiceUserParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersLogLevelOutputReference;
}
export interface LegacyServiceUserParametersMultiStatementCount {
}
export declare function legacyServiceUserParametersMultiStatementCountToTerraform(struct?: LegacyServiceUserParametersMultiStatementCount): any;
export declare function legacyServiceUserParametersMultiStatementCountToHclTerraform(struct?: LegacyServiceUserParametersMultiStatementCount): any;
export declare class LegacyServiceUserParametersMultiStatementCountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersMultiStatementCount | undefined;
    set internalValue(value: LegacyServiceUserParametersMultiStatementCount | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersMultiStatementCountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersMultiStatementCountOutputReference;
}
export interface LegacyServiceUserParametersNetworkPolicy {
}
export declare function legacyServiceUserParametersNetworkPolicyToTerraform(struct?: LegacyServiceUserParametersNetworkPolicy): any;
export declare function legacyServiceUserParametersNetworkPolicyToHclTerraform(struct?: LegacyServiceUserParametersNetworkPolicy): any;
export declare class LegacyServiceUserParametersNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersNetworkPolicy | undefined;
    set internalValue(value: LegacyServiceUserParametersNetworkPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersNetworkPolicyOutputReference;
}
export interface LegacyServiceUserParametersNoorderSequenceAsDefault {
}
export declare function legacyServiceUserParametersNoorderSequenceAsDefaultToTerraform(struct?: LegacyServiceUserParametersNoorderSequenceAsDefault): any;
export declare function legacyServiceUserParametersNoorderSequenceAsDefaultToHclTerraform(struct?: LegacyServiceUserParametersNoorderSequenceAsDefault): any;
export declare class LegacyServiceUserParametersNoorderSequenceAsDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersNoorderSequenceAsDefault | undefined;
    set internalValue(value: LegacyServiceUserParametersNoorderSequenceAsDefault | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersNoorderSequenceAsDefaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersNoorderSequenceAsDefaultOutputReference;
}
export interface LegacyServiceUserParametersOdbcTreatDecimalAsInt {
}
export declare function legacyServiceUserParametersOdbcTreatDecimalAsIntToTerraform(struct?: LegacyServiceUserParametersOdbcTreatDecimalAsInt): any;
export declare function legacyServiceUserParametersOdbcTreatDecimalAsIntToHclTerraform(struct?: LegacyServiceUserParametersOdbcTreatDecimalAsInt): any;
export declare class LegacyServiceUserParametersOdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersOdbcTreatDecimalAsInt | undefined;
    set internalValue(value: LegacyServiceUserParametersOdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersOdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersOdbcTreatDecimalAsIntOutputReference;
}
export interface LegacyServiceUserParametersPreventUnloadToInternalStages {
}
export declare function legacyServiceUserParametersPreventUnloadToInternalStagesToTerraform(struct?: LegacyServiceUserParametersPreventUnloadToInternalStages): any;
export declare function legacyServiceUserParametersPreventUnloadToInternalStagesToHclTerraform(struct?: LegacyServiceUserParametersPreventUnloadToInternalStages): any;
export declare class LegacyServiceUserParametersPreventUnloadToInternalStagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersPreventUnloadToInternalStages | undefined;
    set internalValue(value: LegacyServiceUserParametersPreventUnloadToInternalStages | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersPreventUnloadToInternalStagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersPreventUnloadToInternalStagesOutputReference;
}
export interface LegacyServiceUserParametersQueryTag {
}
export declare function legacyServiceUserParametersQueryTagToTerraform(struct?: LegacyServiceUserParametersQueryTag): any;
export declare function legacyServiceUserParametersQueryTagToHclTerraform(struct?: LegacyServiceUserParametersQueryTag): any;
export declare class LegacyServiceUserParametersQueryTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersQueryTag | undefined;
    set internalValue(value: LegacyServiceUserParametersQueryTag | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersQueryTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersQueryTagOutputReference;
}
export interface LegacyServiceUserParametersQuotedIdentifiersIgnoreCase {
}
export declare function legacyServiceUserParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: LegacyServiceUserParametersQuotedIdentifiersIgnoreCase): any;
export declare function legacyServiceUserParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: LegacyServiceUserParametersQuotedIdentifiersIgnoreCase): any;
export declare class LegacyServiceUserParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: LegacyServiceUserParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface LegacyServiceUserParametersRowsPerResultset {
}
export declare function legacyServiceUserParametersRowsPerResultsetToTerraform(struct?: LegacyServiceUserParametersRowsPerResultset): any;
export declare function legacyServiceUserParametersRowsPerResultsetToHclTerraform(struct?: LegacyServiceUserParametersRowsPerResultset): any;
export declare class LegacyServiceUserParametersRowsPerResultsetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersRowsPerResultset | undefined;
    set internalValue(value: LegacyServiceUserParametersRowsPerResultset | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersRowsPerResultsetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersRowsPerResultsetOutputReference;
}
export interface LegacyServiceUserParametersS3StageVpceDnsName {
}
export declare function legacyServiceUserParametersS3StageVpceDnsNameToTerraform(struct?: LegacyServiceUserParametersS3StageVpceDnsName): any;
export declare function legacyServiceUserParametersS3StageVpceDnsNameToHclTerraform(struct?: LegacyServiceUserParametersS3StageVpceDnsName): any;
export declare class LegacyServiceUserParametersS3StageVpceDnsNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersS3StageVpceDnsName | undefined;
    set internalValue(value: LegacyServiceUserParametersS3StageVpceDnsName | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersS3StageVpceDnsNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersS3StageVpceDnsNameOutputReference;
}
export interface LegacyServiceUserParametersSearchPath {
}
export declare function legacyServiceUserParametersSearchPathToTerraform(struct?: LegacyServiceUserParametersSearchPath): any;
export declare function legacyServiceUserParametersSearchPathToHclTerraform(struct?: LegacyServiceUserParametersSearchPath): any;
export declare class LegacyServiceUserParametersSearchPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersSearchPath | undefined;
    set internalValue(value: LegacyServiceUserParametersSearchPath | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersSearchPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersSearchPathOutputReference;
}
export interface LegacyServiceUserParametersSimulatedDataSharingConsumer {
}
export declare function legacyServiceUserParametersSimulatedDataSharingConsumerToTerraform(struct?: LegacyServiceUserParametersSimulatedDataSharingConsumer): any;
export declare function legacyServiceUserParametersSimulatedDataSharingConsumerToHclTerraform(struct?: LegacyServiceUserParametersSimulatedDataSharingConsumer): any;
export declare class LegacyServiceUserParametersSimulatedDataSharingConsumerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersSimulatedDataSharingConsumer | undefined;
    set internalValue(value: LegacyServiceUserParametersSimulatedDataSharingConsumer | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersSimulatedDataSharingConsumerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersSimulatedDataSharingConsumerOutputReference;
}
export interface LegacyServiceUserParametersStatementQueuedTimeoutInSeconds {
}
export declare function legacyServiceUserParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: LegacyServiceUserParametersStatementQueuedTimeoutInSeconds): any;
export declare function legacyServiceUserParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: LegacyServiceUserParametersStatementQueuedTimeoutInSeconds): any;
export declare class LegacyServiceUserParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: LegacyServiceUserParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface LegacyServiceUserParametersStatementTimeoutInSeconds {
}
export declare function legacyServiceUserParametersStatementTimeoutInSecondsToTerraform(struct?: LegacyServiceUserParametersStatementTimeoutInSeconds): any;
export declare function legacyServiceUserParametersStatementTimeoutInSecondsToHclTerraform(struct?: LegacyServiceUserParametersStatementTimeoutInSeconds): any;
export declare class LegacyServiceUserParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: LegacyServiceUserParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersStatementTimeoutInSecondsOutputReference;
}
export interface LegacyServiceUserParametersStrictJsonOutput {
}
export declare function legacyServiceUserParametersStrictJsonOutputToTerraform(struct?: LegacyServiceUserParametersStrictJsonOutput): any;
export declare function legacyServiceUserParametersStrictJsonOutputToHclTerraform(struct?: LegacyServiceUserParametersStrictJsonOutput): any;
export declare class LegacyServiceUserParametersStrictJsonOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersStrictJsonOutput | undefined;
    set internalValue(value: LegacyServiceUserParametersStrictJsonOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersStrictJsonOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersStrictJsonOutputOutputReference;
}
export interface LegacyServiceUserParametersTimeInputFormat {
}
export declare function legacyServiceUserParametersTimeInputFormatToTerraform(struct?: LegacyServiceUserParametersTimeInputFormat): any;
export declare function legacyServiceUserParametersTimeInputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimeInputFormat): any;
export declare class LegacyServiceUserParametersTimeInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimeInputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimeInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimeInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimeInputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimeOutputFormat {
}
export declare function legacyServiceUserParametersTimeOutputFormatToTerraform(struct?: LegacyServiceUserParametersTimeOutputFormat): any;
export declare function legacyServiceUserParametersTimeOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimeOutputFormat): any;
export declare class LegacyServiceUserParametersTimeOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimeOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimeOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimeOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimeOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimestampDayIsAlways24H {
}
export declare function legacyServiceUserParametersTimestampDayIsAlways24HToTerraform(struct?: LegacyServiceUserParametersTimestampDayIsAlways24H): any;
export declare function legacyServiceUserParametersTimestampDayIsAlways24HToHclTerraform(struct?: LegacyServiceUserParametersTimestampDayIsAlways24H): any;
export declare class LegacyServiceUserParametersTimestampDayIsAlways24HOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampDayIsAlways24H | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampDayIsAlways24H | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampDayIsAlways24HList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampDayIsAlways24HOutputReference;
}
export interface LegacyServiceUserParametersTimestampInputFormat {
}
export declare function legacyServiceUserParametersTimestampInputFormatToTerraform(struct?: LegacyServiceUserParametersTimestampInputFormat): any;
export declare function legacyServiceUserParametersTimestampInputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimestampInputFormat): any;
export declare class LegacyServiceUserParametersTimestampInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampInputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampInputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimestampLtzOutputFormat {
}
export declare function legacyServiceUserParametersTimestampLtzOutputFormatToTerraform(struct?: LegacyServiceUserParametersTimestampLtzOutputFormat): any;
export declare function legacyServiceUserParametersTimestampLtzOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimestampLtzOutputFormat): any;
export declare class LegacyServiceUserParametersTimestampLtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampLtzOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampLtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampLtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampLtzOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimestampNtzOutputFormat {
}
export declare function legacyServiceUserParametersTimestampNtzOutputFormatToTerraform(struct?: LegacyServiceUserParametersTimestampNtzOutputFormat): any;
export declare function legacyServiceUserParametersTimestampNtzOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimestampNtzOutputFormat): any;
export declare class LegacyServiceUserParametersTimestampNtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampNtzOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampNtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampNtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampNtzOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimestampOutputFormat {
}
export declare function legacyServiceUserParametersTimestampOutputFormatToTerraform(struct?: LegacyServiceUserParametersTimestampOutputFormat): any;
export declare function legacyServiceUserParametersTimestampOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimestampOutputFormat): any;
export declare class LegacyServiceUserParametersTimestampOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimestampTypeMapping {
}
export declare function legacyServiceUserParametersTimestampTypeMappingToTerraform(struct?: LegacyServiceUserParametersTimestampTypeMapping): any;
export declare function legacyServiceUserParametersTimestampTypeMappingToHclTerraform(struct?: LegacyServiceUserParametersTimestampTypeMapping): any;
export declare class LegacyServiceUserParametersTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampTypeMapping | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampTypeMappingOutputReference;
}
export interface LegacyServiceUserParametersTimestampTzOutputFormat {
}
export declare function legacyServiceUserParametersTimestampTzOutputFormatToTerraform(struct?: LegacyServiceUserParametersTimestampTzOutputFormat): any;
export declare function legacyServiceUserParametersTimestampTzOutputFormatToHclTerraform(struct?: LegacyServiceUserParametersTimestampTzOutputFormat): any;
export declare class LegacyServiceUserParametersTimestampTzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimestampTzOutputFormat | undefined;
    set internalValue(value: LegacyServiceUserParametersTimestampTzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimestampTzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimestampTzOutputFormatOutputReference;
}
export interface LegacyServiceUserParametersTimezone {
}
export declare function legacyServiceUserParametersTimezoneToTerraform(struct?: LegacyServiceUserParametersTimezone): any;
export declare function legacyServiceUserParametersTimezoneToHclTerraform(struct?: LegacyServiceUserParametersTimezone): any;
export declare class LegacyServiceUserParametersTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTimezone | undefined;
    set internalValue(value: LegacyServiceUserParametersTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTimezoneOutputReference;
}
export interface LegacyServiceUserParametersTraceLevel {
}
export declare function legacyServiceUserParametersTraceLevelToTerraform(struct?: LegacyServiceUserParametersTraceLevel): any;
export declare function legacyServiceUserParametersTraceLevelToHclTerraform(struct?: LegacyServiceUserParametersTraceLevel): any;
export declare class LegacyServiceUserParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTraceLevel | undefined;
    set internalValue(value: LegacyServiceUserParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTraceLevelOutputReference;
}
export interface LegacyServiceUserParametersTransactionAbortOnError {
}
export declare function legacyServiceUserParametersTransactionAbortOnErrorToTerraform(struct?: LegacyServiceUserParametersTransactionAbortOnError): any;
export declare function legacyServiceUserParametersTransactionAbortOnErrorToHclTerraform(struct?: LegacyServiceUserParametersTransactionAbortOnError): any;
export declare class LegacyServiceUserParametersTransactionAbortOnErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTransactionAbortOnError | undefined;
    set internalValue(value: LegacyServiceUserParametersTransactionAbortOnError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTransactionAbortOnErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTransactionAbortOnErrorOutputReference;
}
export interface LegacyServiceUserParametersTransactionDefaultIsolationLevel {
}
export declare function legacyServiceUserParametersTransactionDefaultIsolationLevelToTerraform(struct?: LegacyServiceUserParametersTransactionDefaultIsolationLevel): any;
export declare function legacyServiceUserParametersTransactionDefaultIsolationLevelToHclTerraform(struct?: LegacyServiceUserParametersTransactionDefaultIsolationLevel): any;
export declare class LegacyServiceUserParametersTransactionDefaultIsolationLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTransactionDefaultIsolationLevel | undefined;
    set internalValue(value: LegacyServiceUserParametersTransactionDefaultIsolationLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTransactionDefaultIsolationLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTransactionDefaultIsolationLevelOutputReference;
}
export interface LegacyServiceUserParametersTwoDigitCenturyStart {
}
export declare function legacyServiceUserParametersTwoDigitCenturyStartToTerraform(struct?: LegacyServiceUserParametersTwoDigitCenturyStart): any;
export declare function legacyServiceUserParametersTwoDigitCenturyStartToHclTerraform(struct?: LegacyServiceUserParametersTwoDigitCenturyStart): any;
export declare class LegacyServiceUserParametersTwoDigitCenturyStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersTwoDigitCenturyStart | undefined;
    set internalValue(value: LegacyServiceUserParametersTwoDigitCenturyStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersTwoDigitCenturyStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersTwoDigitCenturyStartOutputReference;
}
export interface LegacyServiceUserParametersUnsupportedDdlAction {
}
export declare function legacyServiceUserParametersUnsupportedDdlActionToTerraform(struct?: LegacyServiceUserParametersUnsupportedDdlAction): any;
export declare function legacyServiceUserParametersUnsupportedDdlActionToHclTerraform(struct?: LegacyServiceUserParametersUnsupportedDdlAction): any;
export declare class LegacyServiceUserParametersUnsupportedDdlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersUnsupportedDdlAction | undefined;
    set internalValue(value: LegacyServiceUserParametersUnsupportedDdlAction | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersUnsupportedDdlActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersUnsupportedDdlActionOutputReference;
}
export interface LegacyServiceUserParametersUseCachedResult {
}
export declare function legacyServiceUserParametersUseCachedResultToTerraform(struct?: LegacyServiceUserParametersUseCachedResult): any;
export declare function legacyServiceUserParametersUseCachedResultToHclTerraform(struct?: LegacyServiceUserParametersUseCachedResult): any;
export declare class LegacyServiceUserParametersUseCachedResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersUseCachedResult | undefined;
    set internalValue(value: LegacyServiceUserParametersUseCachedResult | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersUseCachedResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersUseCachedResultOutputReference;
}
export interface LegacyServiceUserParametersWeekOfYearPolicy {
}
export declare function legacyServiceUserParametersWeekOfYearPolicyToTerraform(struct?: LegacyServiceUserParametersWeekOfYearPolicy): any;
export declare function legacyServiceUserParametersWeekOfYearPolicyToHclTerraform(struct?: LegacyServiceUserParametersWeekOfYearPolicy): any;
export declare class LegacyServiceUserParametersWeekOfYearPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersWeekOfYearPolicy | undefined;
    set internalValue(value: LegacyServiceUserParametersWeekOfYearPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersWeekOfYearPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersWeekOfYearPolicyOutputReference;
}
export interface LegacyServiceUserParametersWeekStart {
}
export declare function legacyServiceUserParametersWeekStartToTerraform(struct?: LegacyServiceUserParametersWeekStart): any;
export declare function legacyServiceUserParametersWeekStartToHclTerraform(struct?: LegacyServiceUserParametersWeekStart): any;
export declare class LegacyServiceUserParametersWeekStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParametersWeekStart | undefined;
    set internalValue(value: LegacyServiceUserParametersWeekStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class LegacyServiceUserParametersWeekStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersWeekStartOutputReference;
}
export interface LegacyServiceUserParameters {
}
export declare function legacyServiceUserParametersToTerraform(struct?: LegacyServiceUserParameters): any;
export declare function legacyServiceUserParametersToHclTerraform(struct?: LegacyServiceUserParameters): any;
export declare class LegacyServiceUserParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserParameters | undefined;
    set internalValue(value: LegacyServiceUserParameters | undefined);
    private _abortDetachedQuery;
    get abortDetachedQuery(): LegacyServiceUserParametersAbortDetachedQueryList;
    private _autocommit;
    get autocommit(): LegacyServiceUserParametersAutocommitList;
    private _binaryInputFormat;
    get binaryInputFormat(): LegacyServiceUserParametersBinaryInputFormatList;
    private _binaryOutputFormat;
    get binaryOutputFormat(): LegacyServiceUserParametersBinaryOutputFormatList;
    private _clientMemoryLimit;
    get clientMemoryLimit(): LegacyServiceUserParametersClientMemoryLimitList;
    private _clientMetadataRequestUseConnectionCtx;
    get clientMetadataRequestUseConnectionCtx(): LegacyServiceUserParametersClientMetadataRequestUseConnectionCtxList;
    private _clientPrefetchThreads;
    get clientPrefetchThreads(): LegacyServiceUserParametersClientPrefetchThreadsList;
    private _clientResultChunkSize;
    get clientResultChunkSize(): LegacyServiceUserParametersClientResultChunkSizeList;
    private _clientResultColumnCaseInsensitive;
    get clientResultColumnCaseInsensitive(): LegacyServiceUserParametersClientResultColumnCaseInsensitiveList;
    private _clientSessionKeepAlive;
    get clientSessionKeepAlive(): LegacyServiceUserParametersClientSessionKeepAliveList;
    private _clientSessionKeepAliveHeartbeatFrequency;
    get clientSessionKeepAliveHeartbeatFrequency(): LegacyServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyList;
    private _clientTimestampTypeMapping;
    get clientTimestampTypeMapping(): LegacyServiceUserParametersClientTimestampTypeMappingList;
    private _dateInputFormat;
    get dateInputFormat(): LegacyServiceUserParametersDateInputFormatList;
    private _dateOutputFormat;
    get dateOutputFormat(): LegacyServiceUserParametersDateOutputFormatList;
    private _enableUnloadPhysicalTypeOptimization;
    get enableUnloadPhysicalTypeOptimization(): LegacyServiceUserParametersEnableUnloadPhysicalTypeOptimizationList;
    private _enableUnredactedQuerySyntaxError;
    get enableUnredactedQuerySyntaxError(): LegacyServiceUserParametersEnableUnredactedQuerySyntaxErrorList;
    private _errorOnNondeterministicMerge;
    get errorOnNondeterministicMerge(): LegacyServiceUserParametersErrorOnNondeterministicMergeList;
    private _errorOnNondeterministicUpdate;
    get errorOnNondeterministicUpdate(): LegacyServiceUserParametersErrorOnNondeterministicUpdateList;
    private _geographyOutputFormat;
    get geographyOutputFormat(): LegacyServiceUserParametersGeographyOutputFormatList;
    private _geometryOutputFormat;
    get geometryOutputFormat(): LegacyServiceUserParametersGeometryOutputFormatList;
    private _jdbcTreatDecimalAsInt;
    get jdbcTreatDecimalAsInt(): LegacyServiceUserParametersJdbcTreatDecimalAsIntList;
    private _jdbcTreatTimestampNtzAsUtc;
    get jdbcTreatTimestampNtzAsUtc(): LegacyServiceUserParametersJdbcTreatTimestampNtzAsUtcList;
    private _jdbcUseSessionTimezone;
    get jdbcUseSessionTimezone(): LegacyServiceUserParametersJdbcUseSessionTimezoneList;
    private _jsonIndent;
    get jsonIndent(): LegacyServiceUserParametersJsonIndentList;
    private _lockTimeout;
    get lockTimeout(): LegacyServiceUserParametersLockTimeoutList;
    private _logLevel;
    get logLevel(): LegacyServiceUserParametersLogLevelList;
    private _multiStatementCount;
    get multiStatementCount(): LegacyServiceUserParametersMultiStatementCountList;
    private _networkPolicy;
    get networkPolicy(): LegacyServiceUserParametersNetworkPolicyList;
    private _noorderSequenceAsDefault;
    get noorderSequenceAsDefault(): LegacyServiceUserParametersNoorderSequenceAsDefaultList;
    private _odbcTreatDecimalAsInt;
    get odbcTreatDecimalAsInt(): LegacyServiceUserParametersOdbcTreatDecimalAsIntList;
    private _preventUnloadToInternalStages;
    get preventUnloadToInternalStages(): LegacyServiceUserParametersPreventUnloadToInternalStagesList;
    private _queryTag;
    get queryTag(): LegacyServiceUserParametersQueryTagList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): LegacyServiceUserParametersQuotedIdentifiersIgnoreCaseList;
    private _rowsPerResultset;
    get rowsPerResultset(): LegacyServiceUserParametersRowsPerResultsetList;
    private _s3StageVpceDnsName;
    get s3StageVpceDnsName(): LegacyServiceUserParametersS3StageVpceDnsNameList;
    private _searchPath;
    get searchPath(): LegacyServiceUserParametersSearchPathList;
    private _simulatedDataSharingConsumer;
    get simulatedDataSharingConsumer(): LegacyServiceUserParametersSimulatedDataSharingConsumerList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): LegacyServiceUserParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): LegacyServiceUserParametersStatementTimeoutInSecondsList;
    private _strictJsonOutput;
    get strictJsonOutput(): LegacyServiceUserParametersStrictJsonOutputList;
    private _timeInputFormat;
    get timeInputFormat(): LegacyServiceUserParametersTimeInputFormatList;
    private _timeOutputFormat;
    get timeOutputFormat(): LegacyServiceUserParametersTimeOutputFormatList;
    private _timestampDayIsAlways24H;
    get timestampDayIsAlways24H(): LegacyServiceUserParametersTimestampDayIsAlways24HList;
    private _timestampInputFormat;
    get timestampInputFormat(): LegacyServiceUserParametersTimestampInputFormatList;
    private _timestampLtzOutputFormat;
    get timestampLtzOutputFormat(): LegacyServiceUserParametersTimestampLtzOutputFormatList;
    private _timestampNtzOutputFormat;
    get timestampNtzOutputFormat(): LegacyServiceUserParametersTimestampNtzOutputFormatList;
    private _timestampOutputFormat;
    get timestampOutputFormat(): LegacyServiceUserParametersTimestampOutputFormatList;
    private _timestampTypeMapping;
    get timestampTypeMapping(): LegacyServiceUserParametersTimestampTypeMappingList;
    private _timestampTzOutputFormat;
    get timestampTzOutputFormat(): LegacyServiceUserParametersTimestampTzOutputFormatList;
    private _timezone;
    get timezone(): LegacyServiceUserParametersTimezoneList;
    private _traceLevel;
    get traceLevel(): LegacyServiceUserParametersTraceLevelList;
    private _transactionAbortOnError;
    get transactionAbortOnError(): LegacyServiceUserParametersTransactionAbortOnErrorList;
    private _transactionDefaultIsolationLevel;
    get transactionDefaultIsolationLevel(): LegacyServiceUserParametersTransactionDefaultIsolationLevelList;
    private _twoDigitCenturyStart;
    get twoDigitCenturyStart(): LegacyServiceUserParametersTwoDigitCenturyStartList;
    private _unsupportedDdlAction;
    get unsupportedDdlAction(): LegacyServiceUserParametersUnsupportedDdlActionList;
    private _useCachedResult;
    get useCachedResult(): LegacyServiceUserParametersUseCachedResultList;
    private _weekOfYearPolicy;
    get weekOfYearPolicy(): LegacyServiceUserParametersWeekOfYearPolicyList;
    private _weekStart;
    get weekStart(): LegacyServiceUserParametersWeekStartList;
}
export declare class LegacyServiceUserParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserParametersOutputReference;
}
export interface LegacyServiceUserShowOutput {
}
export declare function legacyServiceUserShowOutputToTerraform(struct?: LegacyServiceUserShowOutput): any;
export declare function legacyServiceUserShowOutputToHclTerraform(struct?: LegacyServiceUserShowOutput): any;
export declare class LegacyServiceUserShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LegacyServiceUserShowOutput | undefined;
    set internalValue(value: LegacyServiceUserShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get daysToExpiry(): string;
    get defaultNamespace(): string;
    get defaultRole(): string;
    get defaultSecondaryRoles(): string;
    get defaultWarehouse(): string;
    get disabled(): cdktf.IResolvable;
    get displayName(): string;
    get email(): string;
    get expiresAtTime(): string;
    get extAuthnDuo(): cdktf.IResolvable;
    get extAuthnUid(): string;
    get firstName(): string;
    get hasMfa(): cdktf.IResolvable;
    get hasPassword(): cdktf.IResolvable;
    get hasRsaPublicKey(): cdktf.IResolvable;
    get lastName(): string;
    get lastSuccessLogin(): string;
    get lockedUntilTime(): string;
    get loginName(): string;
    get minsToBypassMfa(): string;
    get minsToUnlock(): string;
    get mustChangePassword(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
    get snowflakeLock(): cdktf.IResolvable;
    get type(): string;
}
export declare class LegacyServiceUserShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LegacyServiceUserShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user snowflake_legacy_service_user}
*/
export declare class LegacyServiceUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_legacy_service_user";
    /**
    * Generates CDKTF code for importing a LegacyServiceUser resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LegacyServiceUser to import
    * @param importFromId The id of the existing LegacyServiceUser that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LegacyServiceUser to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/legacy_service_user snowflake_legacy_service_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LegacyServiceUserConfig
    */
    constructor(scope: Construct, id: string, config: LegacyServiceUserConfig);
    private _abortDetachedQuery?;
    get abortDetachedQuery(): boolean | cdktf.IResolvable;
    set abortDetachedQuery(value: boolean | cdktf.IResolvable);
    resetAbortDetachedQuery(): void;
    get abortDetachedQueryInput(): boolean | cdktf.IResolvable | undefined;
    private _autocommit?;
    get autocommit(): boolean | cdktf.IResolvable;
    set autocommit(value: boolean | cdktf.IResolvable);
    resetAutocommit(): void;
    get autocommitInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryInputFormat?;
    get binaryInputFormat(): string;
    set binaryInputFormat(value: string);
    resetBinaryInputFormat(): void;
    get binaryInputFormatInput(): string | undefined;
    private _binaryOutputFormat?;
    get binaryOutputFormat(): string;
    set binaryOutputFormat(value: string);
    resetBinaryOutputFormat(): void;
    get binaryOutputFormatInput(): string | undefined;
    private _clientMemoryLimit?;
    get clientMemoryLimit(): number;
    set clientMemoryLimit(value: number);
    resetClientMemoryLimit(): void;
    get clientMemoryLimitInput(): number | undefined;
    private _clientMetadataRequestUseConnectionCtx?;
    get clientMetadataRequestUseConnectionCtx(): boolean | cdktf.IResolvable;
    set clientMetadataRequestUseConnectionCtx(value: boolean | cdktf.IResolvable);
    resetClientMetadataRequestUseConnectionCtx(): void;
    get clientMetadataRequestUseConnectionCtxInput(): boolean | cdktf.IResolvable | undefined;
    private _clientPrefetchThreads?;
    get clientPrefetchThreads(): number;
    set clientPrefetchThreads(value: number);
    resetClientPrefetchThreads(): void;
    get clientPrefetchThreadsInput(): number | undefined;
    private _clientResultChunkSize?;
    get clientResultChunkSize(): number;
    set clientResultChunkSize(value: number);
    resetClientResultChunkSize(): void;
    get clientResultChunkSizeInput(): number | undefined;
    private _clientResultColumnCaseInsensitive?;
    get clientResultColumnCaseInsensitive(): boolean | cdktf.IResolvable;
    set clientResultColumnCaseInsensitive(value: boolean | cdktf.IResolvable);
    resetClientResultColumnCaseInsensitive(): void;
    get clientResultColumnCaseInsensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAlive?;
    get clientSessionKeepAlive(): boolean | cdktf.IResolvable;
    set clientSessionKeepAlive(value: boolean | cdktf.IResolvable);
    resetClientSessionKeepAlive(): void;
    get clientSessionKeepAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAliveHeartbeatFrequency?;
    get clientSessionKeepAliveHeartbeatFrequency(): number;
    set clientSessionKeepAliveHeartbeatFrequency(value: number);
    resetClientSessionKeepAliveHeartbeatFrequency(): void;
    get clientSessionKeepAliveHeartbeatFrequencyInput(): number | undefined;
    private _clientTimestampTypeMapping?;
    get clientTimestampTypeMapping(): string;
    set clientTimestampTypeMapping(value: string);
    resetClientTimestampTypeMapping(): void;
    get clientTimestampTypeMappingInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dateInputFormat?;
    get dateInputFormat(): string;
    set dateInputFormat(value: string);
    resetDateInputFormat(): void;
    get dateInputFormatInput(): string | undefined;
    private _dateOutputFormat?;
    get dateOutputFormat(): string;
    set dateOutputFormat(value: string);
    resetDateOutputFormat(): void;
    get dateOutputFormatInput(): string | undefined;
    private _daysToExpiry?;
    get daysToExpiry(): number;
    set daysToExpiry(value: number);
    resetDaysToExpiry(): void;
    get daysToExpiryInput(): number | undefined;
    private _defaultNamespace?;
    get defaultNamespace(): string;
    set defaultNamespace(value: string);
    resetDefaultNamespace(): void;
    get defaultNamespaceInput(): string | undefined;
    private _defaultRole?;
    get defaultRole(): string;
    set defaultRole(value: string);
    resetDefaultRole(): void;
    get defaultRoleInput(): string | undefined;
    private _defaultSecondaryRolesOption?;
    get defaultSecondaryRolesOption(): string;
    set defaultSecondaryRolesOption(value: string);
    resetDefaultSecondaryRolesOption(): void;
    get defaultSecondaryRolesOptionInput(): string | undefined;
    private _defaultWarehouse?;
    get defaultWarehouse(): string;
    set defaultWarehouse(value: string);
    resetDefaultWarehouse(): void;
    get defaultWarehouseInput(): string | undefined;
    private _disabled?;
    get disabled(): string;
    set disabled(value: string);
    resetDisabled(): void;
    get disabledInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _enableUnloadPhysicalTypeOptimization?;
    get enableUnloadPhysicalTypeOptimization(): boolean | cdktf.IResolvable;
    set enableUnloadPhysicalTypeOptimization(value: boolean | cdktf.IResolvable);
    resetEnableUnloadPhysicalTypeOptimization(): void;
    get enableUnloadPhysicalTypeOptimizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableUnredactedQuerySyntaxError?;
    get enableUnredactedQuerySyntaxError(): boolean | cdktf.IResolvable;
    set enableUnredactedQuerySyntaxError(value: boolean | cdktf.IResolvable);
    resetEnableUnredactedQuerySyntaxError(): void;
    get enableUnredactedQuerySyntaxErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicMerge?;
    get errorOnNondeterministicMerge(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicMerge(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicMerge(): void;
    get errorOnNondeterministicMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicUpdate?;
    get errorOnNondeterministicUpdate(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicUpdate(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicUpdate(): void;
    get errorOnNondeterministicUpdateInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _geographyOutputFormat?;
    get geographyOutputFormat(): string;
    set geographyOutputFormat(value: string);
    resetGeographyOutputFormat(): void;
    get geographyOutputFormatInput(): string | undefined;
    private _geometryOutputFormat?;
    get geometryOutputFormat(): string;
    set geometryOutputFormat(value: string);
    resetGeometryOutputFormat(): void;
    get geometryOutputFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jdbcTreatDecimalAsInt?;
    get jdbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set jdbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetJdbcTreatDecimalAsInt(): void;
    get jdbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcTreatTimestampNtzAsUtc?;
    get jdbcTreatTimestampNtzAsUtc(): boolean | cdktf.IResolvable;
    set jdbcTreatTimestampNtzAsUtc(value: boolean | cdktf.IResolvable);
    resetJdbcTreatTimestampNtzAsUtc(): void;
    get jdbcTreatTimestampNtzAsUtcInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcUseSessionTimezone?;
    get jdbcUseSessionTimezone(): boolean | cdktf.IResolvable;
    set jdbcUseSessionTimezone(value: boolean | cdktf.IResolvable);
    resetJdbcUseSessionTimezone(): void;
    get jdbcUseSessionTimezoneInput(): boolean | cdktf.IResolvable | undefined;
    private _jsonIndent?;
    get jsonIndent(): number;
    set jsonIndent(value: number);
    resetJsonIndent(): void;
    get jsonIndentInput(): number | undefined;
    private _lockTimeout?;
    get lockTimeout(): number;
    set lockTimeout(value: number);
    resetLockTimeout(): void;
    get lockTimeoutInput(): number | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _loginName?;
    get loginName(): string;
    set loginName(value: string);
    resetLoginName(): void;
    get loginNameInput(): string | undefined;
    private _minsToUnlock?;
    get minsToUnlock(): number;
    set minsToUnlock(value: number);
    resetMinsToUnlock(): void;
    get minsToUnlockInput(): number | undefined;
    private _multiStatementCount?;
    get multiStatementCount(): number;
    set multiStatementCount(value: number);
    resetMultiStatementCount(): void;
    get multiStatementCountInput(): number | undefined;
    private _mustChangePassword?;
    get mustChangePassword(): string;
    set mustChangePassword(value: string);
    resetMustChangePassword(): void;
    get mustChangePasswordInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _noorderSequenceAsDefault?;
    get noorderSequenceAsDefault(): boolean | cdktf.IResolvable;
    set noorderSequenceAsDefault(value: boolean | cdktf.IResolvable);
    resetNoorderSequenceAsDefault(): void;
    get noorderSequenceAsDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _odbcTreatDecimalAsInt?;
    get odbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set odbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetOdbcTreatDecimalAsInt(): void;
    get odbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _parameters;
    get parameters(): LegacyServiceUserParametersList;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _preventUnloadToInternalStages?;
    get preventUnloadToInternalStages(): boolean | cdktf.IResolvable;
    set preventUnloadToInternalStages(value: boolean | cdktf.IResolvable);
    resetPreventUnloadToInternalStages(): void;
    get preventUnloadToInternalStagesInput(): boolean | cdktf.IResolvable | undefined;
    private _queryTag?;
    get queryTag(): string;
    set queryTag(value: string);
    resetQueryTag(): void;
    get queryTagInput(): string | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _rowsPerResultset?;
    get rowsPerResultset(): number;
    set rowsPerResultset(value: number);
    resetRowsPerResultset(): void;
    get rowsPerResultsetInput(): number | undefined;
    private _rsaPublicKey?;
    get rsaPublicKey(): string;
    set rsaPublicKey(value: string);
    resetRsaPublicKey(): void;
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    get rsaPublicKey2(): string;
    set rsaPublicKey2(value: string);
    resetRsaPublicKey2(): void;
    get rsaPublicKey2Input(): string | undefined;
    private _s3StageVpceDnsName?;
    get s3StageVpceDnsName(): string;
    set s3StageVpceDnsName(value: string);
    resetS3StageVpceDnsName(): void;
    get s3StageVpceDnsNameInput(): string | undefined;
    private _searchPath?;
    get searchPath(): string;
    set searchPath(value: string);
    resetSearchPath(): void;
    get searchPathInput(): string | undefined;
    private _showOutput;
    get showOutput(): LegacyServiceUserShowOutputList;
    private _simulatedDataSharingConsumer?;
    get simulatedDataSharingConsumer(): string;
    set simulatedDataSharingConsumer(value: string);
    resetSimulatedDataSharingConsumer(): void;
    get simulatedDataSharingConsumerInput(): string | undefined;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _strictJsonOutput?;
    get strictJsonOutput(): boolean | cdktf.IResolvable;
    set strictJsonOutput(value: boolean | cdktf.IResolvable);
    resetStrictJsonOutput(): void;
    get strictJsonOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _timeInputFormat?;
    get timeInputFormat(): string;
    set timeInputFormat(value: string);
    resetTimeInputFormat(): void;
    get timeInputFormatInput(): string | undefined;
    private _timeOutputFormat?;
    get timeOutputFormat(): string;
    set timeOutputFormat(value: string);
    resetTimeOutputFormat(): void;
    get timeOutputFormatInput(): string | undefined;
    private _timestampDayIsAlways24H?;
    get timestampDayIsAlways24H(): boolean | cdktf.IResolvable;
    set timestampDayIsAlways24H(value: boolean | cdktf.IResolvable);
    resetTimestampDayIsAlways24H(): void;
    get timestampDayIsAlways24HInput(): boolean | cdktf.IResolvable | undefined;
    private _timestampInputFormat?;
    get timestampInputFormat(): string;
    set timestampInputFormat(value: string);
    resetTimestampInputFormat(): void;
    get timestampInputFormatInput(): string | undefined;
    private _timestampLtzOutputFormat?;
    get timestampLtzOutputFormat(): string;
    set timestampLtzOutputFormat(value: string);
    resetTimestampLtzOutputFormat(): void;
    get timestampLtzOutputFormatInput(): string | undefined;
    private _timestampNtzOutputFormat?;
    get timestampNtzOutputFormat(): string;
    set timestampNtzOutputFormat(value: string);
    resetTimestampNtzOutputFormat(): void;
    get timestampNtzOutputFormatInput(): string | undefined;
    private _timestampOutputFormat?;
    get timestampOutputFormat(): string;
    set timestampOutputFormat(value: string);
    resetTimestampOutputFormat(): void;
    get timestampOutputFormatInput(): string | undefined;
    private _timestampTypeMapping?;
    get timestampTypeMapping(): string;
    set timestampTypeMapping(value: string);
    resetTimestampTypeMapping(): void;
    get timestampTypeMappingInput(): string | undefined;
    private _timestampTzOutputFormat?;
    get timestampTzOutputFormat(): string;
    set timestampTzOutputFormat(value: string);
    resetTimestampTzOutputFormat(): void;
    get timestampTzOutputFormatInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _transactionAbortOnError?;
    get transactionAbortOnError(): boolean | cdktf.IResolvable;
    set transactionAbortOnError(value: boolean | cdktf.IResolvable);
    resetTransactionAbortOnError(): void;
    get transactionAbortOnErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _transactionDefaultIsolationLevel?;
    get transactionDefaultIsolationLevel(): string;
    set transactionDefaultIsolationLevel(value: string);
    resetTransactionDefaultIsolationLevel(): void;
    get transactionDefaultIsolationLevelInput(): string | undefined;
    private _twoDigitCenturyStart?;
    get twoDigitCenturyStart(): number;
    set twoDigitCenturyStart(value: number);
    resetTwoDigitCenturyStart(): void;
    get twoDigitCenturyStartInput(): number | undefined;
    private _unsupportedDdlAction?;
    get unsupportedDdlAction(): string;
    set unsupportedDdlAction(value: string);
    resetUnsupportedDdlAction(): void;
    get unsupportedDdlActionInput(): string | undefined;
    private _useCachedResult?;
    get useCachedResult(): boolean | cdktf.IResolvable;
    set useCachedResult(value: boolean | cdktf.IResolvable);
    resetUseCachedResult(): void;
    get useCachedResultInput(): boolean | cdktf.IResolvable | undefined;
    get userType(): string;
    private _weekOfYearPolicy?;
    get weekOfYearPolicy(): number;
    set weekOfYearPolicy(value: number);
    resetWeekOfYearPolicy(): void;
    get weekOfYearPolicyInput(): number | undefined;
    private _weekStart?;
    get weekStart(): number;
    set weekStart(value: number);
    resetWeekStart(): void;
    get weekStartInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
