"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecondaryDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/secondary_database snowflake_secondary_database}
*/
class SecondaryDatabase extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a SecondaryDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecondaryDatabase to import
    * @param importFromId The id of the existing SecondaryDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/secondary_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecondaryDatabase to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake_secondary_database", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.99.0/docs/resources/secondary_database snowflake_secondary_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecondaryDatabaseConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_secondary_database',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.99.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._asReplicaOf = config.asReplicaOf;
        this._catalog = config.catalog;
        this._comment = config.comment;
        this._dataRetentionTimeInDays = config.dataRetentionTimeInDays;
        this._defaultDdlCollation = config.defaultDdlCollation;
        this._enableConsoleOutput = config.enableConsoleOutput;
        this._externalVolume = config.externalVolume;
        this._id = config.id;
        this._isTransient = config.isTransient;
        this._logLevel = config.logLevel;
        this._maxDataExtensionTimeInDays = config.maxDataExtensionTimeInDays;
        this._name = config.name;
        this._quotedIdentifiersIgnoreCase = config.quotedIdentifiersIgnoreCase;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._storageSerializationPolicy = config.storageSerializationPolicy;
        this._suspendTaskAfterNumFailures = config.suspendTaskAfterNumFailures;
        this._taskAutoRetryAttempts = config.taskAutoRetryAttempts;
        this._traceLevel = config.traceLevel;
        this._userTaskManagedInitialWarehouseSize = config.userTaskManagedInitialWarehouseSize;
        this._userTaskMinimumTriggerIntervalInSeconds = config.userTaskMinimumTriggerIntervalInSeconds;
        this._userTaskTimeoutMs = config.userTaskTimeoutMs;
    }
    get asReplicaOf() {
        return this.getStringAttribute('as_replica_of');
    }
    set asReplicaOf(value) {
        this._asReplicaOf = value;
    }
    // Temporarily expose input value. Use with caution.
    get asReplicaOfInput() {
        return this._asReplicaOf;
    }
    get catalog() {
        return this.getStringAttribute('catalog');
    }
    set catalog(value) {
        this._catalog = value;
    }
    resetCatalog() {
        this._catalog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get catalogInput() {
        return this._catalog;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get dataRetentionTimeInDays() {
        return this.getNumberAttribute('data_retention_time_in_days');
    }
    set dataRetentionTimeInDays(value) {
        this._dataRetentionTimeInDays = value;
    }
    resetDataRetentionTimeInDays() {
        this._dataRetentionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataRetentionTimeInDaysInput() {
        return this._dataRetentionTimeInDays;
    }
    get defaultDdlCollation() {
        return this.getStringAttribute('default_ddl_collation');
    }
    set defaultDdlCollation(value) {
        this._defaultDdlCollation = value;
    }
    resetDefaultDdlCollation() {
        this._defaultDdlCollation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultDdlCollationInput() {
        return this._defaultDdlCollation;
    }
    get enableConsoleOutput() {
        return this.getBooleanAttribute('enable_console_output');
    }
    set enableConsoleOutput(value) {
        this._enableConsoleOutput = value;
    }
    resetEnableConsoleOutput() {
        this._enableConsoleOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableConsoleOutputInput() {
        return this._enableConsoleOutput;
    }
    get externalVolume() {
        return this.getStringAttribute('external_volume');
    }
    set externalVolume(value) {
        this._externalVolume = value;
    }
    resetExternalVolume() {
        this._externalVolume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalVolumeInput() {
        return this._externalVolume;
    }
    // fully_qualified_name - computed: true, optional: false, required: false
    get fullyQualifiedName() {
        return this.getStringAttribute('fully_qualified_name');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get isTransient() {
        return this.getBooleanAttribute('is_transient');
    }
    set isTransient(value) {
        this._isTransient = value;
    }
    resetIsTransient() {
        this._isTransient = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isTransientInput() {
        return this._isTransient;
    }
    get logLevel() {
        return this.getStringAttribute('log_level');
    }
    set logLevel(value) {
        this._logLevel = value;
    }
    resetLogLevel() {
        this._logLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logLevelInput() {
        return this._logLevel;
    }
    get maxDataExtensionTimeInDays() {
        return this.getNumberAttribute('max_data_extension_time_in_days');
    }
    set maxDataExtensionTimeInDays(value) {
        this._maxDataExtensionTimeInDays = value;
    }
    resetMaxDataExtensionTimeInDays() {
        this._maxDataExtensionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxDataExtensionTimeInDaysInput() {
        return this._maxDataExtensionTimeInDays;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get quotedIdentifiersIgnoreCase() {
        return this.getBooleanAttribute('quoted_identifiers_ignore_case');
    }
    set quotedIdentifiersIgnoreCase(value) {
        this._quotedIdentifiersIgnoreCase = value;
    }
    resetQuotedIdentifiersIgnoreCase() {
        this._quotedIdentifiersIgnoreCase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get quotedIdentifiersIgnoreCaseInput() {
        return this._quotedIdentifiersIgnoreCase;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get storageSerializationPolicy() {
        return this.getStringAttribute('storage_serialization_policy');
    }
    set storageSerializationPolicy(value) {
        this._storageSerializationPolicy = value;
    }
    resetStorageSerializationPolicy() {
        this._storageSerializationPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageSerializationPolicyInput() {
        return this._storageSerializationPolicy;
    }
    get suspendTaskAfterNumFailures() {
        return this.getNumberAttribute('suspend_task_after_num_failures');
    }
    set suspendTaskAfterNumFailures(value) {
        this._suspendTaskAfterNumFailures = value;
    }
    resetSuspendTaskAfterNumFailures() {
        this._suspendTaskAfterNumFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendTaskAfterNumFailuresInput() {
        return this._suspendTaskAfterNumFailures;
    }
    get taskAutoRetryAttempts() {
        return this.getNumberAttribute('task_auto_retry_attempts');
    }
    set taskAutoRetryAttempts(value) {
        this._taskAutoRetryAttempts = value;
    }
    resetTaskAutoRetryAttempts() {
        this._taskAutoRetryAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get taskAutoRetryAttemptsInput() {
        return this._taskAutoRetryAttempts;
    }
    get traceLevel() {
        return this.getStringAttribute('trace_level');
    }
    set traceLevel(value) {
        this._traceLevel = value;
    }
    resetTraceLevel() {
        this._traceLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get traceLevelInput() {
        return this._traceLevel;
    }
    get userTaskManagedInitialWarehouseSize() {
        return this.getStringAttribute('user_task_managed_initial_warehouse_size');
    }
    set userTaskManagedInitialWarehouseSize(value) {
        this._userTaskManagedInitialWarehouseSize = value;
    }
    resetUserTaskManagedInitialWarehouseSize() {
        this._userTaskManagedInitialWarehouseSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskManagedInitialWarehouseSizeInput() {
        return this._userTaskManagedInitialWarehouseSize;
    }
    get userTaskMinimumTriggerIntervalInSeconds() {
        return this.getNumberAttribute('user_task_minimum_trigger_interval_in_seconds');
    }
    set userTaskMinimumTriggerIntervalInSeconds(value) {
        this._userTaskMinimumTriggerIntervalInSeconds = value;
    }
    resetUserTaskMinimumTriggerIntervalInSeconds() {
        this._userTaskMinimumTriggerIntervalInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskMinimumTriggerIntervalInSecondsInput() {
        return this._userTaskMinimumTriggerIntervalInSeconds;
    }
    get userTaskTimeoutMs() {
        return this.getNumberAttribute('user_task_timeout_ms');
    }
    set userTaskTimeoutMs(value) {
        this._userTaskTimeoutMs = value;
    }
    resetUserTaskTimeoutMs() {
        this._userTaskTimeoutMs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskTimeoutMsInput() {
        return this._userTaskTimeoutMs;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            as_replica_of: cdktf.stringToTerraform(this._asReplicaOf),
            catalog: cdktf.stringToTerraform(this._catalog),
            comment: cdktf.stringToTerraform(this._comment),
            data_retention_time_in_days: cdktf.numberToTerraform(this._dataRetentionTimeInDays),
            default_ddl_collation: cdktf.stringToTerraform(this._defaultDdlCollation),
            enable_console_output: cdktf.booleanToTerraform(this._enableConsoleOutput),
            external_volume: cdktf.stringToTerraform(this._externalVolume),
            id: cdktf.stringToTerraform(this._id),
            is_transient: cdktf.booleanToTerraform(this._isTransient),
            log_level: cdktf.stringToTerraform(this._logLevel),
            max_data_extension_time_in_days: cdktf.numberToTerraform(this._maxDataExtensionTimeInDays),
            name: cdktf.stringToTerraform(this._name),
            quoted_identifiers_ignore_case: cdktf.booleanToTerraform(this._quotedIdentifiersIgnoreCase),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            storage_serialization_policy: cdktf.stringToTerraform(this._storageSerializationPolicy),
            suspend_task_after_num_failures: cdktf.numberToTerraform(this._suspendTaskAfterNumFailures),
            task_auto_retry_attempts: cdktf.numberToTerraform(this._taskAutoRetryAttempts),
            trace_level: cdktf.stringToTerraform(this._traceLevel),
            user_task_managed_initial_warehouse_size: cdktf.stringToTerraform(this._userTaskManagedInitialWarehouseSize),
            user_task_minimum_trigger_interval_in_seconds: cdktf.numberToTerraform(this._userTaskMinimumTriggerIntervalInSeconds),
            user_task_timeout_ms: cdktf.numberToTerraform(this._userTaskTimeoutMs),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            as_replica_of: {
                value: cdktf.stringToHclTerraform(this._asReplicaOf),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            catalog: {
                value: cdktf.stringToHclTerraform(this._catalog),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            comment: {
                value: cdktf.stringToHclTerraform(this._comment),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            data_retention_time_in_days: {
                value: cdktf.numberToHclTerraform(this._dataRetentionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            default_ddl_collation: {
                value: cdktf.stringToHclTerraform(this._defaultDdlCollation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            enable_console_output: {
                value: cdktf.booleanToHclTerraform(this._enableConsoleOutput),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            external_volume: {
                value: cdktf.stringToHclTerraform(this._externalVolume),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            is_transient: {
                value: cdktf.booleanToHclTerraform(this._isTransient),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            log_level: {
                value: cdktf.stringToHclTerraform(this._logLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            max_data_extension_time_in_days: {
                value: cdktf.numberToHclTerraform(this._maxDataExtensionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            quoted_identifiers_ignore_case: {
                value: cdktf.booleanToHclTerraform(this._quotedIdentifiersIgnoreCase),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            replace_invalid_characters: {
                value: cdktf.booleanToHclTerraform(this._replaceInvalidCharacters),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            storage_serialization_policy: {
                value: cdktf.stringToHclTerraform(this._storageSerializationPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            suspend_task_after_num_failures: {
                value: cdktf.numberToHclTerraform(this._suspendTaskAfterNumFailures),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            task_auto_retry_attempts: {
                value: cdktf.numberToHclTerraform(this._taskAutoRetryAttempts),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            trace_level: {
                value: cdktf.stringToHclTerraform(this._traceLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_task_managed_initial_warehouse_size: {
                value: cdktf.stringToHclTerraform(this._userTaskManagedInitialWarehouseSize),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_task_minimum_trigger_interval_in_seconds: {
                value: cdktf.numberToHclTerraform(this._userTaskMinimumTriggerIntervalInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            user_task_timeout_ms: {
                value: cdktf.numberToHclTerraform(this._userTaskTimeoutMs),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.SecondaryDatabase = SecondaryDatabase;
_a = JSII_RTTI_SYMBOL_1;
SecondaryDatabase[_a] = { fqn: "@cdktf/provider-snowflake.secondaryDatabase.SecondaryDatabase", version: "11.15.0" };
// =================
// STATIC PROPERTIES
// =================
SecondaryDatabase.tfResourceType = "snowflake_secondary_database";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc2Vjb25kYXJ5LWRhdGFiYXNlL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBU0EsK0JBQStCO0FBc0kvQjs7RUFFRTtBQUNGLE1BQWEsaUJBQWtCLFNBQVEsS0FBSyxDQUFDLGlCQUFpQjtJQU81RCxpQkFBaUI7SUFDakIsaUJBQWlCO0lBQ2pCLGlCQUFpQjtJQUNqQjs7Ozs7O01BTUU7SUFDSyxNQUFNLENBQUMsdUJBQXVCLENBQUMsS0FBZ0IsRUFBRSxVQUFrQixFQUFFLFlBQW9CLEVBQUUsUUFBa0M7UUFDOUgsT0FBTyxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLEVBQUUscUJBQXFCLEVBQUUsOEJBQThCLEVBQUUsUUFBUSxFQUFFLFlBQVksRUFBRSxRQUFRLEVBQUUsQ0FBQyxDQUFDO0lBQ3RKLENBQUM7SUFFTCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZDs7Ozs7O01BTUU7SUFDRixZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUErQjtRQUM5RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLDhCQUE4QjtZQUNyRCwwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLFdBQVc7Z0JBQ3pCLGVBQWUsRUFBRSxRQUFRO2dCQUN6Qix5QkFBeUIsRUFBRSxVQUFVO2FBQ3RDO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLFlBQVksRUFBRSxNQUFNLENBQUMsWUFBWTtZQUNqQyxVQUFVLEVBQUUsTUFBTSxDQUFDLFVBQVU7WUFDN0IsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPO1NBQ3hCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxNQUFNLENBQUMsdUJBQXVCLENBQUM7UUFDL0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQztRQUN2RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsTUFBTSxDQUFDLDBCQUEwQixDQUFDO1FBQ3JFLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsNEJBQTRCLEdBQUcsTUFBTSxDQUFDLDJCQUEyQixDQUFDO1FBQ3ZFLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxNQUFNLENBQUMsd0JBQXdCLENBQUM7UUFDakUsSUFBSSxDQUFDLDJCQUEyQixHQUFHLE1BQU0sQ0FBQywwQkFBMEIsQ0FBQztRQUNyRSxJQUFJLENBQUMsNEJBQTRCLEdBQUcsTUFBTSxDQUFDLDJCQUEyQixDQUFDO1FBQ3ZFLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUM7UUFDM0QsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxvQ0FBb0MsR0FBRyxNQUFNLENBQUMsbUNBQW1DLENBQUM7UUFDdkYsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLE1BQU0sQ0FBQyx1Q0FBdUMsQ0FBQztRQUMvRixJQUFJLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDLGlCQUFpQixDQUFDO0lBQ3JELENBQUM7SUFRRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUNELElBQVcsdUJBQXVCLENBQUMsS0FBYTtRQUM5QyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDO0lBQ3hDLENBQUM7SUFDTSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsNEJBQTRCO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLHdCQUF3QixDQUFDO0lBQ3ZDLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWE7UUFDMUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ00sd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxTQUFTLENBQUM7SUFDeEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBSUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUFrQztRQUMvRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFDTSx3QkFBd0I7UUFDN0IsSUFBSSxDQUFDLG9CQUFvQixHQUFHLFNBQVMsQ0FBQztJQUN4QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBYTtRQUNyQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0lBQ00sbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO0lBQ25DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFFRCwwRUFBMEU7SUFDMUUsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBSUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBa0M7UUFDdkQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVywwQkFBMEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBQ0QsSUFBVywwQkFBMEIsQ0FBQyxLQUFhO1FBQ2pELElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUM7SUFDM0MsQ0FBQztJQUNNLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsU0FBUyxDQUFDO0lBQy9DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywrQkFBK0I7UUFDeEMsT0FBTyxJQUFJLENBQUMsMkJBQTJCLENBQUM7SUFDMUMsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUFrQztRQUN2RSxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDO0lBQzVDLENBQUM7SUFDTSxnQ0FBZ0M7UUFDckMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFNBQVMsQ0FBQztJQUNoRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0NBQWdDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLDRCQUE0QixDQUFDO0lBQzNDLENBQUM7SUFJRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQWtDO1FBQ3BFLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUM7SUFDekMsQ0FBQztJQUNNLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsU0FBUyxDQUFDO0lBQzdDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw2QkFBNkI7UUFDdEMsT0FBTyxJQUFJLENBQUMseUJBQXlCLENBQUM7SUFDeEMsQ0FBQztJQUlELElBQVcsMEJBQTBCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakUsQ0FBQztJQUNELElBQVcsMEJBQTBCLENBQUMsS0FBYTtRQUNqRCxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDO0lBQzNDLENBQUM7SUFDTSwrQkFBK0I7UUFDcEMsSUFBSSxDQUFDLDJCQUEyQixHQUFHLFNBQVMsQ0FBQztJQUMvQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsK0JBQStCO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLDJCQUEyQixDQUFDO0lBQzFDLENBQUM7SUFJRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7SUFDRCxJQUFXLDJCQUEyQixDQUFDLEtBQWE7UUFDbEQsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztJQUM1QyxDQUFDO0lBQ00sZ0NBQWdDO1FBQ3JDLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxTQUFTLENBQUM7SUFDaEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdDQUFnQztRQUN6QyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBQ0QsSUFBVyxxQkFBcUIsQ0FBQyxLQUFhO1FBQzVDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUNNLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsU0FBUyxDQUFDO0lBQzFDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywwQkFBMEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsbUNBQW1DO1FBQzVDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDBDQUEwQyxDQUFDLENBQUM7SUFDN0UsQ0FBQztJQUNELElBQVcsbUNBQW1DLENBQUMsS0FBYTtRQUMxRCxJQUFJLENBQUMsb0NBQW9DLEdBQUcsS0FBSyxDQUFDO0lBQ3BELENBQUM7SUFDTSx3Q0FBd0M7UUFDN0MsSUFBSSxDQUFDLG9DQUFvQyxHQUFHLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsd0NBQXdDO1FBQ2pELE9BQU8sSUFBSSxDQUFDLG9DQUFvQyxDQUFDO0lBQ25ELENBQUM7SUFJRCxJQUFXLHVDQUF1QztRQUNoRCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO0lBQ2xGLENBQUM7SUFDRCxJQUFXLHVDQUF1QyxDQUFDLEtBQWE7UUFDOUQsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLEtBQUssQ0FBQztJQUN4RCxDQUFDO0lBQ00sNENBQTRDO1FBQ2pELElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxTQUFTLENBQUM7SUFDNUQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDRDQUE0QztRQUNyRCxPQUFPLElBQUksQ0FBQyx3Q0FBd0MsQ0FBQztJQUN2RCxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsYUFBYSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3pELE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUMvQyxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDL0MsMkJBQTJCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztZQUNuRixxQkFBcUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDO1lBQ3pFLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7WUFDMUUsZUFBZSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQzlELEVBQUUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztZQUNyQyxZQUFZLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDekQsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ2xELCtCQUErQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsMkJBQTJCLENBQUM7WUFDMUYsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLDhCQUE4QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUM7WUFDM0YsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztZQUNwRiw0QkFBNEIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLDJCQUEyQixDQUFDO1lBQ3ZGLCtCQUErQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUM7WUFDM0Ysd0JBQXdCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztZQUM5RSxXQUFXLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDdEQsd0NBQXdDLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxvQ0FBb0MsQ0FBQztZQUM1Ryw2Q0FBNkMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHdDQUF3QyxDQUFDO1lBQ3JILG9CQUFvQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDdkUsQ0FBQztJQUNKLENBQUM7SUFFUyx1QkFBdUI7UUFDL0IsTUFBTSxLQUFLLEdBQUc7WUFDWixhQUFhLEVBQUU7Z0JBQ2IsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO2dCQUNwRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsT0FBTyxFQUFFO2dCQUNQLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztnQkFDaEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELE9BQU8sRUFBRTtnQkFDUCxLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7Z0JBQ2hELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCwyQkFBMkIsRUFBRTtnQkFDM0IsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUM7Z0JBQ2hFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7Z0JBQzVELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7Z0JBQzdELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxlQUFlLEVBQUU7Z0JBQ2YsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO2dCQUN2RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsRUFBRSxFQUFFO2dCQUNGLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztnQkFDM0MsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELFlBQVksRUFBRTtnQkFDWixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7Z0JBQ3JELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFNBQVM7YUFDNUI7WUFDRCxTQUFTLEVBQUU7Z0JBQ1QsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNqRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsK0JBQStCLEVBQUU7Z0JBQy9CLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLDJCQUEyQixDQUFDO2dCQUNuRSxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztnQkFDN0MsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELDhCQUE4QixFQUFFO2dCQUM5QixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztnQkFDckUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELDBCQUEwQixFQUFFO2dCQUMxQixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztnQkFDbEUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELDRCQUE0QixFQUFFO2dCQUM1QixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQywyQkFBMkIsQ0FBQztnQkFDbkUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELCtCQUErQixFQUFFO2dCQUMvQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztnQkFDcEUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELHdCQUF3QixFQUFFO2dCQUN4QixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztnQkFDOUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELFdBQVcsRUFBRTtnQkFDWCxLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7Z0JBQ25ELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCx3Q0FBd0MsRUFBRTtnQkFDeEMsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsb0NBQW9DLENBQUM7Z0JBQzVFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCw2Q0FBNkMsRUFBRTtnQkFDN0MsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsd0NBQXdDLENBQUM7Z0JBQ2hGLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxvQkFBb0IsRUFBRTtnQkFDcEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUM7Z0JBQzFELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7U0FDRixDQUFDO1FBRUYsOEJBQThCO1FBQzlCLE9BQU8sTUFBTSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsQ0FBQyxLQUFLLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssU0FBUyxDQUFFLENBQUMsQ0FBQTtJQUM1SCxDQUFDOztBQTVqQkgsOENBNmpCQzs7O0FBM2pCQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLGdDQUFjLEdBQUcsOEJBQThCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmMuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuICovXG5cbi8vIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZVxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIFNlY29uZGFyeURhdGFiYXNlQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIEEgZnVsbHkgcXVhbGlmaWVkIHBhdGggdG8gYSBkYXRhYmFzZSB0byBjcmVhdGUgYSByZXBsaWNhIGZyb20uIEEgZnVsbHkgcXVhbGlmaWVkIHBhdGggZm9sbG93cyB0aGUgZm9ybWF0IG9mIGBcIjxvcmdhbml6YXRpb25fbmFtZT5cIi5cIjxhY2NvdW50X25hbWU+XCIuXCI8ZGF0YWJhc2VfbmFtZT5cImAuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNhc19yZXBsaWNhX29mIFNlY29uZGFyeURhdGFiYXNlI2FzX3JlcGxpY2Ffb2Z9XG4gICovXG4gIHJlYWRvbmx5IGFzUmVwbGljYU9mOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBkYXRhYmFzZSBwYXJhbWV0ZXIgdGhhdCBzcGVjaWZpZXMgdGhlIGRlZmF1bHQgY2F0YWxvZyB0byB1c2UgZm9yIEljZWJlcmcgdGFibGVzLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtDQVRBTE9HXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi9zcWwtcmVmZXJlbmNlL3BhcmFtZXRlcnMjY2F0YWxvZykuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNjYXRhbG9nIFNlY29uZGFyeURhdGFiYXNlI2NhdGFsb2d9XG4gICovXG4gIHJlYWRvbmx5IGNhdGFsb2c/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyBhIGNvbW1lbnQgZm9yIHRoZSBkYXRhYmFzZS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjk5LjAvZG9jcy9yZXNvdXJjZXMvc2Vjb25kYXJ5X2RhdGFiYXNlI2NvbW1lbnQgU2Vjb25kYXJ5RGF0YWJhc2UjY29tbWVudH1cbiAgKi9cbiAgcmVhZG9ubHkgY29tbWVudD86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSBudW1iZXIgb2YgZGF5cyBmb3Igd2hpY2ggVGltZSBUcmF2ZWwgYWN0aW9ucyAoQ0xPTkUgYW5kIFVORFJPUCkgY2FuIGJlIHBlcmZvcm1lZCBvbiB0aGUgZGF0YWJhc2UsIGFzIHdlbGwgYXMgc3BlY2lmeWluZyB0aGUgZGVmYXVsdCBUaW1lIFRyYXZlbCByZXRlbnRpb24gdGltZSBmb3IgYWxsIHNjaGVtYXMgY3JlYXRlZCBpbiB0aGUgZGF0YWJhc2UuIEZvciBtb3JlIGRldGFpbHMsIHNlZSBbVW5kZXJzdGFuZGluZyAmIFVzaW5nIFRpbWUgVHJhdmVsXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi91c2VyLWd1aWRlL2RhdGEtdGltZS10cmF2ZWwpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjZGF0YV9yZXRlbnRpb25fdGltZV9pbl9kYXlzIFNlY29uZGFyeURhdGFiYXNlI2RhdGFfcmV0ZW50aW9uX3RpbWVfaW5fZGF5c31cbiAgKi9cbiAgcmVhZG9ubHkgZGF0YVJldGVudGlvblRpbWVJbkRheXM/OiBudW1iZXI7XG4gIC8qKlxuICAqIFNwZWNpZmllcyBhIGRlZmF1bHQgY29sbGF0aW9uIHNwZWNpZmljYXRpb24gZm9yIGFsbCBzY2hlbWFzIGFuZCB0YWJsZXMgYWRkZWQgdG8gdGhlIGRhdGFiYXNlLiBJdCBjYW4gYmUgb3ZlcnJpZGRlbiBvbiBzY2hlbWEgb3IgdGFibGUgbGV2ZWwuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW2NvbGxhdGlvbiBzcGVjaWZpY2F0aW9uXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi9zcWwtcmVmZXJlbmNlL2NvbGxhdGlvbiNsYWJlbC1jb2xsYXRpb24tc3BlY2lmaWNhdGlvbikuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNkZWZhdWx0X2RkbF9jb2xsYXRpb24gU2Vjb25kYXJ5RGF0YWJhc2UjZGVmYXVsdF9kZGxfY29sbGF0aW9ufVxuICAqL1xuICByZWFkb25seSBkZWZhdWx0RGRsQ29sbGF0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBJZiB0cnVlLCBlbmFibGVzIHN0ZG91dC9zdGRlcnIgZmFzdCBwYXRoIGxvZ2dpbmcgZm9yIGFub255bW91cyBzdG9yZWQgcHJvY2VkdXJlcy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjk5LjAvZG9jcy9yZXNvdXJjZXMvc2Vjb25kYXJ5X2RhdGFiYXNlI2VuYWJsZV9jb25zb2xlX291dHB1dCBTZWNvbmRhcnlEYXRhYmFzZSNlbmFibGVfY29uc29sZV9vdXRwdXR9XG4gICovXG4gIHJlYWRvbmx5IGVuYWJsZUNvbnNvbGVPdXRwdXQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBkYXRhYmFzZSBwYXJhbWV0ZXIgdGhhdCBzcGVjaWZpZXMgdGhlIGRlZmF1bHQgZXh0ZXJuYWwgdm9sdW1lIHRvIHVzZSBmb3IgSWNlYmVyZyB0YWJsZXMuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0VYVEVSTkFMX1ZPTFVNRV0oaHR0cHM6Ly9kb2NzLnNub3dmbGFrZS5jb20vZW4vc3FsLXJlZmVyZW5jZS9wYXJhbWV0ZXJzI2V4dGVybmFsLXZvbHVtZSkuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNleHRlcm5hbF92b2x1bWUgU2Vjb25kYXJ5RGF0YWJhc2UjZXh0ZXJuYWxfdm9sdW1lfVxuICAqL1xuICByZWFkb25seSBleHRlcm5hbFZvbHVtZT86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjaWQgU2Vjb25kYXJ5RGF0YWJhc2UjaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB0aGUgZGF0YWJhc2UgYXMgdHJhbnNpZW50LiBUcmFuc2llbnQgZGF0YWJhc2VzIGRvIG5vdCBoYXZlIGEgRmFpbC1zYWZlIHBlcmlvZCBzbyB0aGV5IGRvIG5vdCBpbmN1ciBhZGRpdGlvbmFsIHN0b3JhZ2UgY29zdHMgb25jZSB0aGV5IGxlYXZlIFRpbWUgVHJhdmVsOyBob3dldmVyLCB0aGlzIG1lYW5zIHRoZXkgYXJlIGFsc28gbm90IHByb3RlY3RlZCBieSBGYWlsLXNhZmUgaW4gdGhlIGV2ZW50IG9mIGEgZGF0YSBsb3NzLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjaXNfdHJhbnNpZW50IFNlY29uZGFyeURhdGFiYXNlI2lzX3RyYW5zaWVudH1cbiAgKi9cbiAgcmVhZG9ubHkgaXNUcmFuc2llbnQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB0aGUgc2V2ZXJpdHkgbGV2ZWwgb2YgbWVzc2FnZXMgdGhhdCBzaG91bGQgYmUgaW5nZXN0ZWQgYW5kIG1hZGUgYXZhaWxhYmxlIGluIHRoZSBhY3RpdmUgZXZlbnQgdGFibGUuIFZhbGlkIG9wdGlvbnMgYXJlOiBbVFJBQ0UgREVCVUcgSU5GTyBXQVJOIEVSUk9SIEZBVEFMIE9GRl0uIE1lc3NhZ2VzIGF0IHRoZSBzcGVjaWZpZWQgbGV2ZWwgKGFuZCBhdCBtb3JlIHNldmVyZSBsZXZlbHMpIGFyZSBpbmdlc3RlZC4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbTE9HX0xFVkVMXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi9zcWwtcmVmZXJlbmNlL3BhcmFtZXRlcnMuaHRtbCNsYWJlbC1sb2ctbGV2ZWwpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjbG9nX2xldmVsIFNlY29uZGFyeURhdGFiYXNlI2xvZ19sZXZlbH1cbiAgKi9cbiAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE9iamVjdCBwYXJhbWV0ZXIgdGhhdCBzcGVjaWZpZXMgdGhlIG1heGltdW0gbnVtYmVyIG9mIGRheXMgZm9yIHdoaWNoIFNub3dmbGFrZSBjYW4gZXh0ZW5kIHRoZSBkYXRhIHJldGVudGlvbiBwZXJpb2QgZm9yIHRhYmxlcyBpbiB0aGUgZGF0YWJhc2UgdG8gcHJldmVudCBzdHJlYW1zIG9uIHRoZSB0YWJsZXMgZnJvbSBiZWNvbWluZyBzdGFsZS4gRm9yIGEgZGV0YWlsZWQgZGVzY3JpcHRpb24gb2YgdGhpcyBwYXJhbWV0ZXIsIHNlZSBbTUFYX0RBVEFfRVhURU5TSU9OX1RJTUVfSU5fREFZU10oaHR0cHM6Ly9kb2NzLnNub3dmbGFrZS5jb20vZW4vc3FsLXJlZmVyZW5jZS9wYXJhbWV0ZXJzLmh0bWwjbGFiZWwtbWF4LWRhdGEtZXh0ZW5zaW9uLXRpbWUtaW4tZGF5cykuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNtYXhfZGF0YV9leHRlbnNpb25fdGltZV9pbl9kYXlzIFNlY29uZGFyeURhdGFiYXNlI21heF9kYXRhX2V4dGVuc2lvbl90aW1lX2luX2RheXN9XG4gICovXG4gIHJlYWRvbmx5IG1heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzPzogbnVtYmVyO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIGlkZW50aWZpZXIgZm9yIHRoZSBkYXRhYmFzZTsgbXVzdCBiZSB1bmlxdWUgZm9yIHlvdXIgYWNjb3VudC4gQXMgYSBiZXN0IHByYWN0aWNlIGZvciBbRGF0YWJhc2UgUmVwbGljYXRpb24gYW5kIEZhaWxvdmVyXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi91c2VyLWd1aWRlL2RiLXJlcGxpY2F0aW9uLWludHJvKSwgaXQgaXMgcmVjb21tZW5kZWQgdG8gZ2l2ZSBlYWNoIHNlY29uZGFyeSBkYXRhYmFzZSB0aGUgc2FtZSBuYW1lIGFzIGl0cyBwcmltYXJ5IGRhdGFiYXNlLiBUaGlzIHByYWN0aWNlIHN1cHBvcnRzIHJlZmVyZW5jaW5nIGZ1bGx5LXF1YWxpZmllZCBvYmplY3RzIChpLmUuICc8ZGI+LjxzY2hlbWE+LjxvYmplY3Q+JykgYnkgb3RoZXIgb2JqZWN0cyBpbiB0aGUgc2FtZSBkYXRhYmFzZSwgc3VjaCBhcyBxdWVyeWluZyBhIGZ1bGx5LXF1YWxpZmllZCB0YWJsZSBuYW1lIGluIGEgdmlldy4gSWYgYSBzZWNvbmRhcnkgZGF0YWJhc2UgaGFzIGEgZGlmZmVyZW50IG5hbWUgZnJvbSB0aGUgcHJpbWFyeSBkYXRhYmFzZSwgdGhlbiB0aGVzZSBvYmplY3QgcmVmZXJlbmNlcyB3b3VsZCBicmVhayBpbiB0aGUgc2Vjb25kYXJ5IGRhdGFiYXNlLiBEdWUgdG8gdGVjaG5pY2FsIGxpbWl0YXRpb25zIChyZWFkIG1vcmUgW2hlcmVdKGh0dHBzOi8vZ2l0aHViLmNvbS9Tbm93Zmxha2UtTGFicy90ZXJyYWZvcm0tcHJvdmlkZXItc25vd2ZsYWtlL2Jsb2IvbWFpbi9kb2NzL3RlY2huaWNhbC1kb2N1bWVudGF0aW9uL2lkZW50aWZpZXJzX3Jld29ya19kZXNpZ25fZGVjaXNpb25zLm1kI2tub3duLWxpbWl0YXRpb25zLWFuZC1pZGVudGlmaWVyLXJlY29tbWVuZGF0aW9ucykpLCBhdm9pZCB1c2luZyB0aGUgZm9sbG93aW5nIGNoYXJhY3RlcnM6IGB8YCwgYC5gLCBgXCJgXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNuYW1lIFNlY29uZGFyeURhdGFiYXNlI25hbWV9XG4gICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogSWYgdHJ1ZSwgdGhlIGNhc2Ugb2YgcXVvdGVkIGlkZW50aWZpZXJzIGlzIGlnbm9yZWQuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1FVT1RFRF9JREVOVElGSUVSU19JR05PUkVfQ0FTRV0oaHR0cHM6Ly9kb2NzLnNub3dmbGFrZS5jb20vZW4vc3FsLXJlZmVyZW5jZS9wYXJhbWV0ZXJzI3F1b3RlZC1pZGVudGlmaWVycy1pZ25vcmUtY2FzZSkuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSNxdW90ZWRfaWRlbnRpZmllcnNfaWdub3JlX2Nhc2UgU2Vjb25kYXJ5RGF0YWJhc2UjcXVvdGVkX2lkZW50aWZpZXJzX2lnbm9yZV9jYXNlfVxuICAqL1xuICByZWFkb25seSBxdW90ZWRJZGVudGlmaWVyc0lnbm9yZUNhc2U/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB3aGV0aGVyIHRvIHJlcGxhY2UgaW52YWxpZCBVVEYtOCBjaGFyYWN0ZXJzIHdpdGggdGhlIFVuaWNvZGUgcmVwbGFjZW1lbnQgY2hhcmFjdGVyICjvv70pIGluIHF1ZXJ5IHJlc3VsdHMgZm9yIGFuIEljZWJlcmcgdGFibGUuIFlvdSBjYW4gb25seSBzZXQgdGhpcyBwYXJhbWV0ZXIgZm9yIHRhYmxlcyB0aGF0IHVzZSBhbiBleHRlcm5hbCBJY2ViZXJnIGNhdGFsb2cuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1JFUExBQ0VfSU5WQUxJRF9DSEFSQUNURVJTXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi9zcWwtcmVmZXJlbmNlL3BhcmFtZXRlcnMjcmVwbGFjZS1pbnZhbGlkLWNoYXJhY3RlcnMpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjcmVwbGFjZV9pbnZhbGlkX2NoYXJhY3RlcnMgU2Vjb25kYXJ5RGF0YWJhc2UjcmVwbGFjZV9pbnZhbGlkX2NoYXJhY3RlcnN9XG4gICovXG4gIHJlYWRvbmx5IHJlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIHN0b3JhZ2Ugc2VyaWFsaXphdGlvbiBwb2xpY3kgZm9yIEljZWJlcmcgdGFibGVzIHRoYXQgdXNlIFNub3dmbGFrZSBhcyB0aGUgY2F0YWxvZy4gVmFsaWQgb3B0aW9ucyBhcmU6IFtDT01QQVRJQkxFIE9QVElNSVpFRF0uIENPTVBBVElCTEU6IFNub3dmbGFrZSBwZXJmb3JtcyBlbmNvZGluZyBhbmQgY29tcHJlc3Npb24gb2YgZGF0YSBmaWxlcyB0aGF0IGVuc3VyZXMgaW50ZXJvcGVyYWJpbGl0eSB3aXRoIHRoaXJkLXBhcnR5IGNvbXB1dGUgZW5naW5lcy4gT1BUSU1JWkVEOiBTbm93Zmxha2UgcGVyZm9ybXMgZW5jb2RpbmcgYW5kIGNvbXByZXNzaW9uIG9mIGRhdGEgZmlsZXMgdGhhdCBlbnN1cmVzIHRoZSBiZXN0IHRhYmxlIHBlcmZvcm1hbmNlIHdpdGhpbiBTbm93Zmxha2UuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1NUT1JBR0VfU0VSSUFMSVpBVElPTl9QT0xJQ1ldKGh0dHBzOi8vZG9jcy5zbm93Zmxha2UuY29tL2VuL3NxbC1yZWZlcmVuY2UvcGFyYW1ldGVycyNzdG9yYWdlLXNlcmlhbGl6YXRpb24tcG9saWN5KS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjk5LjAvZG9jcy9yZXNvdXJjZXMvc2Vjb25kYXJ5X2RhdGFiYXNlI3N0b3JhZ2Vfc2VyaWFsaXphdGlvbl9wb2xpY3kgU2Vjb25kYXJ5RGF0YWJhc2Ujc3RvcmFnZV9zZXJpYWxpemF0aW9uX3BvbGljeX1cbiAgKi9cbiAgcmVhZG9ubHkgc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3k/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEhvdyBtYW55IHRpbWVzIGEgdGFzayBtdXN0IGZhaWwgaW4gYSByb3cgYmVmb3JlIGl0IGlzIGF1dG9tYXRpY2FsbHkgc3VzcGVuZGVkLiAwIGRpc2FibGVzIGF1dG8tc3VzcGVuZGluZy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbU1VTUEVORF9UQVNLX0FGVEVSX05VTV9GQUlMVVJFU10oaHR0cHM6Ly9kb2NzLnNub3dmbGFrZS5jb20vZW4vc3FsLXJlZmVyZW5jZS9wYXJhbWV0ZXJzI3N1c3BlbmQtdGFzay1hZnRlci1udW0tZmFpbHVyZXMpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2Ujc3VzcGVuZF90YXNrX2FmdGVyX251bV9mYWlsdXJlcyBTZWNvbmRhcnlEYXRhYmFzZSNzdXNwZW5kX3Rhc2tfYWZ0ZXJfbnVtX2ZhaWx1cmVzfVxuICAqL1xuICByZWFkb25seSBzdXNwZW5kVGFza0FmdGVyTnVtRmFpbHVyZXM/OiBudW1iZXI7XG4gIC8qKlxuICAqIE1heGltdW0gYXV0b21hdGljIHJldHJpZXMgYWxsb3dlZCBmb3IgYSB1c2VyIHRhc2suIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW1RBU0tfQVVUT19SRVRSWV9BVFRFTVBUU10oaHR0cHM6Ly9kb2NzLnNub3dmbGFrZS5jb20vZW4vc3FsLXJlZmVyZW5jZS9wYXJhbWV0ZXJzI3Rhc2stYXV0by1yZXRyeS1hdHRlbXB0cykuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSN0YXNrX2F1dG9fcmV0cnlfYXR0ZW1wdHMgU2Vjb25kYXJ5RGF0YWJhc2UjdGFza19hdXRvX3JldHJ5X2F0dGVtcHRzfVxuICAqL1xuICByZWFkb25seSB0YXNrQXV0b1JldHJ5QXR0ZW1wdHM/OiBudW1iZXI7XG4gIC8qKlxuICAqIENvbnRyb2xzIGhvdyB0cmFjZSBldmVudHMgYXJlIGluZ2VzdGVkIGludG8gdGhlIGV2ZW50IHRhYmxlLiBWYWxpZCBvcHRpb25zIGFyZTogW0FMV0FZUyBPTl9FVkVOVCBPRkZdLiBGb3IgaW5mb3JtYXRpb24gYWJvdXQgbGV2ZWxzLCBzZWUgW1RSQUNFX0xFVkVMXShodHRwczovL2RvY3Muc25vd2ZsYWtlLmNvbS9lbi9zcWwtcmVmZXJlbmNlL3BhcmFtZXRlcnMuaHRtbCNsYWJlbC10cmFjZS1sZXZlbCkuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSN0cmFjZV9sZXZlbCBTZWNvbmRhcnlEYXRhYmFzZSN0cmFjZV9sZXZlbH1cbiAgKi9cbiAgcmVhZG9ubHkgdHJhY2VMZXZlbD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGluaXRpYWwgc2l6ZSBvZiB3YXJlaG91c2UgdG8gdXNlIGZvciBtYW5hZ2VkIHdhcmVob3VzZXMgaW4gdGhlIGFic2VuY2Ugb2YgaGlzdG9yeS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVVNFUl9UQVNLX01BTkFHRURfSU5JVElBTF9XQVJFSE9VU0VfU0laRV0oaHR0cHM6Ly9kb2NzLnNub3dmbGFrZS5jb20vZW4vc3FsLXJlZmVyZW5jZS9wYXJhbWV0ZXJzI3VzZXItdGFzay1tYW5hZ2VkLWluaXRpYWwtd2FyZWhvdXNlLXNpemUpLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjdXNlcl90YXNrX21hbmFnZWRfaW5pdGlhbF93YXJlaG91c2Vfc2l6ZSBTZWNvbmRhcnlEYXRhYmFzZSN1c2VyX3Rhc2tfbWFuYWdlZF9pbml0aWFsX3dhcmVob3VzZV9zaXplfVxuICAqL1xuICByZWFkb25seSB1c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZT86IHN0cmluZztcbiAgLyoqXG4gICogTWluaW11bSBhbW91bnQgb2YgdGltZSBiZXR3ZWVuIFRyaWdnZXJlZCBUYXNrIGV4ZWN1dGlvbnMgaW4gc2Vjb25kcy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL3Nub3dmbGFrZS1sYWJzL3Nub3dmbGFrZS8wLjk5LjAvZG9jcy9yZXNvdXJjZXMvc2Vjb25kYXJ5X2RhdGFiYXNlI3VzZXJfdGFza19taW5pbXVtX3RyaWdnZXJfaW50ZXJ2YWxfaW5fc2Vjb25kcyBTZWNvbmRhcnlEYXRhYmFzZSN1c2VyX3Rhc2tfbWluaW11bV90cmlnZ2VyX2ludGVydmFsX2luX3NlY29uZHN9XG4gICovXG4gIHJlYWRvbmx5IHVzZXJUYXNrTWluaW11bVRyaWdnZXJJbnRlcnZhbEluU2Vjb25kcz86IG51bWJlcjtcbiAgLyoqXG4gICogVXNlciB0YXNrIGV4ZWN1dGlvbiB0aW1lb3V0IGluIG1pbGxpc2Vjb25kcy4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBbVVNFUl9UQVNLX1RJTUVPVVRfTVNdKGh0dHBzOi8vZG9jcy5zbm93Zmxha2UuY29tL2VuL3NxbC1yZWZlcmVuY2UvcGFyYW1ldGVycyN1c2VyLXRhc2stdGltZW91dC1tcykuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSN1c2VyX3Rhc2tfdGltZW91dF9tcyBTZWNvbmRhcnlEYXRhYmFzZSN1c2VyX3Rhc2tfdGltZW91dF9tc31cbiAgKi9cbiAgcmVhZG9ubHkgdXNlclRhc2tUaW1lb3V0TXM/OiBudW1iZXI7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSBzbm93Zmxha2Vfc2Vjb25kYXJ5X2RhdGFiYXNlfVxuKi9cbmV4cG9ydCBjbGFzcyBTZWNvbmRhcnlEYXRhYmFzZSBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJzbm93Zmxha2Vfc2Vjb25kYXJ5X2RhdGFiYXNlXCI7XG5cbiAgLy8gPT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIE1ldGhvZHNcbiAgLy8gPT09PT09PT09PT09PT1cbiAgLyoqXG4gICogR2VuZXJhdGVzIENES1RGIGNvZGUgZm9yIGltcG9ydGluZyBhIFNlY29uZGFyeURhdGFiYXNlIHJlc291cmNlIHVwb24gcnVubmluZyBcImNka3RmIHBsYW4gPHN0YWNrLW5hbWU+XCJcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpbXBvcnRUb0lkIFRoZSBjb25zdHJ1Y3QgaWQgdXNlZCBpbiB0aGUgZ2VuZXJhdGVkIGNvbmZpZyBmb3IgdGhlIFNlY29uZGFyeURhdGFiYXNlIHRvIGltcG9ydFxuICAqIEBwYXJhbSBpbXBvcnRGcm9tSWQgVGhlIGlkIG9mIHRoZSBleGlzdGluZyBTZWNvbmRhcnlEYXRhYmFzZSB0aGF0IHNob3VsZCBiZSBpbXBvcnRlZC4gUmVmZXIgdG8gdGhlIHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvc25vd2ZsYWtlLWxhYnMvc25vd2ZsYWtlLzAuOTkuMC9kb2NzL3Jlc291cmNlcy9zZWNvbmRhcnlfZGF0YWJhc2UjaW1wb3J0IGltcG9ydCBzZWN0aW9ufSBpbiB0aGUgZG9jdW1lbnRhdGlvbiBvZiB0aGlzIHJlc291cmNlIGZvciB0aGUgaWQgdG8gdXNlXG4gICogQHBhcmFtIHByb3ZpZGVyPyBPcHRpb25hbCBpbnN0YW5jZSBvZiB0aGUgcHJvdmlkZXIgd2hlcmUgdGhlIFNlY29uZGFyeURhdGFiYXNlIHRvIGltcG9ydCBpcyBmb3VuZFxuICAqL1xuICBwdWJsaWMgc3RhdGljIGdlbmVyYXRlQ29uZmlnRm9ySW1wb3J0KHNjb3BlOiBDb25zdHJ1Y3QsIGltcG9ydFRvSWQ6IHN0cmluZywgaW1wb3J0RnJvbUlkOiBzdHJpbmcsIHByb3ZpZGVyPzogY2RrdGYuVGVycmFmb3JtUHJvdmlkZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZGt0Zi5JbXBvcnRhYmxlUmVzb3VyY2Uoc2NvcGUsIGltcG9ydFRvSWQsIHsgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiBcInNub3dmbGFrZV9zZWNvbmRhcnlfZGF0YWJhc2VcIiwgaW1wb3J0SWQ6IGltcG9ydEZyb21JZCwgcHJvdmlkZXIgfSk7XG4gICAgICB9XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9zbm93Zmxha2UtbGFicy9zbm93Zmxha2UvMC45OS4wL2RvY3MvcmVzb3VyY2VzL3NlY29uZGFyeV9kYXRhYmFzZSBzbm93Zmxha2Vfc2Vjb25kYXJ5X2RhdGFiYXNlfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBTZWNvbmRhcnlEYXRhYmFzZUNvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBTZWNvbmRhcnlEYXRhYmFzZUNvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnc25vd2ZsYWtlX3NlY29uZGFyeV9kYXRhYmFzZScsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdzbm93Zmxha2UnLFxuICAgICAgICBwcm92aWRlclZlcnNpb246ICcwLjk5LjAnLFxuICAgICAgICBwcm92aWRlclZlcnNpb25Db25zdHJhaW50OiAnIH4+IDAuNDAnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGUsXG4gICAgICBwcm92aXNpb25lcnM6IGNvbmZpZy5wcm92aXNpb25lcnMsXG4gICAgICBjb25uZWN0aW9uOiBjb25maWcuY29ubmVjdGlvbixcbiAgICAgIGZvckVhY2g6IGNvbmZpZy5mb3JFYWNoXG4gICAgfSk7XG4gICAgdGhpcy5fYXNSZXBsaWNhT2YgPSBjb25maWcuYXNSZXBsaWNhT2Y7XG4gICAgdGhpcy5fY2F0YWxvZyA9IGNvbmZpZy5jYXRhbG9nO1xuICAgIHRoaXMuX2NvbW1lbnQgPSBjb25maWcuY29tbWVudDtcbiAgICB0aGlzLl9kYXRhUmV0ZW50aW9uVGltZUluRGF5cyA9IGNvbmZpZy5kYXRhUmV0ZW50aW9uVGltZUluRGF5cztcbiAgICB0aGlzLl9kZWZhdWx0RGRsQ29sbGF0aW9uID0gY29uZmlnLmRlZmF1bHREZGxDb2xsYXRpb247XG4gICAgdGhpcy5fZW5hYmxlQ29uc29sZU91dHB1dCA9IGNvbmZpZy5lbmFibGVDb25zb2xlT3V0cHV0O1xuICAgIHRoaXMuX2V4dGVybmFsVm9sdW1lID0gY29uZmlnLmV4dGVybmFsVm9sdW1lO1xuICAgIHRoaXMuX2lkID0gY29uZmlnLmlkO1xuICAgIHRoaXMuX2lzVHJhbnNpZW50ID0gY29uZmlnLmlzVHJhbnNpZW50O1xuICAgIHRoaXMuX2xvZ0xldmVsID0gY29uZmlnLmxvZ0xldmVsO1xuICAgIHRoaXMuX21heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzID0gY29uZmlnLm1heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9xdW90ZWRJZGVudGlmaWVyc0lnbm9yZUNhc2UgPSBjb25maWcucXVvdGVkSWRlbnRpZmllcnNJZ25vcmVDYXNlO1xuICAgIHRoaXMuX3JlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycyA9IGNvbmZpZy5yZXBsYWNlSW52YWxpZENoYXJhY3RlcnM7XG4gICAgdGhpcy5fc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3kgPSBjb25maWcuc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3k7XG4gICAgdGhpcy5fc3VzcGVuZFRhc2tBZnRlck51bUZhaWx1cmVzID0gY29uZmlnLnN1c3BlbmRUYXNrQWZ0ZXJOdW1GYWlsdXJlcztcbiAgICB0aGlzLl90YXNrQXV0b1JldHJ5QXR0ZW1wdHMgPSBjb25maWcudGFza0F1dG9SZXRyeUF0dGVtcHRzO1xuICAgIHRoaXMuX3RyYWNlTGV2ZWwgPSBjb25maWcudHJhY2VMZXZlbDtcbiAgICB0aGlzLl91c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZSA9IGNvbmZpZy51c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZTtcbiAgICB0aGlzLl91c2VyVGFza01pbmltdW1UcmlnZ2VySW50ZXJ2YWxJblNlY29uZHMgPSBjb25maWcudXNlclRhc2tNaW5pbXVtVHJpZ2dlckludGVydmFsSW5TZWNvbmRzO1xuICAgIHRoaXMuX3VzZXJUYXNrVGltZW91dE1zID0gY29uZmlnLnVzZXJUYXNrVGltZW91dE1zO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBhc19yZXBsaWNhX29mIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX2FzUmVwbGljYU9mPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhc1JlcGxpY2FPZigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FzX3JlcGxpY2Ffb2YnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGFzUmVwbGljYU9mKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9hc1JlcGxpY2FPZiA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhc1JlcGxpY2FPZklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9hc1JlcGxpY2FPZjtcbiAgfVxuXG4gIC8vIGNhdGFsb2cgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jYXRhbG9nPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjYXRhbG9nKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY2F0YWxvZycpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2F0YWxvZyh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY2F0YWxvZyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENhdGFsb2coKSB7XG4gICAgdGhpcy5fY2F0YWxvZyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2F0YWxvZ0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jYXRhbG9nO1xuICB9XG5cbiAgLy8gY29tbWVudCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb21tZW50Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjb21tZW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY29tbWVudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgY29tbWVudCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY29tbWVudCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENvbW1lbnQoKSB7XG4gICAgdGhpcy5fY29tbWVudCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY29tbWVudElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jb21tZW50O1xuICB9XG5cbiAgLy8gZGF0YV9yZXRlbnRpb25fdGltZV9pbl9kYXlzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGF0YVJldGVudGlvblRpbWVJbkRheXM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGRhdGFSZXRlbnRpb25UaW1lSW5EYXlzKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnZGF0YV9yZXRlbnRpb25fdGltZV9pbl9kYXlzJyk7XG4gIH1cbiAgcHVibGljIHNldCBkYXRhUmV0ZW50aW9uVGltZUluRGF5cyh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fZGF0YVJldGVudGlvblRpbWVJbkRheXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREYXRhUmV0ZW50aW9uVGltZUluRGF5cygpIHtcbiAgICB0aGlzLl9kYXRhUmV0ZW50aW9uVGltZUluRGF5cyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGF0YVJldGVudGlvblRpbWVJbkRheXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGF0YVJldGVudGlvblRpbWVJbkRheXM7XG4gIH1cblxuICAvLyBkZWZhdWx0X2RkbF9jb2xsYXRpb24gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWZhdWx0RGRsQ29sbGF0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkZWZhdWx0RGRsQ29sbGF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVmYXVsdF9kZGxfY29sbGF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWZhdWx0RGRsQ29sbGF0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZWZhdWx0RGRsQ29sbGF0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVmYXVsdERkbENvbGxhdGlvbigpIHtcbiAgICB0aGlzLl9kZWZhdWx0RGRsQ29sbGF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWZhdWx0RGRsQ29sbGF0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlZmF1bHREZGxDb2xsYXRpb247XG4gIH1cblxuICAvLyBlbmFibGVfY29uc29sZV9vdXRwdXQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lbmFibGVDb25zb2xlT3V0cHV0PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBlbmFibGVDb25zb2xlT3V0cHV0KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV9jb25zb2xlX291dHB1dCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZW5hYmxlQ29uc29sZU91dHB1dCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fZW5hYmxlQ29uc29sZU91dHB1dCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuYWJsZUNvbnNvbGVPdXRwdXQoKSB7XG4gICAgdGhpcy5fZW5hYmxlQ29uc29sZU91dHB1dCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZW5hYmxlQ29uc29sZU91dHB1dElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGVDb25zb2xlT3V0cHV0O1xuICB9XG5cbiAgLy8gZXh0ZXJuYWxfdm9sdW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZXh0ZXJuYWxWb2x1bWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGV4dGVybmFsVm9sdW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZXh0ZXJuYWxfdm9sdW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBleHRlcm5hbFZvbHVtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZXh0ZXJuYWxWb2x1bWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFeHRlcm5hbFZvbHVtZSgpIHtcbiAgICB0aGlzLl9leHRlcm5hbFZvbHVtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZXh0ZXJuYWxWb2x1bWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZXh0ZXJuYWxWb2x1bWU7XG4gIH1cblxuICAvLyBmdWxseV9xdWFsaWZpZWRfbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGZ1bGx5UXVhbGlmaWVkTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Z1bGx5X3F1YWxpZmllZF9uYW1lJyk7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZCgpIHtcbiAgICB0aGlzLl9pZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQ7XG4gIH1cblxuICAvLyBpc190cmFuc2llbnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaXNUcmFuc2llbnQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGlzVHJhbnNpZW50KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2lzX3RyYW5zaWVudCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaXNUcmFuc2llbnQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2lzVHJhbnNpZW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SXNUcmFuc2llbnQoKSB7XG4gICAgdGhpcy5faXNUcmFuc2llbnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlzVHJhbnNpZW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lzVHJhbnNpZW50O1xuICB9XG5cbiAgLy8gbG9nX2xldmVsIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbG9nTGV2ZWw/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGxvZ0xldmVsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbG9nX2xldmVsJyk7XG4gIH1cbiAgcHVibGljIHNldCBsb2dMZXZlbCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbG9nTGV2ZWwgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRMb2dMZXZlbCgpIHtcbiAgICB0aGlzLl9sb2dMZXZlbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbG9nTGV2ZWxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbG9nTGV2ZWw7XG4gIH1cblxuICAvLyBtYXhfZGF0YV9leHRlbnNpb25fdGltZV9pbl9kYXlzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbWF4RGF0YUV4dGVuc2lvblRpbWVJbkRheXM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IG1heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnbWF4X2RhdGFfZXh0ZW5zaW9uX3RpbWVfaW5fZGF5cycpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWF4RGF0YUV4dGVuc2lvblRpbWVJbkRheXModmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX21heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWF4RGF0YUV4dGVuc2lvblRpbWVJbkRheXMoKSB7XG4gICAgdGhpcy5fbWF4RGF0YUV4dGVuc2lvblRpbWVJbkRheXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzO1xuICB9XG5cbiAgLy8gbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9uYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cblxuICAvLyBxdW90ZWRfaWRlbnRpZmllcnNfaWdub3JlX2Nhc2UgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9xdW90ZWRJZGVudGlmaWVyc0lnbm9yZUNhc2U/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHF1b3RlZElkZW50aWZpZXJzSWdub3JlQ2FzZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdxdW90ZWRfaWRlbnRpZmllcnNfaWdub3JlX2Nhc2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHF1b3RlZElkZW50aWZpZXJzSWdub3JlQ2FzZSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcXVvdGVkSWRlbnRpZmllcnNJZ25vcmVDYXNlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UXVvdGVkSWRlbnRpZmllcnNJZ25vcmVDYXNlKCkge1xuICAgIHRoaXMuX3F1b3RlZElkZW50aWZpZXJzSWdub3JlQ2FzZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcXVvdGVkSWRlbnRpZmllcnNJZ25vcmVDYXNlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3F1b3RlZElkZW50aWZpZXJzSWdub3JlQ2FzZTtcbiAgfVxuXG4gIC8vIHJlcGxhY2VfaW52YWxpZF9jaGFyYWN0ZXJzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCByZXBsYWNlSW52YWxpZENoYXJhY3RlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgncmVwbGFjZV9pbnZhbGlkX2NoYXJhY3RlcnMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzKCkge1xuICAgIHRoaXMuX3JlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycztcbiAgfVxuXG4gIC8vIHN0b3JhZ2Vfc2VyaWFsaXphdGlvbl9wb2xpY3kgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zdG9yYWdlU2VyaWFsaXphdGlvblBvbGljeT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3koKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzdG9yYWdlX3NlcmlhbGl6YXRpb25fcG9saWN5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBzdG9yYWdlU2VyaWFsaXphdGlvblBvbGljeSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3kgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTdG9yYWdlU2VyaWFsaXphdGlvblBvbGljeSgpIHtcbiAgICB0aGlzLl9zdG9yYWdlU2VyaWFsaXphdGlvblBvbGljeSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RvcmFnZVNlcmlhbGl6YXRpb25Qb2xpY3k7XG4gIH1cblxuICAvLyBzdXNwZW5kX3Rhc2tfYWZ0ZXJfbnVtX2ZhaWx1cmVzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3VzcGVuZFRhc2tBZnRlck51bUZhaWx1cmVzPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBzdXNwZW5kVGFza0FmdGVyTnVtRmFpbHVyZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdzdXNwZW5kX3Rhc2tfYWZ0ZXJfbnVtX2ZhaWx1cmVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBzdXNwZW5kVGFza0FmdGVyTnVtRmFpbHVyZXModmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3N1c3BlbmRUYXNrQWZ0ZXJOdW1GYWlsdXJlcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN1c3BlbmRUYXNrQWZ0ZXJOdW1GYWlsdXJlcygpIHtcbiAgICB0aGlzLl9zdXNwZW5kVGFza0FmdGVyTnVtRmFpbHVyZXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHN1c3BlbmRUYXNrQWZ0ZXJOdW1GYWlsdXJlc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdXNwZW5kVGFza0FmdGVyTnVtRmFpbHVyZXM7XG4gIH1cblxuICAvLyB0YXNrX2F1dG9fcmV0cnlfYXR0ZW1wdHMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90YXNrQXV0b1JldHJ5QXR0ZW1wdHM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHRhc2tBdXRvUmV0cnlBdHRlbXB0cygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3Rhc2tfYXV0b19yZXRyeV9hdHRlbXB0cycpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGFza0F1dG9SZXRyeUF0dGVtcHRzKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl90YXNrQXV0b1JldHJ5QXR0ZW1wdHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUYXNrQXV0b1JldHJ5QXR0ZW1wdHMoKSB7XG4gICAgdGhpcy5fdGFza0F1dG9SZXRyeUF0dGVtcHRzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0YXNrQXV0b1JldHJ5QXR0ZW1wdHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGFza0F1dG9SZXRyeUF0dGVtcHRzO1xuICB9XG5cbiAgLy8gdHJhY2VfbGV2ZWwgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90cmFjZUxldmVsPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0cmFjZUxldmVsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndHJhY2VfbGV2ZWwnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRyYWNlTGV2ZWwodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3RyYWNlTGV2ZWwgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUcmFjZUxldmVsKCkge1xuICAgIHRoaXMuX3RyYWNlTGV2ZWwgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRyYWNlTGV2ZWxJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdHJhY2VMZXZlbDtcbiAgfVxuXG4gIC8vIHVzZXJfdGFza19tYW5hZ2VkX2luaXRpYWxfd2FyZWhvdXNlX3NpemUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdXNlclRhc2tNYW5hZ2VkSW5pdGlhbFdhcmVob3VzZVNpemUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1c2VyX3Rhc2tfbWFuYWdlZF9pbml0aWFsX3dhcmVob3VzZV9zaXplJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXNlclRhc2tNYW5hZ2VkSW5pdGlhbFdhcmVob3VzZVNpemUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZSgpIHtcbiAgICB0aGlzLl91c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXNlclRhc2tNYW5hZ2VkSW5pdGlhbFdhcmVob3VzZVNpemVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlclRhc2tNYW5hZ2VkSW5pdGlhbFdhcmVob3VzZVNpemU7XG4gIH1cblxuICAvLyB1c2VyX3Rhc2tfbWluaW11bV90cmlnZ2VyX2ludGVydmFsX2luX3NlY29uZHMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91c2VyVGFza01pbmltdW1UcmlnZ2VySW50ZXJ2YWxJblNlY29uZHM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHVzZXJUYXNrTWluaW11bVRyaWdnZXJJbnRlcnZhbEluU2Vjb25kcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3VzZXJfdGFza19taW5pbXVtX3RyaWdnZXJfaW50ZXJ2YWxfaW5fc2Vjb25kcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXNlclRhc2tNaW5pbXVtVHJpZ2dlckludGVydmFsSW5TZWNvbmRzKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl91c2VyVGFza01pbmltdW1UcmlnZ2VySW50ZXJ2YWxJblNlY29uZHMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VyVGFza01pbmltdW1UcmlnZ2VySW50ZXJ2YWxJblNlY29uZHMoKSB7XG4gICAgdGhpcy5fdXNlclRhc2tNaW5pbXVtVHJpZ2dlckludGVydmFsSW5TZWNvbmRzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2VyVGFza01pbmltdW1UcmlnZ2VySW50ZXJ2YWxJblNlY29uZHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlclRhc2tNaW5pbXVtVHJpZ2dlckludGVydmFsSW5TZWNvbmRzO1xuICB9XG5cbiAgLy8gdXNlcl90YXNrX3RpbWVvdXRfbXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91c2VyVGFza1RpbWVvdXRNcz86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdXNlclRhc2tUaW1lb3V0TXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd1c2VyX3Rhc2tfdGltZW91dF9tcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXNlclRhc2tUaW1lb3V0TXModmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3VzZXJUYXNrVGltZW91dE1zID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXNlclRhc2tUaW1lb3V0TXMoKSB7XG4gICAgdGhpcy5fdXNlclRhc2tUaW1lb3V0TXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHVzZXJUYXNrVGltZW91dE1zSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VzZXJUYXNrVGltZW91dE1zO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBhc19yZXBsaWNhX29mOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9hc1JlcGxpY2FPZiksXG4gICAgICBjYXRhbG9nOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jYXRhbG9nKSxcbiAgICAgIGNvbW1lbnQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2NvbW1lbnQpLFxuICAgICAgZGF0YV9yZXRlbnRpb25fdGltZV9pbl9kYXlzOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9kYXRhUmV0ZW50aW9uVGltZUluRGF5cyksXG4gICAgICBkZWZhdWx0X2RkbF9jb2xsYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2RlZmF1bHREZGxDb2xsYXRpb24pLFxuICAgICAgZW5hYmxlX2NvbnNvbGVfb3V0cHV0OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZW5hYmxlQ29uc29sZU91dHB1dCksXG4gICAgICBleHRlcm5hbF92b2x1bWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2V4dGVybmFsVm9sdW1lKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBpc190cmFuc2llbnQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9pc1RyYW5zaWVudCksXG4gICAgICBsb2dfbGV2ZWw6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2xvZ0xldmVsKSxcbiAgICAgIG1heF9kYXRhX2V4dGVuc2lvbl90aW1lX2luX2RheXM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX21heERhdGFFeHRlbnNpb25UaW1lSW5EYXlzKSxcbiAgICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX25hbWUpLFxuICAgICAgcXVvdGVkX2lkZW50aWZpZXJzX2lnbm9yZV9jYXNlOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fcXVvdGVkSWRlbnRpZmllcnNJZ25vcmVDYXNlKSxcbiAgICAgIHJlcGxhY2VfaW52YWxpZF9jaGFyYWN0ZXJzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzKSxcbiAgICAgIHN0b3JhZ2Vfc2VyaWFsaXphdGlvbl9wb2xpY3k6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3N0b3JhZ2VTZXJpYWxpemF0aW9uUG9saWN5KSxcbiAgICAgIHN1c3BlbmRfdGFza19hZnRlcl9udW1fZmFpbHVyZXM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3N1c3BlbmRUYXNrQWZ0ZXJOdW1GYWlsdXJlcyksXG4gICAgICB0YXNrX2F1dG9fcmV0cnlfYXR0ZW1wdHM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3Rhc2tBdXRvUmV0cnlBdHRlbXB0cyksXG4gICAgICB0cmFjZV9sZXZlbDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdHJhY2VMZXZlbCksXG4gICAgICB1c2VyX3Rhc2tfbWFuYWdlZF9pbml0aWFsX3dhcmVob3VzZV9zaXplOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl91c2VyVGFza01hbmFnZWRJbml0aWFsV2FyZWhvdXNlU2l6ZSksXG4gICAgICB1c2VyX3Rhc2tfbWluaW11bV90cmlnZ2VyX2ludGVydmFsX2luX3NlY29uZHM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3VzZXJUYXNrTWluaW11bVRyaWdnZXJJbnRlcnZhbEluU2Vjb25kcyksXG4gICAgICB1c2VyX3Rhc2tfdGltZW91dF9tczogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fdXNlclRhc2tUaW1lb3V0TXMpLFxuICAgIH07XG4gIH1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUhjbEF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIGNvbnN0IGF0dHJzID0ge1xuICAgICAgYXNfcmVwbGljYV9vZjoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fYXNSZXBsaWNhT2YpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBjYXRhbG9nOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9jYXRhbG9nKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgY29tbWVudDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fY29tbWVudCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIGRhdGFfcmV0ZW50aW9uX3RpbWVfaW5fZGF5czoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fZGF0YVJldGVudGlvblRpbWVJbkRheXMpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBkZWZhdWx0X2RkbF9jb2xsYXRpb246IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX2RlZmF1bHREZGxDb2xsYXRpb24pLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBlbmFibGVfY29uc29sZV9vdXRwdXQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9lbmFibGVDb25zb2xlT3V0cHV0KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIGV4dGVybmFsX3ZvbHVtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fZXh0ZXJuYWxWb2x1bWUpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBpZDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5faWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBpc190cmFuc2llbnQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLmJvb2xlYW5Ub0hjbFRlcnJhZm9ybSh0aGlzLl9pc1RyYW5zaWVudCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICBsb2dfbGV2ZWw6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX2xvZ0xldmVsKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbWF4X2RhdGFfZXh0ZW5zaW9uX3RpbWVfaW5fZGF5czoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fbWF4RGF0YUV4dGVuc2lvblRpbWVJbkRheXMpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICBuYW1lOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9uYW1lKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgcXVvdGVkX2lkZW50aWZpZXJzX2lnbm9yZV9jYXNlOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fcXVvdGVkSWRlbnRpZmllcnNJZ25vcmVDYXNlKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHJlcGxhY2VfaW52YWxpZF9jaGFyYWN0ZXJzOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5ib29sZWFuVG9IY2xUZXJyYWZvcm0odGhpcy5fcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwiYm9vbGVhblwiLFxuICAgICAgfSxcbiAgICAgIHN0b3JhZ2Vfc2VyaWFsaXphdGlvbl9wb2xpY3k6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3N0b3JhZ2VTZXJpYWxpemF0aW9uUG9saWN5KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgc3VzcGVuZF90YXNrX2FmdGVyX251bV9mYWlsdXJlczoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fc3VzcGVuZFRhc2tBZnRlck51bUZhaWx1cmVzKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwibnVtYmVyXCIsXG4gICAgICB9LFxuICAgICAgdGFza19hdXRvX3JldHJ5X2F0dGVtcHRzOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl90YXNrQXV0b1JldHJ5QXR0ZW1wdHMpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICB0cmFjZV9sZXZlbDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fdHJhY2VMZXZlbCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIHVzZXJfdGFza19tYW5hZ2VkX2luaXRpYWxfd2FyZWhvdXNlX3NpemU6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3VzZXJUYXNrTWFuYWdlZEluaXRpYWxXYXJlaG91c2VTaXplKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgdXNlcl90YXNrX21pbmltdW1fdHJpZ2dlcl9pbnRlcnZhbF9pbl9zZWNvbmRzOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5udW1iZXJUb0hjbFRlcnJhZm9ybSh0aGlzLl91c2VyVGFza01pbmltdW1UcmlnZ2VySW50ZXJ2YWxJblNlY29uZHMpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgICB1c2VyX3Rhc2tfdGltZW91dF9tczoge1xuICAgICAgICB2YWx1ZTogY2RrdGYubnVtYmVyVG9IY2xUZXJyYWZvcm0odGhpcy5fdXNlclRhc2tUaW1lb3V0TXMpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJudW1iZXJcIixcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIC8vIHJlbW92ZSB1bmRlZmluZWQgYXR0cmlidXRlc1xuICAgIHJldHVybiBPYmplY3QuZnJvbUVudHJpZXMoT2JqZWN0LmVudHJpZXMoYXR0cnMpLmZpbHRlcigoW18sIHZhbHVlXSkgPT4gdmFsdWUgIT09IHVuZGVmaW5lZCAmJiB2YWx1ZS52YWx1ZSAhPT0gdW5kZWZpbmVkICkpXG4gIH1cbn1cbiJdfQ==